package com.jw.app.store.action.share;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.jw.app.business.StoreShareBusiness;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 457085804248399898L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertStoreShare() throws BusinessException {

		StoreShareBusiness business = BusinessManager.getBusiness(StoreShareBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);	
			//去除不要更新的字段
			entity.remove("OPETYPE");
			//新增
			business.insert_share(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
				sysbusiness.insert_logBusiness("insertStoreShare", "" + entity,
						"增加个人文件共享", (String) entity.get("UUID"), (String) entity
								.get("FILE_NAME"), "storeShare");
			//	
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateStoreShare() throws BusinessException {

		StoreShareBusiness business = BusinessManager.getBusiness(StoreShareBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			//修改
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
			business.update_share(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateStoreShare", "" + entity, 
					"修改个人文件共享",(String) entity.get("UUID"), (String) entity
					          .get("FILE_NAME"),"storeShare");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteStoreShare() throws BusinessException {

		StoreShareBusiness business = BusinessManager.getBusiness(StoreShareBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.delete_share(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteStoreShare", "" + ListKey,
					"软删除个人文件共享", deletekey, "多个流水号","storeShare");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("软删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("软删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String resumeStoreShare() throws BusinessException {

		StoreShareBusiness business = BusinessManager.getBusiness(StoreShareBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.resume_share(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("resumeStoreShare", "" + ListKey,
					"恢复网盘公司文件共享", deletekey, "多个流水号","storeShare");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("恢复成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("恢复失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteTrueStoreShare() throws BusinessException {

		StoreShareBusiness business = BusinessManager.getBusiness(StoreShareBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);		
		try {
			business.delete_true_share(ListKey);
			
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			//sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			sysbusiness.insert_logBusiness("deleteTrueStoreShare", "" + ListKey,
					"清除个人文件共享", deletekey, "多个流水号","storeShare");
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
}
