package com.jw.app.store.action.user;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import net.sf.json.JSONObject;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.jw.app.business.StoreUserBusiness;

public class actAction extends BasicAction {
	/**
	 * 
	 */
	private static final long serialVersionUID = -8753354889246159256L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertStoreUser() throws BusinessException {

		StoreUserBusiness business = BusinessManager.getBusiness(StoreUserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);	
			//去除不要更新的字段
			entity.remove("OPETYPE");
			//查询是否重复
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("USER_ID", entity.get("USER_ID"));
			int listDataCount = business.listCount_user(query);
			if(listDataCount>0){
				jsonObject.putAll(Status.getStatusSuccessMessage("保存失败,当前人员已经开盘"));
			}else{
				//新增
				business.insert_user(entity);
				// 操作日志
				SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
					sysbusiness.insert_logBusiness("insertStoreUser", "" + entity,
							"增加个人开盘信息", (String) entity.get("UUID"), (String) entity
									.get("FILE_NAME"), "storeUser");
				//	
				jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
			}
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateStoreUser() throws BusinessException {

		StoreUserBusiness business = BusinessManager.getBusiness(StoreUserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			//修改
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
			business.update_user(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateStoreUser", "" + entity, 
					"修改个人开盘信息",(String) entity.get("UUID"), (String) entity
					          .get("FILE_NAME"),"storeUser");
			//
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteStoreUser() throws BusinessException {

		StoreUserBusiness business = BusinessManager.getBusiness(StoreUserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.delete_user(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteStoreUser", "" + ListKey,
					"删除个人开盘信息", deletekey, "多个流水号","storeUser");
			//
			
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 重新检正用户容量
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateStoreUserSize() throws BusinessException {

		StoreUserBusiness business = BusinessManager.getBusiness(StoreUserBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String updatekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(updatekey);
		
		try {
			if(StringUtils.isNotEmpty(updatekey)){
				for(String key:updatekey.split(",")){
					Map<String,Object> udata = new HashMap<String,Object>();
					udata.put("CREATOR_ID", key);
					business.update_user_size(udata);
				}
				// 操作日志
				SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
				sysbusiness.insert_logBusiness("updateStoreUserSize", "" + ListKey,
						"重新检正用户已用容量", updatekey, "多个流水号","storeUser");
				//
			}
			jsonObject.putAll(Status.getStatusSuccessMessage("检正成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("检正失败"));
			e.printStackTrace();
		}
		return "json";
	}
}
