package com.jw.app.todo.action;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.BeanUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.jw.app.business.TodoBusiness;

import net.sf.json.JSONObject;

public class actAction extends BasicAction {

	private static final long serialVersionUID = -2591076090760872233L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertInfo() throws BusinessException {

		TodoBusiness business = BusinessManager.getBusiness(TodoBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);

		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 新增
			if (entity.get("RECIPIENTS") != null && !"".equals(entity.get("RECIPIENTS"))) {
				String recipients=entity.get("RECIPIENTS").toString();
				entity.remove("RECIPIENTS");
				for(String recipient:recipients.split(",")){
					Map<String, Object> entityNew=new HashMap<String, Object>();
					entityNew.putAll(entity);
					entityNew.put("RECIPIENT", recipient);
					business.insert(entityNew);
				}
			}

			// 操作日志
			// sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("insertTodo", "" + entity, "增加系统代办", (String) entity.get("UUID"), (String) entity.get("TITLE"), "todo");
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateInfo() throws BusinessException {
		TodoBusiness business = BusinessManager.getBusiness(TodoBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateTodo", "" + entity, "修改系统代办", (String) entity.get("UUID"), (String) entity.get("TITLE"), "todo");
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteInfo() throws BusinessException {

		TodoBusiness business = BusinessManager.getBusiness(TodoBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);

		try {
			business.delete(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteTodo", "" + ListKey, "删除系统代办", deletekey, "多个流水号", "todo");
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	public String updateDoState() throws BusinessException {
		TodoBusiness business = BusinessManager.getBusiness(TodoBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 修改
			entity = QueryParamUtil.StringToDate(entity);
			entity.put("DO_STATE", 1);
			entity.put("DO_TIME", new Date());
			business.update(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateDoState", "" + entity, "修改系统代办状态为已办", (String) entity.get("UUID"), (String) entity.get("TITLE"), "todo");
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

}
