package com.jw.app.todo.action;

import java.util.Date;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.TodoBusiness;

public class viewAction extends BasicAction {
	private static final long serialVersionUID = -6259964352154128000L;

	/**
	 * 普通代办列表页
	 * 
	 * @return
	 * @throws BusinessException
	 * @date 2018-09-05 下午2:03:38
	 * @author luosz@jfbrother.com
	 */
	public String todoTab() throws BusinessException {
		// 如果用户传过来type属性，也可以定位到对应的流程/oa列表
		if ("1".equals(request.getParameter("type")) || "".equals("2".equals(request.getParameter("type")))) {
			request.setAttribute("type", request.getParameter("type"));
		} else {
			request.setAttribute("type", 0);
		}
		return "todoTab";
	}

	/**
	 * 流程代办列表页
	 * 
	 * @return
	 * @throws BusinessException
	 * @date 2018-09-05 下午2:03:47
	 * @author luosz@jfbrother.com
	 */
	public String todoProcTab() throws BusinessException {
		request.setAttribute("type", 1);
		return "todoTab";
	}

	/**
	 * Oa代办列表页
	 * 
	 * @return
	 * @throws BusinessException
	 * @date 2018-09-05 下午2:03:56
	 * @author luosz@jfbrother.com
	 */
	public String todoOaTab() throws BusinessException {
		request.setAttribute("type", 2);
		return "todoTab";
	}

	public String todoTabDetail() throws BusinessException {
		Map<String, Object> entity = RequestUtils.getUpdateFieldMapUtf8(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		if (SessionUtil.getCode().equals(entity.get("RECIPIENT")) && "0".equals(entity.get("READ_STATE"))) {
			// 如果当前登录人为接收人，并且未读，则将状态改为已读，并记录阅读时间
			entity.put("READ_STATE", 1);
			entity.put("READ_TIME", new Date());
			TodoBusiness business = BusinessManager.getBusiness(TodoBusiness.class);
			business.update(entity);
		}
		return "todoTabDetail";
	}
}
