package com.jw.app.vote.action;

import java.util.List;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import com.jw.app.business.VoteBusiness;
import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;
import com.gaowj.standard.utils.CacheKit;

public class actAction extends BasicAction {

	private static final long serialVersionUID = -2591076090760872233L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	/**
	 * 插入
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertVote() throws BusinessException {

		VoteBusiness business = BusinessManager.getBusiness(VoteBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);

		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 新增
			business.insert_vote(entity);

			// 操作日志
			// sysbusiness.insert_logBusiness(具体方法，操作内容，操作描述，操作记录ID，操作记录中文描述，分类)
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("insertVote", "" + entity, "增加投票主题", (String) entity.get("UUID"),
					(String) entity.get("CONTENT"), "votedemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 插入用户投票
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertUserVote() throws BusinessException {

		VoteBusiness business = BusinessManager.getBusiness(VoteBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);

		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 新增
			business.insert_userVote(entity);

			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateVote() throws BusinessException {

		VoteBusiness business = BusinessManager.getBusiness(VoteBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update_vote(entity);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("updateVote", "" + entity, "修改投票主题", (String) entity.get("UUID"),
					(String) entity.get("CONTENT"), "votedemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 更新
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String endVote() throws BusinessException {

		VoteBusiness business = BusinessManager.getBusiness(VoteBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		try {

			// 去除不要更新的字段
			entity.remove("OPETYPE");
			// 修改
			entity = QueryParamUtil.StringToDate(entity);
			business.update_endVote(entity);
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 在软删除基础上删除记录
	 * 
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteVote() throws BusinessException {

		VoteBusiness business = BusinessManager.getBusiness(VoteBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request, RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);

		try {
			business.delete_vote(ListKey);
			// 操作日志
			SystemOpeBusiness sysbusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
			sysbusiness.insert_logBusiness("deleteVote", "" + ListKey, "删除投票主题", deletekey, "多个流水号", "votedemo1");
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}

}
