package com.gaowj.business;


import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

/**
 * 后台操作
 * @author 高伟杰
 * @time 2014-05-13
 */
@Service
public interface SystemOpeBusiness {
	
	/**
	 * 登陆时获取登陆人的所有可操作模块
	 */
    String getUserAllModule(String uCode) throws BusinessException;
    /**
	 *选取top菜单
	 */
    List<Map<String,Object>> getTopMenu(String mids) throws BusinessException ;
    /**
	 *获取left1级菜单
	 */
    List<Map<String,Object>> getLeftMenu1(String mids,String mtID) throws BusinessException ;
    /**
	 *获取left2级菜单
	 */
    List<Map<String,Object>> getLeftMenu2(String mids,String mtID,String menu1) throws BusinessException ;
    /**
	 *用户信息
	 */
    Page<Map<String, Object>> listLoginUserInfo(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    List<Map<String,Object>> listLoginUserInfo(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String,Object>> listLoginUserInfo(String emid,String pass) throws BusinessException ;
    
    int listLoginUserInfoCount(Map<String, Object> query) throws BusinessException ;
    
    Map<String,Object> getMaxLoginUserCode(Map<String,Object> query) throws BusinessException ;
    
    Map<String,Object> getMaxLoginUserEmid(Map<String,Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listLoginServiceUserInfo(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    List<Map<String,Object>> listLoginServiceUserInfo(Map<String, Object> query) throws BusinessException ;
    
    List<Map<String,Object>> listLoginServiceUserInfo(String emid,String pass) throws BusinessException ;
    
    int listLoginServiceUserInfoCount(Map<String, Object> query) throws BusinessException ;
    
    /**
     * 用户增加
     */
    void insert_user(Map<String,Object> entity) throws BusinessException ;
    /**
     * 用户修改
     */
    void update_user(Map<String,Object> entity) throws BusinessException ;
    /**
     * 用户删除
     */
    void delete_user(Map<String,Object> entity) throws BusinessException ;
    
    void delete_batch_user(List<Map<String, Object>> list) throws BusinessException ;
    
    /**
     * 部门信息
     * 
     */
    Page<Map<String, Object>> listDepartmentInfo(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    List<Map<String,Object>> listDepartmentInfo(Map<String,Object> query) throws BusinessException ;
    
    int listDepartmentInfoCount(Map<String, Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listDepartmentSericeInfo(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    List<Map<String,Object>> listDepartmentSericeInfo(Map<String,Object> query) throws BusinessException ;
    
    int listDepartmentServiceInfoCount(Map<String, Object> query) throws BusinessException ;
    
    /**
     * 部门增加
     */
    void insert_depart(Map<String,Object> entity) throws BusinessException ;
    /**
     * 部门修改
     */
    void update_depart(Map<String,Object> entity) throws BusinessException ;
    /**
     * 部门删除
     */
    void delete_depart(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 *密码修改
	 */
    void modifyPass(Map<String,Object> entity) throws BusinessException ;
    /**
	 *功能组增加
	 */
    void insert_group(Map<String,Object> entity) throws BusinessException ;
    /**
	 *功能组修改
	 */
    void update_group(Map<String,Object> entity) throws BusinessException ;
    /**
	 *功能组删除
	 */
    void delete_group(String gid) throws BusinessException ;
     /**
	 *功能组显示所有
	 */
    Page<Map<String, Object>> listGroupAll(int pageNo, int pageSize, Map<String, Object> query) throws BusinessException ;

    List<Map<String,Object>> listGroupAll(Map<String, Object> query) throws BusinessException ;
    /**
	 *模块新增
	 */
    void insert_module(Map<String,Object> entity) throws BusinessException ;

    /**
	 *模块修改
	 */
    void update_module(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块删除
	 */
    void delete_module(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块显示所有
	 */
    List<Map<String,Object>> listModule(Map<String, Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listModule(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;

    /**
	 *模块大类显示所有
	 */
    List<Map<String,Object>> listModuleType(Map<String, Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listModuleType(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;

    /**
	 *模块大类新增
	 */
    void insert_moduleType(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块大类修改
	 */
    void update_moduleType(Map<String,Object> entity) throws BusinessException ;
    /**
	 *模块大类删除
	 */
    void delete_moduleType(Map<String,Object> entity) throws BusinessException ;

    /**
	 *功能组模块选定-增加
	 */
    void insert_group_c_m(Map<String,Object> entity) throws BusinessException;
    /**
	 *功能组模块选定-删除
	 */
    void delete_group_c_m(Map<String,Object> entity) throws BusinessException ;

    /**
	 *功能组模块选定-显示对应组的所有模块
	 */
     List<Map<String,Object>> listGroupM_from_G(Map<String, Object> query) throws BusinessException ;

    /**
	 *功能组人员选定-增加
	 */
    void insert_group_c_u(Map<String,Object> entity) throws BusinessException ;
    /**
	 *功能组人员选定-删除
	 */
    void delete_group_c_u(Map<String,Object> entity) throws BusinessException ;

    /**
	 *功能组人员选定-显示对应组的所有人员
	 */
    List<Map<String,Object>> listGroupU_from_G(Map<String, Object> query) throws BusinessException ;

	/**
	 *人管人-显示对应管理者管理的所有人员
	 */
    List<Map<String,Object>> listPerson_from_P(Map<String, Object> query) throws BusinessException ;
    
    /**
     * 人管人-增加
     */
    void insert_person_p(Map<String,Object> entity) throws BusinessException ;
    /**
     * 人管人-删除
     */
    void delete_person_p(Map<String,Object> entity) throws BusinessException ;

    
    /**
	 *日志信息
	 */
    List<Map<String,Object>> listLogInfo(Map<String, Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listLogInfo(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 增加日志
	 */
	void insert_log(Map<String,Object> entity) throws BusinessException ;
	
	/**
	 *log4j日志信息
	 */
    List<Map<String,Object>> listLog4jInfo(Map<String, Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listLog4jInfo(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 增加log4j日志
	 */
	void insert_log4j(Map<String,Object> entity) throws BusinessException ;
	
	/**
	 *业务操作日志信息
	 */
    List<Map<String,Object>> listLogBusiness(Map<String, Object> query) throws BusinessException ;
    
    Page<Map<String, Object>> listLogBusiness(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 增加日志
	 */
	void insert_logBusiness(Map<String,Object> entity) throws BusinessException ;
	
	void insert_logBusiness(String modules,String ope,String desc,String recordid,String recordname,String type) throws BusinessException ;

}
