package com.gaowj.business;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface UploadfileBusiness {

	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_uploadfile(Map<String,Object> entity) throws BusinessException ;

	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
    void update_uploadfile(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 * 设置binary_data大字段为空
	 * @param entity
	 * @throws BusinessException
	 */
    void setnull_binary_data(List<String> list) throws BusinessException ;
    
    /**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_uploadfile(List<String> list)throws BusinessException;
    
    /**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
    void resume_uploadfile(List<String> list)throws BusinessException;
    
    /**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_true_uploadfile(List<String> list)throws BusinessException;
    
    /**
	 * 分页获取记录没有file大字段
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_uploadnofile(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录没有file大字段
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_uploadnofile(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_uploadfile(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_uploadfile(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_uploadfile(Map<String, Object> query) throws BusinessException ;
    
    /**---------------供其它模块接口使用-------------------**/
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_uploadnofile_webservices(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_uploadnofile_webservices(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_uploadfile_common(Map<String, Object> query)throws BusinessException;
    
    /**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
    void resume_uploadfile_common(Map<String, Object> query)throws BusinessException;
    
    /**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_true_uploadfile_common(Map<String, Object> query)throws BusinessException;
}
