package com.gaowj.business.frontapi;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.FrontapiBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.SessionUtil;

public class FrontapiBusinessImpl implements FrontapiBusiness {

	private frontapiDAO frontapiDAO;
	
	public frontapiDAO getFrontapiDAO() {
		return frontapiDAO;
	}

	public void setFrontapiDAO(frontapiDAO frontapiDAO) {
		this.frontapiDAO = frontapiDAO;
	}

	@Override
	public void insert_api(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UUID")==null){
			entity.put("UUID", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATOR_ID")==null){
			entity.put("CREATOR_ID", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
          frontapiDAO.insert_api(entity);
        }
	}

	@Override
	public void update_api(Map<String, Object> entity) throws BusinessException {
		if(entity.get("UPDATE_ID")==null){
			entity.put("UPDATE_ID", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("UUID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
		    frontapiDAO.update_api(entity);
		}

	}
	
	@Override
	public void delete_api(List<String> list) throws BusinessException {
		frontapiDAO.delete_api(list);
		
	}
	
	@Override
	public void resume_api(List<String> list) throws BusinessException {
		frontapiDAO.resume_api(list);
		
	}
	
	@Override
	public void delete_true_api(List<String> list) throws BusinessException {
		frontapiDAO.delete_true_api(list);
		
	}

	@Override
	public Page<Map<String, Object>> list_api(int pageNo, int pageSize,Map<String, Object> query) throws BusinessException {
		//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = frontapiDAO.list_api(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = listCount_api(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
	}

	@Override
	public List<Map<String, Object>> list_api(Map<String, Object> query) throws BusinessException {
		return frontapiDAO.list_api(query);
	}

	@Override
	public int listCount_api(Map<String, Object> query) throws BusinessException {
		return frontapiDAO.listCount_api(query);
	}

}
