package com.gaowj.business.system;


import java.sql.Clob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.util.Encipher;
import com.gaowj.business.util.Java_tool;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.PropUtil;
import com.gaowj.business.util.SessionUtil;




/**
 * 后台操作
 * @author 高伟杰
 * @time 2014-05-13
 */

public class SystemOpeBusinessImpl implements SystemOpeBusiness{

	private SystemBackDAO systemBackDAO;
	
	private SqlSession systemSession;
	
	public SqlSession getSystemSession() {
		return systemSession;
	}
	public void setSystemSession(SqlSession systemSession) {
		this.systemSession = systemSession;
	}
	public SystemBackDAO getSystemBackDAO() {
		return systemBackDAO;
	}
	public void setSystemBackDAO(SystemBackDAO systemBackDAO) {
		this.systemBackDAO = systemBackDAO;
	}
	/**
	 *登陆时获取登陆人的所有可操作模块
	 *2014-05-13
	 */
    public String getUserAllModule(String uCode){
    	String mids="";//所有模块
    	List<Map<String,Object>> list = systemBackDAO.getUserAllModule(uCode);
    	for (Map<String,Object> map : list){
    		if(map.get("M_ID")!=null)mids=mids+"'"+(String)map.get("M_ID")+"',";
    	}
    	if(mids.trim().length()>0){
    		mids=mids.substring(0,mids.trim().length()-1);
    	}
    	return mids;
    }
    /**
	 *选取top菜单
	 */
    public List<Map<String,Object>> getTopMenu(String mids){
    	Map<String,Object> query = new HashMap<String,Object>();
    	query.put("MIDS", mids);
    	return systemBackDAO.getTopMenu(query);
    }
    /**
	 *获取left1级菜单
	 */
    public List<Map<String,Object>> getLeftMenu1(String mids,String mtID){
    	Map<String,Object> query = new HashMap<String,Object>();
    	query.put("MIDS", mids);
    	query.put("MTID", mtID);
    	return systemBackDAO.getLeftMenu1(query);
    }
    /**
	 *获取left2级菜单
	 */
    public List<Map<String,Object>> getLeftMenu2(String mids,String mtID,String menu1){
    	Map<String,Object> query = new HashMap<String,Object>();
    	query.put("MIDS", mids);
    	query.put("MTID", mtID);
    	query.put("MENU1", menu1);
    	return systemBackDAO.getLeftMenu2(query);
    }
    /**
	 *用户信息
	 */
    public Page<Map<String,Object>> listLoginUserInfo(int pageNo, int pageSize, Map<String, Object> query){
    	
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listLoginUserInfo(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listLoginUserInfoCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
    	
    }
    
    public List<Map<String,Object>> listLoginUserInfo(Map<String, Object> query){
		return systemBackDAO.listLoginUserInfo(query);
	}
    
    public List<Map<String,Object>> listLoginUserInfo(String emid,String empass){
    	Map<String,Object> query = new HashMap<String,Object>();
    	query.put("EMID",emid);
    	query.put("EMPASS",empass);
		return systemBackDAO.listLoginUserInfo(query);
	}
    
    public int listLoginUserInfoCount(Map<String, Object> query){
    	return systemBackDAO.listLoginUserInfoCount(query);
    }
    
    public Page<Map<String,Object>> listLoginServiceUserInfo(int pageNo, int pageSize, Map<String, Object> query){
    	
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listLoginServiceUserInfo(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listLoginServiceUserInfoCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
    	
    }
    
    public List<Map<String,Object>> listLoginServiceUserInfo(Map<String, Object> query){
		return systemBackDAO.listLoginServiceUserInfo(query);
	}
    
    public List<Map<String,Object>> listLoginServiceUserInfo(String emid,String empass){
    	Map<String,Object> query = new HashMap<String,Object>();
    	query.put("EMID",emid);
    	query.put("EMPASS",empass);
		return systemBackDAO.listLoginServiceUserInfo(query);
	}
    
    public int listLoginServiceUserInfoCount(Map<String, Object> query){
    	return systemBackDAO.listLoginServiceUserInfoCount(query);
    }
    
    /**
     * 用户增加
     */
    public void insert_user(Map<String,Object> entity){
    	if(entity.get("CODE")==null){
			entity.put("CODE", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_USER")==null){
			entity.put("CREATE_USER", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("UPDATE_USER")==null){
			entity.put("UPDATE_USER", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		entity.put("EMPASS", Encipher.EncodePasswd(PropUtil.getValue("userDefaultPass","quartz_service",entity.get("CODE").toString())));
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
    	  systemBackDAO.insert_user(entity);
        }
    }
    /**
     * 用户修改
     */
    public void update_user(Map<String,Object> entity){
    	if(entity.get("UPDATE_USER")==null){
			entity.put("UPDATE_USER", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("CODE",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
    	    systemBackDAO.update_user(entity);
		}
    }
    /**
     * 用户删除
     */
    public void delete_user(Map<String,Object> entity){
    	systemBackDAO.delete_user(entity);
    }
    
    /**
     * 用户批量删除
     */
    public void delete_batch_user(List<Map<String, Object>> list){
    	
    	List<String> idList = new ArrayList<String>(list.size());
    	for(Map<String,Object>m : list){
    		String code =  (String) m.get("CODE");
    		idList.add(code);
    	}
    	systemBackDAO.delete_batch_user(idList);
    }
    
    public Map<String,Object> getMaxLoginUserCode(Map<String,Object> query){
    	Map<String,Object> m = systemBackDAO.getMaxLoginUserCode(query);
    	if(m==null){
    		m=new HashMap<String,Object>();
    		m.put("MAXCODE", StringUtils.upperCase(query.get("EMDEPART").toString())+"001");
        	return m;	
    	}
    	Object maxcode = m.get("MAXCODE");
    	Java_tool jt = new Java_tool();
    	if(maxcode!=null){
    		maxcode=jt.getNum_sn(StringUtils.upperCase(query.get("EMDEPART").toString()), 3, Integer.parseInt(maxcode.toString().substring(1))+1);
    	}else{
    		maxcode = StringUtils.upperCase(query.get("EMDEPART").toString())+"001";
    	}
    	m.put("MAXCODE", maxcode);
    	return m;
    }
    
    public Map<String,Object> getMaxLoginUserEmid(Map<String,Object> query){
    	Map<String,Object> m = systemBackDAO.getMaxLoginUserEmid(query);
    	if(m==null){
    		m=new HashMap<String,Object>();
    		m.put("MAXEMID", StringUtils.upperCase(query.get("EMDEPART").toString())+"001");
        	return m;	
    	}
    	Object maxemid = m.get("MAXEMID");
    	Java_tool jt = new Java_tool();
    	if(maxemid!=null){
    		maxemid=jt.getNum_sn(StringUtils.upperCase(query.get("EMDEPART").toString()), 3, Integer.parseInt(maxemid.toString().substring(1))+1);
    	}else{
    		maxemid = StringUtils.upperCase(query.get("EMDEPART").toString())+"001";
    	}
    	m.put("MAXEMID", maxemid);
    	return m;
    }
    
    /**
     * 部门信息
     * 
     */
    
    public Page<Map<String,Object>> listDepartmentInfo(int pageNo, int pageSize, Map<String, Object> query){
    	
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listDepartmentInfo(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listDepartmentInfoCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
    	
    }
    
    public List<Map<String,Object>> listDepartmentInfo(Map<String, Object> query){
    	return systemBackDAO.listDepartmentInfo(query);
    }
    
    public int listDepartmentInfoCount(Map<String, Object> query){
    	return systemBackDAO.listDepartmentInfoCount(query);
    }
    
    public Page<Map<String,Object>> listDepartmentSericeInfo(int pageNo, int pageSize, Map<String, Object> query){
    	
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listDepartmentSericeInfo(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listDepartmentServiceInfoCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
    	
    }
    
    public List<Map<String,Object>> listDepartmentSericeInfo(Map<String, Object> query){
    	return systemBackDAO.listDepartmentSericeInfo(query);
    }
    
    public int listDepartmentServiceInfoCount(Map<String, Object> query){
    	return systemBackDAO.listDepartmentServiceInfoCount(query);
    }
    
    /**
     * 部门增加
     */
    public void insert_depart(Map<String,Object> entity){
    	if(entity.get("DPT_NO")==null){
			entity.put("DPT_NO", java.util.UUID.randomUUID().toString());
		}
		if(entity.get("CREATE_USER")==null){
			entity.put("CREATE_USER", SessionUtil.getCode());
		}
		if(entity.get("CREATE_TIME")==null){
			entity.put("CREATE_TIME", new Date());
		}
		if(entity.get("UPDATE_USER")==null){
			entity.put("UPDATE_USER", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		if(entity.get("DELETE_FLAG")==null){
			entity.put("DELETE_FLAG", "0");
		}
		//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
    	  systemBackDAO.insert_depart(entity);
        }
    }
    /**
     * 部门修改
     */
    public void update_depart(Map<String,Object> entity){
    	if(entity.get("UPDATE_USER")==null){
			entity.put("UPDATE_USER", SessionUtil.getCode());
		}
		if(entity.get("UPDATE_TIME")==null){
			entity.put("UPDATE_TIME", new Date());
		}
		//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("DPT_NO",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
    	    systemBackDAO.update_depart(entity);
		}
    }
    /**
     * 部门删除
     */
    public void delete_depart(Map<String,Object> entity){
    	systemBackDAO.delete_depart(entity);
    }
    
    /**
	 *密码修改
	 */
    public void modifyPass(Map<String,Object> entity){
    	systemBackDAO.modifyPass(entity);
    }
    /**
     * 功能组增加
     * 
     */
    public void insert_group(Map<String,Object> entity){
    	//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
    	  systemBackDAO.insert_group(entity);
        }
    }
    /**
     *功能组修改
     * @param list
     */
    public void update_group(Map<String,Object> entity){
    	//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("G_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
    	    systemBackDAO.update_group(entity);
		}
    }
    /**
     * 功能组删除
     * @param gid
     */
    public void delete_group(String gid){
    	systemBackDAO.delete_group(gid);
    }
    /**
	 *功能组显示所有
	 */
      public Page<Map<String, Object>> listGroupAll(int pageNo, int pageSize, Map<String, Object> query){
  	  
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listGroupAll(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listGroupAllCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
      }
      /**
       * 功能组显示所有(用于选择)
       * @return
       */
    public List<Map<String,Object>> listGroupAll(Map<String, Object> query){
		return systemBackDAO.listGroupAll(query);
	}

    /**
     * 模块新增
     * 
     */
    public void insert_module(Map<String,Object> entity){
    	//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
    	  systemBackDAO.insert_module(entity);
        }
    }
    
    /**
     * 模块修改
     * 
     */
    public void update_module(Map<String,Object> entity){
    	//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("M_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
    	    systemBackDAO.update_module(entity);
    	}
    }
    /**
     * 模块删除
     * 
     */
    public void delete_module(Map<String,Object> entity){
    	systemBackDAO.delete_module(entity);
    }

     /**
     * 模块显示所有
     */
     public Page<Map<String, Object>> listModule(int pageNo, int pageSize, Map<String, Object> query){
    	//计算起始记录
   		int pageStart = (pageNo - 1) * pageSize;
   		
   		//获取列表
   		List<Map<String, Object>> items = systemBackDAO.listModule(new RowBounds(pageStart, pageSize), query);
   		//获取列表个数
   		int count = systemBackDAO.listModuleCount(query);
   		
   		//创建分页对象
   		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
   		page.setStart(pageStart);
   		page.setLimit(pageSize);
   		page.setCount(count);
   		page.setItems(items);

   		return page;
    }
     
     public List<Map<String,Object>> listModule(Map<String, Object> query){
    	 return systemBackDAO.listModule(query);
     }

    /**
     * 模块大类显示所有     
     */
    public Page<Map<String, Object>> listModuleType(int pageNo, int pageSize, Map<String, Object> query){
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listModuleType(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listModuleTypeCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
    }
    
    /**
     * 模块大类显示所有-选择
     * @return
     */
    public List<Map<String,Object>> listModuleType(Map<String, Object> query){
    	
		return systemBackDAO.listModuleType(query);
    }

    //模块大类新增
    public void insert_moduleType(Map<String,Object> entity){
    	//动态传值插入
		List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        if(entity.keySet()!=null){
          Set<String> key  = entity.keySet();
          // 将map集合中的key和value 取出来分别放到list集合里
          for (String str : key) {
            infoList.add(entity.get(str));
            infoListKey.add(str);
          }
          entity.put("infoListKey", infoListKey);
          entity.put("infoList", infoList);
          // 插入
    	  systemBackDAO.insert_moduleType(entity);
        }
    }
    //模块大类修改
    public void update_moduleType(Map<String,Object> entity){
    	//动态传值修改
		List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
		if(entity.keySet()!=null){
			Set<String> key = entity.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
		    for (String str : key) {
			   Map<String, Object> updateMap = new HashMap<String, Object>();
			   if (StringUtils.equalsIgnoreCase("MT_ID",str)) continue;
			   updateMap.put("key", str);
			   updateMap.put("value", entity.get(str));

			   updateList.add(updateMap);
		    }
		    entity.put("info", updateList);
            //
    	    systemBackDAO.update_moduleType(entity);
    	}
    }
    //模块大类删除
    public void delete_moduleType(Map<String,Object> entity){
    	systemBackDAO.delete_moduleType(entity);
    }

    /**
     * 功能组模块选定-增加
     */
    public void insert_group_c_m(Map<String,Object> entity){
    	
    	if(entity==null) {return;}
    	else{
    		//取最大序号
        	Integer maxGm = systemBackDAO.getMaxGm(null);
        	if(maxGm == null){
        		maxGm = 1;
        	}else{
        		maxGm=maxGm+1;
        	}
        	//
        	entity.put("GM", maxGm);
    	    systemBackDAO.insert_group_c_m(entity);
    	}
    }
    /**
     * 功能组模块选定-删除
     * @param map
     * 
     */
    public void delete_group_c_m(Map<String,Object> entity){
    	systemBackDAO.delete_group_c_m(entity);
    }

    
    /**
     *功能组模块选定-显示对应组的所有模块
     * 
     */
    public List<Map<String,Object>> listGroupM_from_G(Map<String, Object> query){

    	return systemBackDAO.listGroupM_from_G(query);
    }

    /**
     * 功能组人员选定-增加
     */
    public void insert_group_c_u(Map<String,Object> entity){
    	if(entity==null) {return;}
    	else{
    		//取最大序号
        	Integer maxGu = systemBackDAO.getMaxGu(null);
        	if(maxGu == null){
        		maxGu = 1;
        	}else{
        		maxGu=maxGu+1;
        	}
        	//
        	entity.put("GU", maxGu);
    	    systemBackDAO.insert_group_c_u(entity);
    	}
    }
    /**
     * 
     * 功能组人员选定-删除
     */
    public void delete_group_c_u(Map<String,Object> entity){
    	systemBackDAO.delete_group_c_u(entity);
    }

    /**
     * 功能组人员选定-显示对应组的所有人员
     */
    public List<Map<String,Object>> listGroupU_from_G(Map<String, Object> query){
    	return systemBackDAO.listGroupU_from_G(query);
    }

	/**
	 * 人管人-显示对应管理者管理的所有人员
	 */
    public List<Map<String,Object>> listPerson_from_P(Map<String, Object> query){
    	return systemBackDAO.listPerson_from_P(query);
    }
    /**
     * 人管人-增加
     */
    public void insert_person_p(Map<String,Object> entity){
    	systemBackDAO.insert_person_p(entity);
    }
    /**
     * 人管人-删除
     */
    public void delete_person_p(Map<String,Object> entity){
    	systemBackDAO.delete_person_p(entity);
    }

    
    /**
	 *日志信息
	 */
      public Page<Map<String, Object>> listLogInfo(int pageNo, int pageSize, Map<String, Object> query){
  	  
    	//计算起始记录
  		int pageStart = (pageNo - 1) * pageSize;
  		
//  		List<Map<String, Object>> items = CacheKit.get("ehcache1", "listLogInfo");
//  		if(items == null){
//  			items = systemBackDAO.listLogInfo(new RowBounds(pageStart, pageSize), query);
//  			CacheKit.put("ehcache1", "listLogInfo", items);
//  		}
  		
  		
  		//获取列表
  		List<Map<String, Object>> items = systemBackDAO.listLogInfo(new RowBounds(pageStart, pageSize), query);
  		//获取列表个数
  		int count = systemBackDAO.listLogInfoCount(query);
  		
  		//创建分页对象
  		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
  		page.setStart(pageStart);
  		page.setLimit(pageSize);
  		page.setCount(count);
  		page.setItems(items);

  		return page;
      }
      
      public List<Map<String, Object>> listLogInfo(Map<String, Object> query){
    	  return systemBackDAO.listLogInfo(query);
      }
      
      public void insert_log(Map<String,Object> entity){
    	if(entity==null) {return;}
      	else{
      		//取最大序号
          	Integer maxLog = systemBackDAO.getMaxLog(null);
          	if(maxLog == null){
          		maxLog = 1;
          	}else{
          		maxLog=maxLog+1;
          	}
          	//
          	entity.put("ID", maxLog);
      	    systemBackDAO.insert_log(entity);
      	}
      }
      
      /**
  	 *log4j日志信息
  	 */
        public Page<Map<String, Object>> listLog4jInfo(int pageNo, int pageSize, Map<String, Object> query){
    	  
      	//计算起始记录
    		int pageStart = (pageNo - 1) * pageSize;
    		
    		//获取列表
    		List<Map<String, Object>> items = systemBackDAO.listLog4jInfo(new RowBounds(pageStart, pageSize), query);
    		//获取列表个数
    		int count = systemBackDAO.listLog4jInfoCount(query);
    		
    		//创建分页对象
    		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
    		page.setStart(pageStart);
    		page.setLimit(pageSize);
    		page.setCount(count);
    		page.setItems(items);

    		return page;
        }
        
        @SuppressWarnings("static-access")
		public List<Map<String, Object>> listLog4jInfo(Map<String, Object> query){
        	List<Map<String, Object>> l = systemBackDAO.listLog4jInfo(query);
        	Java_tool jt = new Java_tool();
        	for(Map<String, Object> m:l){
        		if(m.get("LOGTHROWABLE")!=null && m.get("LOGTHROWABLE") instanceof java.sql.Clob){
        			m.put("LOGTHROWABLE", jt.clob2String((Clob) m.get("LOGTHROWABLE")));
        		}
        		if(m.get("LOGNDC")!=null && m.get("LOGNDC") instanceof java.sql.Clob){
        			m.put("LOGNDC", jt.clob2String((Clob) m.get("LOGNDC")));
        		}
        	}
      	  return l;
        }
        
        public void insert_log4j(Map<String,Object> entity){
      	if(entity==null) {return;}
        	else{
        		//取最大序号
            	Integer maxLog = systemBackDAO.getMaxLog4j(null);
            	if(maxLog == null){
            		maxLog = 1;
            	}else{
            		maxLog=maxLog+1;
            	}
            	//
            	entity.put("ID", maxLog);
        	    systemBackDAO.insert_log4j(entity);
        	}
        }
        
        /**
    	 *业务操作日志信息
    	 */
          public Page<Map<String, Object>> listLogBusiness(int pageNo, int pageSize, Map<String, Object> query){
      	  
        	//计算起始记录
      		int pageStart = (pageNo - 1) * pageSize;
      		
      		//获取列表
      		List<Map<String, Object>> items = systemBackDAO.listLogBusiness(new RowBounds(pageStart, pageSize), query);
      		//获取列表个数
      		int count = systemBackDAO.listLogBusinessCount(query);
      		
      		//创建分页对象
      		Page<Map<String, Object>> page = new Page<Map<String, Object>>();
      		page.setStart(pageStart);
      		page.setLimit(pageSize);
      		page.setCount(count);
      		page.setItems(items);

      		return page;
          }
          
          public List<Map<String, Object>> listLogBusiness(Map<String, Object> query){
        	  List<Map<String, Object>> l = systemBackDAO.listLogBusiness(query);
        	  Java_tool jt = new Java_tool();
          	  for(Map<String, Object> m:l){
          		if(m.get("OPE")!=null && m.get("OPE") instanceof java.sql.Clob){
          			m.put("OPE", jt.clob2String((Clob) m.get("OPE")));
          		}
          	  }
        	  return l;
          }
          
          public void insert_logBusiness(Map<String,Object> entity){
        	if(entity==null) {return;}
          	else{
          		if(entity.get("UUID")==null){
        			entity.put("UUID", java.util.UUID.randomUUID().toString());
        		}
        		if(entity.get("OPETIME")==null){
        			entity.put("OPETIME", new Date());
        		}
        		if(entity.get("USERID")==null){
        			entity.put("USERID", SessionUtil.getCode());
        		}
        		if(entity.get("IP")==null){
        			entity.put("IP", SessionUtil.getClientIp());
        		}
          	    systemBackDAO.insert_logBusiness(entity);
          	}
          }
          
          public void insert_logBusiness(String modules,String ope,String desc,String recordid,String recordname,String type){
        	  Map<String,Object> entity  = new HashMap<String,Object>();
        	  entity.put("MODULES", modules);
        	  entity.put("OPE", ope);
        	  entity.put("DESCRIPTION", desc);
        	  entity.put("RECORDID", recordid);
        	  entity.put("TYPE", type);
        	  entity.put("RECORDNAME", recordname);
        	  insert_logBusiness(entity);
          }
}
