package com.gaowj.system.frontapi;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

import com.gaowj.business.FrontapiBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.Status;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2578940032314230771L;
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	public String insertFrontapi() throws BusinessException {

		FrontapiBusiness business = BusinessManager.getBusiness(FrontapiBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		jsonObject = new JSONObject();
		try {
			entity = QueryParamUtil.StringToDate(entity);	
			//去除不要更新的字段
			entity.remove("OPETYPE");
			//新增
			business.insert_api(entity);	
			jsonObject.putAll(Status.getStatusSuccessMessage("保存成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("保存失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
	public String updateFrontapi() throws BusinessException {

		FrontapiBusiness business = BusinessManager.getBusiness(FrontapiBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			//修改
			entity = QueryParamUtil.StringToDate(entity);
			//去除不要更新的字段
			entity.remove("OPETYPE");
			business.update_api(entity);
			jsonObject.putAll(Status.getStatusSuccessMessage("修改成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("修改失败"));
			e.printStackTrace();
		}
		return "json";
	}

	/**
	 * 软删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteFrontapi() throws BusinessException {

		FrontapiBusiness business = BusinessManager.getBusiness(FrontapiBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.delete_api(ListKey);		
			jsonObject.putAll(Status.getStatusSuccessMessage("软删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("软删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 恢复删除
	 * @param entity
	 * @throws BusinessException
	 */
	public String resumeFrontapi() throws BusinessException {

		FrontapiBusiness business = BusinessManager.getBusiness(FrontapiBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);
		
		try {
			business.resume_api(ListKey);		
			jsonObject.putAll(Status.getStatusSuccessMessage("恢复成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("恢复失败"));
			e.printStackTrace();
		}
		return "json";
	}
	
	/**
	 * 在软删除基础上删除记录
	 * @param entity
	 * @throws BusinessException
	 */
	public String deleteTrueFrontapi() throws BusinessException {

		FrontapiBusiness business = BusinessManager.getBusiness(FrontapiBusiness.class);
		Map<String, Object> entity = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		String deletekey = (String) entity.get("CODE");
		List<String> ListKey = QueryParamUtil.StringToList(deletekey);		
		try {
			business.delete_true_api(ListKey);
			jsonObject.putAll(Status.getStatusSuccessMessage("删除成功"));
		} catch (Exception e) {
			jsonObject.putAll(Status.getStatusErrorMessage("删除失败"));
			e.printStackTrace();
		}
		return "json";
	}
}
