package com.gaowj.util;

import org.springframework.stereotype.Component;

import com.github.stuxuhai.jpinyin.ChineseHelper;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;

@Component
public class JPinyin4jUtil {

    /**
     * 转换为有声调的拼音字符串
     * @param pinYinStr 汉字
     * @return 有声调的拼音字符串
     */
    public String changeToMarkPinYin(String pinYinStr){

        String tempStr = null;

        try 
        {
            tempStr =  PinyinHelper.convertToPinyinString(pinYinStr,  " ", PinyinFormat.WITH_TONE_MARK);

        } catch (Exception e)
        {
            e.printStackTrace();
        }
        return tempStr;

    }


    /**
     * 转换为数字声调字符串
     * @param pinYinStr 需转换的汉字
     * @return 转换完成的拼音字符串
     */
    public String changeToNumberPinYin(String pinYinStr){

        String tempStr = null;

        try 
        {
            tempStr = PinyinHelper.convertToPinyinString(pinYinStr, " ", PinyinFormat.WITH_TONE_NUMBER);
        } catch (Exception e) 
        {
            e.printStackTrace();
        }

        return tempStr;

    }

    /**
     * 转换为不带音调的拼音字符串
     * @param pinYinStr 需转换的汉字
     * @return 拼音字符串
     */
    public String changeToTonePinYin(String pinYinStr){

        String tempStr = null;

        try {
            tempStr =  PinyinHelper.convertToPinyinString(pinYinStr, " ", PinyinFormat.WITHOUT_TONE);
        } catch (Exception e)
        {
            e.printStackTrace();
        }
        return tempStr;

    }
    
    /**
     * 转换为不带音调的拼音字符串,没有空格
     * @param pinYinStr 需转换的汉字
     * @return 拼音字符串
     */
    public String changeToTonePinYinTrim(String pinYinStr){

        String tempStr = null;

        try {
            tempStr =  PinyinHelper.convertToPinyinString(pinYinStr, "", PinyinFormat.WITHOUT_TONE);
        } catch (Exception e)
        {
            e.printStackTrace();
        }
        return tempStr;

    }

    /**
     * 转换为每个汉字对应拼音首字母字符串
     * @param pinYinStr 需转换的汉字
     * @return 拼音字符串
     */
    public String changeToGetShortPinYin(String pinYinStr){

        String tempStr = null;

        try 
        {
            tempStr = PinyinHelper.getShortPinyin(pinYinStr);
        } catch (Exception e) 
        {
            e.printStackTrace();
        }
        return tempStr;

    }

    /**
     * 检查汉字是否为多音字
     * @param pinYinStr 需检查的汉字
     * @return true 多音字，false 不是多音字
     */
    public boolean checkPinYin(char pinYinStr){

        boolean check  = false;
        try
        {
            check = PinyinHelper.hasMultiPinyin(pinYinStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return check;
    }

    /**
     * 简体转换为繁体
     * @param pinYinStr
     * @return
     */
    public String changeToTraditional(String pinYinStr){

        String tempStr = null;
        try 
        {
            tempStr = ChineseHelper.convertToTraditionalChinese(pinYinStr);
        } catch (Exception e) 
        {
            e.printStackTrace();
        }
        return tempStr;

    }

    /**
     * 繁体转换为简体
     * @param pinYinSt
     * @return
     */
    public String changeToSimplified(String pinYinSt){

        String tempStr = null;

        try 
        {
            tempStr = ChineseHelper.convertToSimplifiedChinese(pinYinSt);
        } catch (Exception e) 
        {
            e.printStackTrace();
        }

        return tempStr;

    }
    /** 
     * 将字符串转换成ASCII码 
     *  
     * @param cnStr 
     * @return String 
     */  
    public String getCnASCII(String cnStr) {  
        StringBuffer strBuf = new StringBuffer();  
        // 将字符串转换成字节序列  
        byte[] bGBK = cnStr.getBytes();  
        for (int i = 0; i < bGBK.length; i++) {  
            // System.out.println(Integer.toHexString(bGBK[i] & 0xff));  
            // 将每个字符转换成ASCII码  
            strBuf.append(Integer.toHexString(bGBK[i] & 0xff));  
        }  
        return strBuf.toString();  
    }

  public static void main(String[] args) {
      String str = "重慶 most input";
      JPinyin4jUtil jp = new JPinyin4jUtil();
//      System.out.println(jp.changeToSimplified(str));
//      System.out.println(jp.checkPinYin('重'));
//      
//      System.out.println(jp.changeToGetShortPinYin("重"));
      System.out.println((jp.changeToTonePinYin("niyou重量")));
//      System.out.println(jp.changeToNumberPinYin("长盛基金"));
//      System.out.println(jp.changeToMarkPinYin("长盛基金"));
//      System.out.println(jp.getCnASCII("重"));
  }
}
