/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.comp;

import com.gaowj.business.comp.BusinessFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractBusinessFactory
implements BusinessFactory {
    private Log log = LogFactory.getLog(AbstractBusinessFactory.class);
    protected Map<Class<?>, Object> businessMap;

    @Override
    public void init(Properties prop) {
        this.businessMap = new HashMap();
        if (prop == null) {
            return;
        }
        this.log.info((Object)"\u4e1a\u52a1\u63a5\u53e3\u5f00\u59cb\u52a0\u8f7d...");
        int i = 0;
        while (true) {
            try {
                String interfaceName = prop.getProperty("business." + i + ".interfaceName");
                String applicationName = prop.getProperty("business." + i + ".applicationName");
                String referenceName = prop.getProperty("business." + i + ".referenceName");
                if (interfaceName == null || interfaceName.length() == 0) break;
                if (referenceName == null || referenceName.length() == 0) {
                    throw new RuntimeException("Business reference name is null.");
                }
                Class<?> interfaceClazz = Class.forName(interfaceName);
                Object bean = this.getBusinessInternal(applicationName, referenceName);
                this.addBusiness(interfaceClazz, bean);
                this.log.info((Object)("Business successfully registered: " + interfaceName));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.log.info((Object)"\u4e1a\u52a1\u63a5\u53e3\u52a0\u8f7d\u7ed3\u675f...");
    }

    @Override
    public void destroy() {
        this.businessMap = null;
    }

    protected abstract Object getBusinessInternal(String var1, String var2);

    protected void addBusiness(Class<?> interfaceClazz, Object bean) {
        if (bean == null) {
            throw new NullPointerException("Bean[" + interfaceClazz + "] is not found");
        }
        if (!interfaceClazz.isInstance(bean)) {
            throw new ClassCastException("Bean[" + bean + "] is not an instance of business interface[" + interfaceClazz + "]");
        }
        this.businessMap.put(interfaceClazz, bean);
    }

    @Override
    public <T> T getBusiness(Class<T> clazz) {
        Object result = this.businessMap.get(clazz);
        if (result == null) {
            throw new RuntimeException("Could not find business instance: " + clazz);
        }
        return (T)result;
    }
}

