/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.comp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMTool {
    public static Document createNewDocument() {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return document;
    }

    public static Document loadDocumentFromStr(String s) {
        Document document = null;
        try {
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(s.getBytes());
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(bytearrayinputstream));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document loadDocumentFromStr(String s, String s1) {
        Document document = null;
        if (s == null || s.indexOf(">") < 0) {
            return null;
        }
        try {
            ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(s.getBytes(s1));
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(bytearrayinputstream));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document loadDocumentFromFile(File file) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document loadDocumentFromInputStream(InputStream inputstream) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputstream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static Document loadDocumentFromUri(String s) {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static void appendChild(Node node, Node node1) {
        node.appendChild(node1);
    }

    public static boolean containsNode(Node node, String s) {
        return DOMTool.getSingleNode(node, s) != null;
    }

    public static Node getSingleNode(Node node, String s) {
        if (node == null || s == null) {
            return null;
        }
        Node node1 = null;
        NodeList nodelist = null;
        nodelist = node instanceof Document ? ((Document)node).getElementsByTagName(s) : ((Element)node).getElementsByTagName(s);
        if (nodelist != null && nodelist.getLength() > 0) {
            node1 = nodelist.item(0);
        }
        return node1;
    }

    public static Element getSingleElement(Node node, String s) {
        Element element = null;
        if (DOMTool.containsNode(node, s)) {
            element = (Element)DOMTool.getSingleNode(node, s);
        }
        return element;
    }

    public static NodeList getMultiNodes(Node node, String s) {
        if (node == null || s == null) {
            return null;
        }
        NodeList nodelist = null;
        nodelist = node instanceof Document ? ((Document)node).getElementsByTagName(s) : ((Element)node).getElementsByTagName(s);
        return nodelist;
    }

    public static Node getNode(Node node, String s, int i) {
        if (node == null || s == null || i < 0) {
            return null;
        }
        Node node1 = null;
        NodeList nodelist = DOMTool.getMultiNodes(node, s);
        if (i < nodelist.getLength()) {
            node1 = nodelist.item(i);
        }
        return node1;
    }

    public static Element getElement(Node node, String s, int i) {
        Node node1 = DOMTool.getNode(node, s, i);
        if (node1 == null) {
            return null;
        }
        return (Element)node1;
    }

    public static String getNodeValue(Node node) {
        if (node == null || node instanceof Document) {
            return null;
        }
        NodeList nodelist = node.getChildNodes();
        if (nodelist.getLength() <= 0) {
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node1 = nodelist.item(i);
            if (node1.getNodeType() == 3) {
                stringbuffer.append(node1.getNodeValue());
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static String getSingleNodeValue(Node node, String s) {
        Node node1 = DOMTool.getSingleNode(node, s);
        return DOMTool.getNodeValue(node1);
    }

    public static String[] getMultiNodeValues(Node node, String s) {
        NodeList nodelist = DOMTool.getMultiNodes(node, s);
        if (nodelist == null) {
            return new String[0];
        }
        String[] as = new String[nodelist.getLength()];
        int i = 0;
        while (i < nodelist.getLength()) {
            as[i] = DOMTool.getNodeValue(nodelist.item(i));
            ++i;
        }
        return as;
    }

    public static String getAttributeValue(Element element, String s) {
        if (element == null || s == null) {
            return null;
        }
        return element.getAttribute(s);
    }

    public static HashMap getAttributeValues(Element element) {
        HashMap<String, String> hashmap = new HashMap<String, String>();
        NamedNodeMap namednodemap = element.getAttributes();
        int i = 0;
        while (i < namednodemap.getLength()) {
            Attr attr = (Attr)namednodemap.item(i);
            hashmap.put(attr.getName(), attr.getValue());
            ++i;
        }
        return hashmap;
    }

    public static String getSingleAttributeValue(Node node, String s, String s1) {
        String s2 = null;
        Element element = DOMTool.getSingleElement(node, s);
        if (element != null) {
            s2 = element.getAttribute(s1);
        }
        return s2;
    }

    public static String[] getMultiAttributeValue(Node node, String s, String s1) {
        NodeList nodelist = DOMTool.getMultiNodes(node, s);
        if (nodelist == null) {
            return new String[0];
        }
        String[] as = new String[nodelist.getLength()];
        int i = 0;
        while (i < nodelist.getLength()) {
            as[i] = DOMTool.getAttributeValue((Element)nodelist.item(i), s1);
            ++i;
        }
        return as;
    }

    public static Element createElement(Document document, String s, String s1) {
        if (document == null || s == null) {
            return null;
        }
        Element element = document.createElement(s);
        DOMTool.setNodeValue(element, s1);
        return element;
    }

    public static Element createAndAppendRoot(Document document, String s, String s1) {
        if (document == null || s == null) {
            return null;
        }
        Element element = document.createElement(s);
        document.appendChild(element);
        DOMTool.setNodeValue(element, s1);
        return element;
    }

    public static Element createAndAppendElement(Node node, String s, String s1) {
        if (node == null || s == null) {
            return null;
        }
        Document document = null;
        document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement(s);
        node.appendChild(element);
        DOMTool.setNodeValue(element, s1);
        return element;
    }

    public static void createAndAppendMultiElement(Node node, String s, String[] as) {
        if (node == null || s == null || as == null || as.length == 0 || node instanceof Document) {
            return;
        }
        Document document = node.getOwnerDocument();
        int i = 0;
        while (i < as.length) {
            Element element = document.createElement(s);
            node.appendChild(element);
            DOMTool.setNodeValue(element, as[i]);
            ++i;
        }
    }

    public static void setNodeValue(Node node, String s) {
        if (node == null || node instanceof Document) {
            return;
        }
        Document document = node.getOwnerDocument();
        NodeList nodelist = node.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node1 = nodelist.item(i);
            if (node1.getNodeType() == 3) {
                node.removeChild(node1);
            }
            ++i;
        }
        if (s != null) {
            node.appendChild(document.createTextNode(s));
        }
    }

    public static void setSingleNodeValue(Node node, String s, String s1) {
        Node node1 = DOMTool.getSingleNode(node, s);
        if (node1 != null) {
            DOMTool.setNodeValue(node1, s1);
        }
    }

    public static void setAttribute(Element element, String s, String s1) {
        if (element != null && s != null) {
            element.setAttribute(s, s1);
        }
    }

    public static void setAttributes(Element element, HashMap hashmap) {
        if (element == null || hashmap == null) {
            return;
        }
        Iterator iterator = hashmap.keySet().iterator();
        while (iterator.hasNext()) {
            String s = iterator.next().toString();
            element.setAttribute(s, hashmap.get(s).toString());
        }
    }

    public static void setSingleNodeAttribute(Node node, String s, String s1, String s2) {
        Element element = DOMTool.getSingleElement(node, s);
        DOMTool.setAttribute(element, s1, s2);
    }

    public static String domToString(Node node) {
        StringWriter stringwriter = new StringWriter();
        return stringwriter.toString();
    }
}

