/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.dao;

import com.gaowj.business.exception.BusinessException;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.web.context.ContextLoaderListener;

public class mybatisSessionFactory {
    private static final ThreadLocal<SqlSession> threadLocal = new ThreadLocal();
    private static SqlSessionFactory sessionFactory;
    private static SqlSessionFactoryBean sessionFB;

    static {
        sessionFB = (SqlSessionFactoryBean)ContextLoaderListener.getCurrentWebApplicationContext().getBean("sqlSessionFactory-system");
        try {
            sessionFactory = sessionFB.getObject();
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
    }

    private mybatisSessionFactory() {
    }

    public static SqlSession getSession() throws BusinessException {
        SqlSession session = threadLocal.get();
        if (session == null) {
            if (sessionFactory == null) {
                mybatisSessionFactory.rebuildSessionFactory();
            }
            session = sessionFactory != null ? sessionFactory.openSession() : null;
            threadLocal.set(session);
        }
        return session;
    }

    public static void rebuildSessionFactory() {
        try {
            sessionFactory = sessionFB.getObject();
        }
        catch (Exception e) {
            System.err.println("%%%% Error Creating SessionFactory %%%%");
            e.printStackTrace();
        }
    }

    public static void closeSession() throws BusinessException {
        SqlSession session = threadLocal.get();
        threadLocal.set(null);
        if (session != null) {
            session.close();
        }
    }

    public static SqlSessionFactory getSessionFactory() {
        return sessionFactory;
    }
}

