/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.util;

import com.gaowj.business.util.FileUploadServlet;
import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

public class MyJakartaMultiPartRequest
implements MultiPartRequest {
    static final Logger LOG = LoggerFactory.getLogger(MyJakartaMultiPartRequest.class);
    protected Map files = new HashMap();
    protected Map params = new HashMap();
    protected List errors = new ArrayList();
    protected long maxSize;
    private Locale defaultLocale = Locale.ENGLISH;

    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    public void setLocaleProvider(LocaleProvider provider) {
        this.defaultLocale = provider.getLocale();
    }

    public void parse(HttpServletRequest request, String saveDir) throws IOException {
        block6: {
            try {
                this.setLocale(request);
                this.processUpload(request, saveDir);
            }
            catch (FileUploadBase.SizeLimitExceededException e) {
                String errorMessage;
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Request exceeded size limit!", (Throwable)e, new String[0]);
                }
                if (!this.errors.contains(errorMessage = this.buildErrorMessage(e, new Object[]{e.getPermittedSize(), e.getActualSize()}))) {
                    this.errors.add(errorMessage);
                }
            }
            catch (Exception e) {
                String errorMessage;
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unable to parse request", (Throwable)e, new String[0]);
                }
                if (this.errors.contains(errorMessage = this.buildErrorMessage(e, new Object[0]))) break block6;
                this.errors.add(errorMessage);
            }
        }
    }

    protected void setLocale(HttpServletRequest request) {
        if (this.defaultLocale == null) {
            this.defaultLocale = request.getLocale();
        }
    }

    protected String buildErrorMessage(Throwable e, Object[] args) {
        String errorKey = "struts.messages.upload.error." + e.getClass().getSimpleName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Preparing error message for key: [#0]", new String[]{errorKey});
        }
        return LocalizedTextUtil.findText(this.getClass(), (String)errorKey, (Locale)this.defaultLocale, (String)e.getMessage(), (Object[])args);
    }

    private void processUpload(HttpServletRequest request, String saveDir) throws FileUploadException, UnsupportedEncodingException {
        for (FileItem item : this.parseRequest(request, saveDir)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found item " + item.getFieldName(), new String[0]);
            }
            if (item.isFormField()) {
                this.processNormalFormField(item, request.getCharacterEncoding());
                continue;
            }
            this.processFileField(item);
        }
    }

    private void processFileField(FileItem item) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Item is a file upload", new String[0]);
        }
        if (item.getName() == null || item.getName().trim().length() < 1) {
            LOG.debug("No file has been uploaded for the field: " + item.getFieldName(), new String[0]);
            return;
        }
        List<Object> values = this.files.get(item.getFieldName()) != null ? (List)this.files.get(item.getFieldName()) : new ArrayList<FileItem>();
        values.add(item);
        this.files.put(item.getFieldName(), values);
    }

    private void processNormalFormField(FileItem item, String charset) throws UnsupportedEncodingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Item is a normal form field", new String[0]);
        }
        List values = this.params.get(item.getFieldName()) != null ? (List)this.params.get(item.getFieldName()) : new ArrayList();
        if (charset != null) {
            values.add(item.getString(charset));
        } else {
            values.add(item.getString());
        }
        this.params.put(item.getFieldName(), values);
        item.delete();
    }

    private List parseRequest(HttpServletRequest servletRequest, String saveDir) throws FileUploadException {
        DiskFileItemFactory fac = this.createDiskFileItemFactory(saveDir);
        FileUploadServlet upload = new FileUploadServlet((FileItemFactory)fac);
        upload.setSizeMax(this.maxSize);
        return upload.parseRequest(this.createRequestContext(servletRequest));
    }

    private DiskFileItemFactory createDiskFileItemFactory(String saveDir) {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        return fac;
    }

    public Enumeration getFileParameterNames() {
        return Collections.enumeration(this.files.keySet());
    }

    public String[] getContentType(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> contentTypes = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            contentTypes.add(fileItem.getContentType());
        }
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    public File[] getFile(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(items.size());
        for (FileItem fileItem : items) {
            File storeLocation;
            block5: {
                storeLocation = ((DiskFileItem)fileItem).getStoreLocation();
                if (fileItem.isInMemory() && storeLocation != null && !storeLocation.exists()) {
                    try {
                        storeLocation.createNewFile();
                    }
                    catch (IOException e) {
                        if (!LOG.isErrorEnabled()) break block5;
                        LOG.error("Cannot write uploaded empty file to disk: " + storeLocation.getAbsolutePath(), (Throwable)e, new String[0]);
                    }
                }
            }
            fileList.add(storeLocation);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public String[] getFileNames(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            fileNames.add(this.getCanonicalName(fileItem.getName()));
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String[] getFilesystemName(String fieldName) {
        List items = (List)this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            fileNames.add(((DiskFileItem)fileItem).getStoreLocation().getName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    public String getParameter(String name) {
        List v = (List)this.params.get(name);
        if (v != null && v.size() > 0) {
            return (String)v.get(0);
        }
        return null;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String name) {
        List v = (List)this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }

    public List getErrors() {
        return this.errors;
    }

    private String getCanonicalName(String filename) {
        int forwardSlash = filename.lastIndexOf("/");
        int backwardSlash = filename.lastIndexOf("\\");
        if (forwardSlash != -1 && forwardSlash > backwardSlash) {
            filename = filename.substring(forwardSlash + 1, filename.length());
        } else if (backwardSlash != -1 && backwardSlash >= forwardSlash) {
            filename = filename.substring(backwardSlash + 1, filename.length());
        }
        return filename;
    }

    private RequestContext createRequestContext(final HttpServletRequest req) {
        return new RequestContext(){

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                ServletInputStream in = req.getInputStream();
                if (in == null) {
                    throw new IOException("Missing content in the request");
                }
                return req.getInputStream();
            }
        };
    }

    public void cleanUp() {
        Set names = this.files.keySet();
        for (String name : names) {
            List items = (List)this.files.get(name);
            for (FileItem item : items) {
                if (LOG.isDebugEnabled()) {
                    String msg = LocalizedTextUtil.findText(this.getClass(), (String)"struts.messages.removing.file", (Locale)Locale.ENGLISH, (String)"no.message.found", (Object[])new Object[]{name, item});
                    LOG.debug(msg, new String[0]);
                }
                if (item.isInMemory()) continue;
                item.delete();
            }
        }
    }
}

