(function($){

	//定义公共的参数(变量,方法)
	var defaults_options = {
		tip:{
            color:'#999',
            fontFamily:'微软雅黑',
            fontSize:'12px',
            text:'请输入信息!'
        }
	}
	//把默认的参数变成string型的,防止引用类型带来的问题
	var defaults_options_str = JSON.stringify(defaults_options);

	$.fn.inputTips = function(options){
		//把参数转化为数json的
		var defaults = JSON.parse(defaults_options_str);
		
		//如果传进来是字符串时
		if(typeof options == 'string'){
			defaults.tip.text = options;
		}
		else{
			//配置
			if(options!=null){
				$.each(options, function(i, val) {
		          if (typeof val == 'object' && defaults[i]){
		        	  $.extend(true,defaults[i], val);
		          }
		          else {
		        	  defaults[i] = val;
		          }
		        });
			}
		}

		$(this).map(function(){  
		    var $input = $(this);
		    //先判断下父容器是否是position:relative
		    if($input.parent().css('position')!='relative'){
		    	$input.parent().css('position','relative');
		    }
		    
		    //在input之后添加一个label标签
		    var $label;
		    if($input.next('label').length==0){
		    	$label = $('<label></label>');
			    $label.css({
			    	'position':'absolute',
			    	'top':'0',
			    	'left':$input.css('paddingLeft'),
			    	'cursor':'text',
			    	'color':defaults.tip.color,
			    	'fontFamily':defaults.tip.fontFamily,
			    	'fontSize':defaults.tip.fontSize,
			    	'height':$input.css('height'),
			    	'lineHeight':$input.css('height'),
			    	'display':'inlineBlock'
			    });
		    }
		    else{
		    	$label=$input.next('label');
		    }
		    //如果input给了value值时
		    if($input.val()){
		    	$label.text($input.val());
		    	$input.val('');
		    }
		    else{
		    	$label.text(defaults.tip.text)
		    }
		    $input.after($label);

		    /*var timeid = setInterval(function(){  
		        if(!$input.val()==""){  
		            $input.siblings("label").hide();  
		            clearInterval(timeid);  
		        }  
		    },10);*/ 
		    $input.siblings('label').click(function(){  
		        $(this).siblings("input").focus();  
		    });  
		    $input.bind({  
		        focus:function(){  
		        	//如果用户传进来的话就调用用户的
		        	if(options!=null && typeof options.focus == 'function'){
		        		options.focus(this);
		        		return;
		        	}
		            if (this.value == ""){  
		                $(this).siblings("label").hide();  
		            }  
		        },  
		        blur:function(){  
		        	//如果用户传进来的话就调用用户的
		        	if(options!=null && typeof options.blur == 'function'){
		        		options.blur(this);
		        		return;
		        	}
		            if (this.value == ""){  
		                $(this).siblings("label").show();  
		            } 
		        }  
		    });
		    
		});



	}//$.fn

})(jQuery);