$(function() {
	
	//去掉尾部的一个div
	$('.index_footer').next().remove();
	
	//初始化容器的最小高度
	init_index_contaner_minHeight();
	
	//初始化块状显示
	init_disk_lump();
	
	//初始化块状的单击效果
	//init_disk_lump_click();
	
	//初始化块状的双击效果
	//init_disk_lump_dbClick();
	
	//初始化块状的文件名的单击效果
	//init_disk_click_div_edit();

	//初始化块状的文本框失去焦点的效果
	//init_disk_input_blur();
	
	//初始化块状的鼠标移动效果
	//init_disk_lump_hover();
	
	//绑定键盘shift和ctrl键来多选
	init_disk_window_multiple();
	
	//绑定鼠标的按下来多选
	//init_disk_window_mouseDownMultiple();
	
	//去掉拖动图片时默认的提示
	//init_disk_window_imgDefault();
	
	//点击容器外时取消选中状态
	$(document).click(function(e){  
		//console.log($(e.target));
		
		//去掉右键的菜单
		$('#disk_menu').hide();
		$('#disk_rubbish_menu').hide();
		$('#disk_shareCode_menu').hide();
		
		//如果不需要取消选中的文件时,或者是fancybox的内容,或者是点击了菜单上面的按钮,或者是提示框时
		if($(e.target).parents('.xcConfirm').length==1||$(e.target).parents('.disk_rubbsh_menu').length==1||$(e.target).parents('.disk_menu').length==1||$(e.target).parents('.fancybox-overlay').length==1||$(e.target).hasClass('disk_document_default')||$(e.target).parent().hasClass('disk_document_default')){
			return;
		}
		
		//去掉选中状态
		$('.disk_content_lump').find('.disk_content_lump_click').removeClass('disk_content_lump_click');
		
	});
	
	//容器的右键效果
	init_disk_contextmenu();
	
})

//去掉拖动图片时默认的提示
function init_disk_window_imgDefault(){
    
    //IE下需要在document的mousemove里面取消默认事件;要用原生JS的事件不能用JQuery
    document.onmousemove = function(e){
        var ev = e || event;
        ev.cancelBubble=true;
        ev.returnValue = false;
    }
    
    $("img").mousedown(function(event){
        //FF下需要在mousedown取消默认操作;
        event.preventDefault();
        event.stopPropagation();
        $(this).bind("mousemove",function(event){});    
    })
}

//绑定鼠标的按下来多选
function init_disk_window_mouseDownMultiple(){
	$(window).mousedown(function(e){
		$('.disk_content_lump').data('mouseDownSelect',true);
    }).mouseup(function(){
    	$('.disk_content_lump').data('mouseDownSelect',false);
    });
}

//绑定键盘shift和ctrl键来多选
function init_disk_window_multiple(){
	$(window).keydown(function(e){
        if(e.ctrlKey||e.shiftKey){
        	$('.disk_content_lump').data('ctrlSelect',true);
        }
    }).keyup(function(){
    	$('.disk_content_lump').data('ctrlSelect',false);
    });
}

//初始化容器的最小高度
function init_index_contaner_minHeight() {
	var conrainer_height = $.jfbrother.getViewSizeWithScrollbar().height - $('.indedx_header').outerHeight(true) - $('.indedx_header_logo').outerHeight(true) - $('.index_center').outerHeight(true) - $('.index_insert_module').outerHeight(true) - $('.index_footer').outerHeight(true)- $('.disk_search').outerHeight(true) - $('.disk_content_header').outerHeight(true);
	//如果原始的高度比屏幕小时再添加最小高度(块状容器)
	if ($('.disk_content_lump').outerHeight() < conrainer_height) {
		$('.disk_content_lump').css('minHeight', conrainer_height);
	}
}

//初始化块状显示
function init_disk_lump(){
	var infos = [
		{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
		{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
		{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
		{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
		{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
		{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
		{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
		{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
		{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'},
	]
	//渲染块状
	for(var i = 0 ; i<infos.length;i++){
		init_disk_createLump(infos[i]);
	}
}

//绑定块状的单击效果
function init_disk_lump_click(){
	$('.disk_content_lump>div>div').each(function(index,element){
		$(element).bind('click',function(){
			disk_lump_click(this);
		})
	})
}

//初始化块状的双击效果
function init_disk_lump_dbClick(){
	$('.disk_content_lump>div>div').each(function(index,element){
		$(element).bind('dblclick',function(){
			disk_lump_dbClick(this);
		})
	})
}

//初始化块状的文件名的单击效果
function init_disk_click_div_edit(){
	$('.disk_content_lump>div>div>div').each(function(index,element){
		$(element).bind('click',function(){
			disk_click_div_edit(this);
		})
	})
}

//初始化块状的文本框失去焦点的效果
function init_disk_input_blur(){
	$('.disk_content_lump>div>div>input').each(function(index,element){
		$(element).bind('blur',function(){
			disk_input_blur(this);
		})
	})
}

//初始化块状的文件名的单击效果
function init_disk_lump_fileName_click(){
	$('.disk_content_lump>div>div>div').each(function(index,element){
		$(element).bind('click',function(){
			disk_click_div_edit(this);
		})
	})
}

//初始化块状的鼠标移动效果
function init_disk_lump_hover(){
	$('.disk_content_lump>div>div').hover(function(){
		//如果是可以多选时
		if($(this).parents('.disk_content_lump').data('mouseDownSelect')){
			//然后给自己加个样式
			$(this).addClass('disk_content_lump_click');
		}
	},function(){})
}

//根据一个json数据来初始化块状列表
function init_disk_createLump(lump_json){
	var $disk_content_lump = $('.disk_content_lump');
	var $create_container = $('<div></div>').addClass('col-md-2');
	$disk_content_lump.append($create_container);
	var $create_content = $('<div></div>');
	
	//把数据存放起来
	$create_content.data('lump_data',lump_json);
	
	$create_content.bind('click',function(){
		disk_lump_click(this);
	})
	
	$create_container.append($create_content);
	
	init_disk_select_fileImg(lump_json);
	
	var $create_img = $('<img src="'+ctx+'/custom/images/'+lump_json.fileImg+'" />');
	var $create_div = $('<div></div>').text(lump_json.fileName);
	if($('#disk_rubbish').data('rubbish')){
		//如果是回收站时,则鼠标移动到文件名时去掉原来的效果
		$create_div.hover(function(){
			$(this).addClass('disk_rubbish_fileName');
		},function(){
			$(this).removeClass('disk_rubbish_fileName');
		});
	}
	else{
		//如果不是显示回收站的时候
		$create_div.bind('click',function(){
			disk_click_div_edit(this);
		})
		$create_content.bind('dblclick',function(){
			disk_lump_dbClick(this);
		})
	}
	var $create_input = $('<input type="text" class="form-control"/>').val(lump_json.fileName);
	//输入框失去焦点时
	$create_input.bind('blur',function(){
		disk_input_blur(this);
	})
	$create_input.css('display','none');
	$create_content.append($create_img).append($create_div).append($create_input);

}

//新建文件夹
function disk_addFolder(handler){
	//右键新建文件时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	//如果为列表时
	if($('.disk_content_toggleBtn').data('toggleList')){
		//列表的添加文件
		disk_addFolder_list();
	}
	//如果是块状的时候
	else{
		//缩略图的添加文件
		disk_addFolder_lump();
	}
	
}

//列表的添加文件
function disk_addFolder_list(){
	  
	var rowId = $.jfbrother.uuid();
	var date = $.jfbrother.dateToStr();
	var list_data = {id:rowId,fileName:'新建文件夹',fileImg:'disk_module5.png',lastTime:date,fileType:'文件夹',fileSize:'-'};
	
	//跳到第一页
	//$('#disk_content_list').bootstrapTable('selectPage', 1); //Jump to the first page
	
	//添加一行数据
	$('#disk_content_list').bootstrapTable('insertRow',{
		index:0,
		row:list_data
	});
	
	//取消之前的选中
	$('#disk_content_list').bootstrapTable('uncheckAll');
	
	//根据id来选中新增的那一行
	$('#disk_content_list tr').each(function(index,element){
		if($(element).data('uniqueid')==rowId){
			$('#disk_content_list').bootstrapTable('check',$(element).data('index'));
			var $div = $(element).find('.disk_content_list_fileName>div').eq(1).find('div');
			$div.hide();
			$div.next().show();
			//输入框获得焦点
			$div.next().focus();
			//输入框的内容全选
			$div.next().select();
			return false;
		}
	})
}

//缩略图的添加文件
function disk_addFolder_lump(){
	var rowId = $.jfbrother.uuid();
	var date = $.jfbrother.dateToStr();
	var jum_data = {id:rowId,fileName:'新建文件夹',fileImg:'disk_module5.png',lastTime:date,fileType:'文件夹',fileSize:'-'}; 
	
	var $disk_content_lump = $('.disk_content_lump');
	var $create_container = $('<div></div>').addClass('col-md-2');
	$disk_content_lump.append($create_container);
	var $create_content = $('<div></div>').addClass('disk_content_lump_click');
	
	//把数据存放起来
	$create_content.data('lump_data',jum_data);
	
	$create_content.bind('click',function(){
		disk_lump_click(this);
	})
	$create_content.bind('dblclick',function(){
		disk_lump_dbClick(this);
	})
	$create_container.append($create_content);
	var $create_img = $('<img src="'+ctx+'/custom/images/'+jum_data.fileImg+'" />');
	var $create_div = $('<div></div>').text(jum_data.fileName);
	$create_div.bind('click',function(){
		disk_click_div_edit(this);
	})
	$create_div.hide();
	var $create_input = $('<input type="text" class="form-control"/>').val(jum_data.fileName);
	//输入框失去焦点时
	$create_input.bind('blur',function(){
		disk_input_blur(this);
	})
	$create_content.append($create_img).append($create_div).append($create_input);
	//输入框获得焦点
	$create_input.focus();
	//输入框的内容全选
	$create_input.select();
}

//点击文件名时的编辑效果
function disk_click_div_edit(handler){
	if($(handler).parent().hasClass('disk_content_lump_click')){
		$(handler).hide();
		$(handler).next().show();
		//输入框获得焦点
		$(handler).next().focus();
		//输入框的内容全选
		$(handler).next().select();
	}
}

//文本框失去焦点时
function disk_input_blur(handler){
	//隐藏输入框,显示div容器
	$(handler).hide();
	var input_val = $(handler).val();
	//如果值为空时,则默认为新建文件夹
	if(input_val==''){
		input_val = '新建文件夹';
	}
	
	//如果文件夹存在时,就自动加个(序号),遍历之前的容器
	disk_find_folder($(handler),input_val);
	var count = $(handler).data('count');
	count==0?input_val=input_val:input_val=input_val+'('+ count +')';
	$(handler).prev().show().text(input_val);
	
	//如果是列表需要做一次更新
	if($('.disk_content_toggleBtn').data('toggleList')){
		$('#disk_content_list').bootstrapTable('updateRow',{
			index:$(handler).parents('tr').data('index'),
			row:{fileName:input_val}
		});
	}
}

//递归查找文件夹是否存在
function disk_find_folder(handler,input_val,count){
	var $handler = $(handler);
	var val = input_val;
	var count_value = count;
	if(!count_value){
		count_value = 0;
	}
	var flag = true;//表示不存在
	//遍历除了自身的文件
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		$('#disk_content_list tbody>tr .disk_content_list_fileName input').not($(handler)).each(function(index,element){
			count_value==0?result_val=val:result_val = val + '('+ count_value +')';
			if($(element).prev().text()==result_val){
				flag = false;
				return false;
			}
		})
	}
	else{
		//如果是块状时
		$(handler).parents('.disk_content_lump').children().not($(handler).parents('.col-md-2')).each(function(index,element){
			count_value==0?result_val=val:result_val = val + '('+ count_value +')';
			if($(element).find('img+div').text()==result_val){
				flag = false;
				return false;
			}
		})
	}
	if(!flag){
		count_value+=1;
		disk_find_folder($handler,val,count_value);
	}
	else{	
		$handler.data('count',count_value);
	}
}

//单击块状
function disk_lump_click(handler){
	//去掉右键的菜单
	$('#disk_menu').hide();
	$.jfbrother.stopPropagation();
	//如果是不可以多选时
	if(!$(handler).parents('.disk_content_lump').data('ctrlSelect')){
		//先去掉之前选中的
		$(handler).parents('.disk_content_lump').find('.disk_content_lump_click').removeClass('disk_content_lump_click');
	}
	//然后给自己加个样式
	$(handler).addClass('disk_content_lump_click');
}

//双击块状
function disk_lump_dbClick(handler){
	//正处在编辑时不能双击
	if($(handler).find('input').css('display')!='none'){
		return;
	}
	
	//添加目录的导航效果
	var $search_center =  $('.disk_search_center');
	var $create_a = $('<a onclick="disk_backFolder(this)"></a>');
	var $create_span1 = $('<span></span>').text($(handler).find('div').text());
	var $create_span2 = $('<span></span>').addClass('glyphicon glyphicon-triangle-right');
	$create_a.append($create_span1).append($create_span2);
	$search_center.append($create_a);
	
	//重新渲染块状
	//先清空容器
	$('.disk_content_lump').html('');
	var infos = [
		{id:'uuid20',fileName:'我的文件1',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder',fileSize:'200KB'},
		{id:'uuid21',fileName:'我的文件2',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder',fileSize:'100KB'},
	]
	for(var i = 0 ;i<infos.length;i++){
		init_disk_createLump(infos[i]);
	}
	
}

//容器的右键效果
function init_disk_contextmenu(){
	$('.disk_content_lump,.disk_content_list').bind('contextmenu',function(e){
		
		var $disk_menu;
		if($('#disk_rubbish').data('rubbish')){
			$disk_menu = $('#disk_rubbish_menu');
		}
		else if($('#disk_shareCode').data('shareCode')){
			$disk_menu = $('#disk_shareCode_menu'); 
		}
		else{
			$disk_menu = $('#disk_menu');
		}
		
		//console.log($(e.target));
		//如果是正在编辑的时候就不做操作
		if($(e.target).is('input')){
			return false;
		}
		
		//如果是列表模式时,或者是分享码的列表时
		if($('.disk_content_toggleBtn').data('toggleList')||$('#disk_shareCode').data('shareCode')){
			//点击空白的地方
			if($(e.target).hasClass('fixed-table-body')){
				//去掉之前选中的列
				//$('#disk_content_list').bootstrapTable('uncheckAll');
				$disk_menu.find('.disk_menu_noClickBtn').removeClass('disk_menu_noClick');
				$disk_menu.find('.disk_menu_clickBtn').addClass('disk_menu_noClick');
			}
			//点击文件夹
			else if($(e.target).parents('tbody').length==1){
				//去掉之前选中的列
				$('#disk_content_list').bootstrapTable('uncheckAll');
				
				//选中当前的列
				$('#disk_content_list').bootstrapTable('check',$(e.target).parents('tr').data('index'));
				
				$disk_menu.find('.disk_menu_noClickBtn').addClass('disk_menu_noClick');
				$disk_menu.find('.disk_menu_clickBtn').removeClass('disk_menu_noClick');
			}
			//点击了分页和table的头部
			else if($(e.target).parents('thead').length==1||$(e.target).hasClass('fixed-table-pagination')||$(e.target).parents('.fixed-table-pagination').length==1){
				return false;
			}
		}
		//如果是缩略图的模式时
		else{
			//右键时,切换是否可以点击的按钮
			if($(e.target).hasClass('disk_content_lump')){
				$disk_menu.find('.disk_menu_noClickBtn').removeClass('disk_menu_noClick');
				$disk_menu.find('.disk_menu_clickBtn').addClass('disk_menu_noClick');
			}
			else{
				//先去掉之前选中的
				$(e.target).parents('.disk_content_lump').find('.disk_content_lump_click').removeClass('disk_content_lump_click');
				//然后给自己加个样式
				$(e.target).parents('.col-md-2').children('div').addClass('disk_content_lump_click');
				
				$disk_menu.find('.disk_menu_noClickBtn').addClass('disk_menu_noClick');
				$disk_menu.find('.disk_menu_clickBtn').removeClass('disk_menu_noClick');
			}
		}
		
		//显示菜单
		$disk_menu.show();
		
		var e = e || event;
	    var scrollTop=document.documentElement.scrollTop||document.body.scrollTop;
	    var scrollWidth = $.jfbrother.getScrollbarWidth();
	    //屏幕的高度与高度
	    var client_width = $.jfbrother.getViewSizeWithScrollbar().width;
	    var client_height = $.jfbrother.getViewSizeWithScrollbar().height;
	    //鼠标的位置
	    var mouse_left = e.clientX;
	    var mouse_top= e.clientY;
	    //菜单的宽高
	    var menu_width= $disk_menu.outerWidth(true);
	    var menu_height= $disk_menu.outerHeight(true);
	    //如果右边的超出了
	    if(client_width-mouse_left-scrollWidth<menu_width){
	    	mouse_left = client_width - menu_width - scrollWidth;
	    }
	    //如果高度超出时
    	if(client_height-mouse_top<menu_height){
    		mouse_top = client_height - menu_height + scrollTop;
    	}
    	else{
    		mouse_top = mouse_top + scrollTop;
    	}
	    //当滑动滚动条时也能准确获取菜单位置
    	$disk_menu.css({'top':mouse_top+"px",'left':mouse_left+"px"});
	    //阻止默认事件
	    return false;
	})
}

//删除文件夹
function disk_deleteFolder(handler){
	//右键删除时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}

	//如果是列表时
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		if(list_rows.length==0){
			var txt3 =  "请选择要删除的文件!!!";
			var option3 = {
				title: "提示",
				btn:parseInt("0001",2)
			}
			window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.confirm,option3);
		}
		else{
			var txt4 =  "是否要删除选中的文件!!!";
			var option4 = {
				title: "删除提示",
				onOk: function(){
					for(var i = 0; i<list_rows.length;i++){						
						//根据id来删除行
						$('#disk_content_list').bootstrapTable('removeByUniqueId',list_rows[i].id);
					}
				}
			}
			window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.warning,option4);
		}
	}
	else{
		//如果是块状时
		var lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		if(lump_rows.length==0){
			var txt1 =  "请选择要删除的文件!!!";
			var option1 = {
				title: "提示",
				btn:parseInt("0001",2)
			}
			window.wxc.xcConfirm(txt1, window.wxc.xcConfirm.typeEnum.confirm,option1);
		}
		else{
			var txt2 =  "是否要删除选中的文件!!!";
			var option2 = {
				title: "删除提示",
				onOk: function(){
					for(var i = 0 ; i < lump_rows.length ; i ++){
						$(lump_rows[i]).parent().remove();
					}
				}
			}
			window.wxc.xcConfirm(txt2, window.wxc.xcConfirm.typeEnum.warning,option2);
		}
	}
}

//缩略图与列表的切换
function disk_content_toggle(handler){
	//绑定一个data来区别切换的状态toggleList==true为切换到了list
	if(!$(handler).data('toggleList')){
		//列表形式
		$(handler).data('toggleList',true);
		$(handler).attr('title','切换到缩略图模式');
		$(handler).removeClass('glyphicon-th-large').addClass('glyphicon-th-list');
		
		if($('#disk_rubbish').data('rubbish')){
			//重新渲染列表
			var infos = [
				{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
				{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
				{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
				{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
				{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
				{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
				{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
			]
			init_disk_rubbish_list(infos);
		}
		else{
			//重新渲染列表
			var infos = [
				{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
				{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
				{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
				{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
				{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
				{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
				{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
				{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
				{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
			]
			init_disk_list(infos);
		}
	}
	else{
		//缩略图形式
		$(handler).data('toggleList',false);
		$(handler).attr('title','切换到列表模式');
		$(handler).removeClass('glyphicon-th-list').addClass('glyphicon-th-large');
		
		//重新渲染块状
		if($('#disk_rubbish').data('rubbish')){
			var infos = [
				{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
				{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
				{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
				{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
				{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
				{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
				{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
			]
		}
		else{
			var infos = [
				{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
				{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
				{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
				{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
				{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
				{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
				{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
				{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
				{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
			]
		}
		
		//先清空容器
		$('.disk_content_lump').html('');
		//渲染块状
		for(var i = 0 ; i<infos.length;i++){
			init_disk_createLump(infos[i]);
		}
	}
	$('.disk_content_lump,.disk_content_list').toggle();
}

//初始化文件的列表
function init_disk_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
         /* showColumns:true,
         showToggle:true,
         showRefresh:true,
         search:true, */
         /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
         data:infos,
         cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
         /* striped: true,  //表格显示条纹，默认为false */
         pagination: false, // 在表格底部显示分页组件，默认false
         pageList: [5,10,15,20], // 设置页面可以显示的数据条数
         pageSize: 10, // 页面数据条数
         pageNumber: 1, // 首页页码,
         uniqueId:'id',
         //clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
         queryParams:function(params){
			  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				   // limit: params.limit,   //页面大小  
				    offset: params.offset,  //页码  
				    pageSize:this.pageSize,  
				    pageNumber:this.pageNumber
				    /* projectId: $("#projectId").val(),  
				    requirement_Id:$("#requirement_Id").val(),  
				    length: 6  */ 
				};  
				return temp;
         },
         columns: [
             {
                 checkbox: true, // 显示一个勾选框
                 align: 'center', // 居中显示
                 valign: 'middle'
             },{
                 field: 'fileName',
                 title: '文件名称',
                 align: 'left',
                 valign: 'middle',
                 width:400,
                 formatter: function (value, row, index) { 
                	 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10"><div>'+ value +'</div><input type="text" value='+ value +' class="form-control" onblur="disk_input_blur(this)" /></div></div>';  
                 }
             }, {
                 field: 'lastTime',
                 title: '修改时间',
                 align: 'center',
                 valign: 'middle',
                 order:'asc',
                 sortable:'true'
             }, {
                 field: 'fileType',
                 title: '类型',
                 align: 'center',
                 valign: 'middle'
             },{
                 field: 'fileSize',
                 title: '大小',
                 align: 'center',
                 valign: 'middle'
             }
         ],
         //选中时隐藏菜单
         onCheck:function(row){
        	 $('#disk_menu').hide();
         },
         //当用户点击某一列的时候触发
         onClickCell:function(field, value, row, $element){
        	 if(field=='fileName'){        	
        		 //编辑,把td传入
        		 disk_editFolder_list($element);
        	 }
         },
         //当用户双击某一行的时候触发
         onDblClickRow:function(row, $element){
        	 //根据id重新渲染列表
        	 disk_list_dbClick(row,$element);
         },
         //当用户单击某一行的时候触发
         onClickRow:function(row, $element){
        	//选中这行
        	//在根据id来获得对象
     		$('#disk_content_list tr').each(function(index,element){
     			if($(element).data('uniqueid')==row.id){
     				var index = $(element).data('index');
     				//如果正处于编辑状态那就选中,否则就反着选
     				if($(element).find('.disk_content_list_fileName input').css('display')!='none'||!$(element).find('input[type="checkbox"]').prop('checked')){
     					$('#disk_content_list').bootstrapTable('check',index);
     				}
     				else{
     					$('#disk_content_list').bootstrapTable('uncheck',index);
     				}
     			}
     		})
         }
         //
   })
}

//初始化回收站的列表
function init_disk_rubbish_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
       /* showColumns:true,
       showToggle:true,
       showRefresh:true,
       search:true, */
       /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
       data:infos,
       cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
       /* striped: true,  //表格显示条纹，默认为false */
       pagination: false, // 在表格底部显示分页组件，默认false
       pageList: [5,10,15,20], // 设置页面可以显示的数据条数
       pageSize: 10, // 页面数据条数
       pageNumber: 1, // 首页页码,
       uniqueId:'id',
       clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
       queryParams:function(params){
			  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				   // limit: params.limit,   //页面大小  
				    offset: params.offset,  //页码  
				    pageSize:this.pageSize,  
				    pageNumber:this.pageNumber
				    /* projectId: $("#projectId").val(),  
				    requirement_Id:$("#requirement_Id").val(),  
				    length: 6  */ 
				};  
				return temp;
       },
       columns: [
           {
               checkbox: true, // 显示一个勾选框
               align: 'center', // 居中显示
               valign: 'middle'
           },{
               field: 'fileName',
               title: '文件名称',
               align: 'left',
               valign: 'middle',
               width:400,
               formatter: function (value, row, index) { 
              	 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10"><div style="color:#666;cursor:text;">'+ value +'</div><input type="text" value='+ value +' class="form-control" onblur="disk_input_blur(this)" /></div></div>';  
               }
           }, {
               field: 'lastTime',
               title: '删除时间',
               align: 'center',
               valign: 'middle',
               order:'asc',
               sortable:'true'
           }, {
               field: 'fileType',
               title: '类型',
               align: 'center',
               valign: 'middle'
           },{
               field: 'fileSize',
               title: '大小',
               align: 'center',
               valign: 'middle'
           }
       ],
       //选中时隐藏菜单
       onCheck:function(row){
      	 $('#disk_rubbish_menu').hide();
       }
 })
}

//修改文件名
function disk_editFolder(handler){
	//右键删除时,如果是不能点击时
	if($(handler).hasClass('disk_menu_noClick')){
		return;
	}

	if($('.disk_content_toggleBtn').data('toggleList')){
		
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		//在根据id来获得对象
		$('#disk_content_list tr').each(function(index,element){
			if($(element).data('uniqueid')==list_rows[0].id){
				disk_editFolder_list($(element).find('.disk_content_list_fileName').parent());
				return false;
			}
		})
		
	}
	else{
		//如果是块状时
		var $lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		disk_click_div_edit($lump_rows.find('div'));
	}
}

//列表的编辑
function disk_editFolder_list(handler){
	var $input = $(handler).find('input');
	$input.prev().hide();
	$input.show();
	$input.focus();
	$input.select();
}

//双击列表时
function disk_list_dbClick(row,handler){

	//正处在编辑时不能双击
	if($(handler).find('.disk_content_list_fileName input').css('display')!='none'){
		return;
	}
	
	//添加目录的导航效果
	var $search_center =  $('.disk_search_center');
	var $create_a = $('<a onclick="disk_backFolder(this)"></a>');
	var $create_span1 = $('<span></span>').text($(handler).find('.disk_content_list_fileName input').val());
	var $create_span2 = $('<span></span>').addClass('glyphicon glyphicon-triangle-right');
	$create_a.append($create_span1).append($create_span2);
	$search_center.append($create_a);
	
	//重新渲染列表,模拟几条数据
	var infos = [
		{id:'uuid8',fileName:'我的文件1',fileImg:'disk_module5.png',lastTime:'2018-06-19 14:20',fileType:'folder',fileSize:'200KB'},
		{id:'uuid9',fileName:'我的文件2',fileImg:'disk_module5.png',lastTime:'2018-06-18 15:50',fileType:'folder',fileSize:'100KB'},
		{id:'uuid10',fileName:'我的文件3',fileImg:'disk_module5.png',lastTime:'2018-06-15 12:50',fileType:'folder',fileSize:'50KB'}
	]
	
	init_disk_list(infos);
}

//进入文件夹
function disk_enterFolder(handler){
	//右键进入文件夹时,如果是不能点击时
	if($(handler).hasClass('disk_menu_noClick')){
		return;
	}

	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		//在根据id来获得对象
		$('#disk_content_list tr').each(function(index,element){
			if($(element).data('uniqueid')==list_rows[0].id){
				disk_list_dbClick(list_rows[0],$(element));				
				return false;
			}
		})
	}
	else{
		//如果是块状时
		var $lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		disk_lump_dbClick($lump_rows);
	}
}

//返回到最开始的展示情况
function disk_backFolder(handler){
	//如果已经是最后一个了
	if($(handler).next().length==0){
		return;
	}
	//清除之后的a
	$(handler).nextAll('a').remove();
	
	//重新渲染数据
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		//重新渲染列表
		var list_infos = [
			{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
			{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
			{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
			{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
			{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
			{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
			{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
			{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
			{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
		]
		
		init_disk_list(list_infos);
	}
	else{
		//如果是块状时
		//根据一个json数据去渲染块状
		var lump_infos = [
			{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
			{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
			{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
			{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
			{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
			{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
			{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
			{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
			{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'},
		]
		//渲染块状
		//先清空容器
		$('.disk_content_lump').html('');	
		for(var i = 0 ; i<lump_infos.length;i++){
			init_disk_createLump(lump_infos[i]);
		}
	}
}

//移动文件
function disk_moveFolder(handler){
	//右键移动文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}

	var rows;
	//如果是列表时
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		rows = $('#disk_content_list').bootstrapTable('getSelections');
	}
	else{
		//如果是块状时
		rows = $('.disk_content_lump').find('.disk_content_lump_click');
	}
	
	if(rows.length==0){
		var txt =  "请选择要移动的文件!!!";
		var option = {
			title: "提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.confirm,option);
		return;
	}
	
	//获得选中的数据
	var rows_data = [];
	for(var i=0;i<rows.length;i++ ){
		if($(rows[i]).data('lump_data')){
			//获得块状的数据
			rows_data.push($(rows[i]).data('lump_data'));
		}
		else{
			//获得列表的数据
			rows_data.push(rows[i]);
		}
	}
	
	console.log(rows_data)
	
	var strVar = "";
    strVar += "<div style=\"width:268px;padding:0px;border-radius:5px;overflow:hidden;\">\n";
    strVar += "	<div class=\"disk_move_title\"><span>移动文件<\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
    strVar += "	<div id=\"disk_move_tree\" style=\"height:220px;overflow:auto;\" class=\"ztree disk_move_tree\"><\/div>\n";
    strVar += "	<div class=\"disk_move_btn\">\n";
    strVar += "		<span onclick=\"disk_moveFolder_save()\">确定<\/span><span onclick=\"$.fancybox.close()\">取消<\/span>\n";
    strVar += "	<\/div>\n";
    strVar += "<\/div>\n";
    
    $.fancybox.open(strVar,{
    	//显示之前触发
    	beforeShow : function( instance, current ) {
    		//去掉fancybox原来的间距
    		/*$('.fancybox-opened').css('width','268px');*/
    		$('.fancybox-skin').css('padding','0');
		},
		//显示之后触发
    	afterShow : function( instance, current ){
    		//隐藏右上角的X
    		$('.fancybox-close').hide();
    	}
    });
	
	//初始化文件目录
	init_disk_move_tree(rows_data);
	
}

//文件移动的保存
function disk_moveFolder_save(){
	var treeObj = $.fn.zTree.getZTreeObj("disk_move_tree");
	var nodes = treeObj.getSelectedNodes();
	console.log(nodes)
	$.fancybox.close();
	
	//重新渲染显示的内容
	
}

//选择共享人之后的保存
function disk_enjoyUser_save(){
	var treeObj = $.fn.zTree.getZTreeObj("disk_enjoyUser_tree");
	var nodes = treeObj.getSelectedNodes();
	console.log(nodes)
	$.fancybox.close();
	
	//重新渲染显示的内容
	
}

//初始化文件时移动的目录
function init_disk_move_tree(rows_data){
	var ztreeData = [
		{pid:'0',id:'A',name:"公司文件",fileType:'folder_company'},
		{pid:'A',id:'A1',name:'我的文件夹1',fileType:'folder'},
		{pid:'A',id:'A2',name:'我的文件夹2',fileType:'folder'},
		{pid:'A',id:'A3',name:'我的文件夹3',fileType:'folder'},
		{pid:'A',id:'A4',name:'我的文件夹4',fileType:'folder'},
		{pid:'A4',id:'A5',name:'我的文件夹5',fileType:'folder'},
		{pid:'A5',id:'A6',name:'我的文件夹5',fileType:'folder'},
		{pid:'A6',id:'A7',name:'我的文件夹5',fileType:'folder'},
		{pid:'0',id:'B',name:'共享文件',fileType:'folder_share'},
		{pid:'B',id:'B4',name:'我的文件夹5',fileType:'folder'},
		{pid:'B',id:'B4',name:'我的文件夹6',fileType:'folder'}
	];
	
	for(var i =0;i<ztreeData.length;i++){
		init_disk_select_fileImg(ztreeData[i]);
	}
	
	//还要做一步过滤
	//1.把自身及以下文件过滤掉
	//2.所有节点不是文件夹的过滤掉
	
	var zTreeObj;
	// zTree 的参数配置，深入使用请参考 API 文档（setting 配置详解）
	var setting = {
		callback : {
			onClick : function(event, treeId, treeNode) {
				//$('#' + treeNode.tId).find('.curSelectedNode').removeClass('curSelectedNode');
			}
		},
		data : {
			simpleData : {
				enable : true,
				idKey : "id",
				pIdKey : "pid",
				rootPId : 0
			}
		},
		view : {
			nameIsHTML : true,
			showTitle : true,
			//双击节点时，是否自动展开父节点的标识,true / false 分别表示双击节点 切换 / 不切换 展开状态
			dblClickExpand : true,
			//点击节点时，按下 Ctrl 或 Cmd 键是否允许取消选择操作。
			autoCancelSelected : false,
			//是否显示连线
			showLine: false
		}
	};

	// zTree 的数据属性，深入使用请参考 API 文档（zTreeNode 节点数据详解）

	zTreeObj = $.fn.zTree.init($("#disk_move_tree"), setting, ztreeData);

	//展开根节点
	/*function filter(node) {
		return (node.pid == 0);
	}
	var filter_nodes = zTreeObj.getNodesByFilter(filter); // 查找根节点集合 
	for (var i = 0; i < filter_nodes.length; i++) {
		zTreeObj.expandNode(filter_nodes[i], true, true, true);
	}*/

}

//初始化共享人的树
function init_disk_enjoyUser_tree(rows_data){
	var ztreeData = [
		{pid:'0',id:'A',name:'技术部',icon:'custom/images/disk_enjoy_users.png'},
		{pid:'A',id:'A1',name:'联系人1',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A2',name:'联系人2',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A3',name:'联系人3',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A4',name:'联系人4',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A5',name:'联系人5',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A6',name:'联系人6',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A7',name:'联系人7',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A8',name:'联系人8',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A9',name:'联系人9',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A10',name:'联系人10',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A11',name:'联系人11',icon:'custom/images/disk_enjoy_user.png'},
		{pid:'A',id:'A12',name:'联系人12',icon:'custom/images/disk_enjoy_user.png'}
	];
	
	/*for(var i =0;i<ztreeData.length;i++){
		init_disk_select_fileImg(ztreeData[i]);
	}*/
	
	//还要做一步过滤
	//1.把自身及以下文件过滤掉
	//2.所有节点不是文件夹的过滤掉
	
	var zTreeObj;
	// zTree 的参数配置，深入使用请参考 API 文档（setting 配置详解）
	var setting = {
		callback : {
			onClick : function(event, treeId, treeNode) {
				//$('#' + treeNode.tId).find('.curSelectedNode').removeClass('curSelectedNode');
				//如果是父节点时,则取消选中状态,但是要添加一个选中样式
				if (treeNode.isParent) {
					zTreeObj.cancelSelectedNode(treeNode);
					$(event.target).addClass('curSelectedNode');
                }
			}
		},
		data : {
			simpleData : {
				enable : true,
				idKey : "id",
				pIdKey : "pid",
				rootPId : 0
			}
		},
		view : {
			nameIsHTML : true,
			showTitle : true,
			//双击节点时，是否自动展开父节点的标识,true / false 分别表示双击节点 切换 / 不切换 展开状态
			dblClickExpand : true,
			//点击节点时，按下 Ctrl 或 Cmd 键是否允许取消选择操作。
			autoCancelSelected : true,
			//是否显示连线
			showLine: false
		}
	};

	// zTree 的数据属性，深入使用请参考 API 文档（zTreeNode 节点数据详解）

	zTreeObj = $.fn.zTree.init($("#disk_enjoyUser_tree"), setting, ztreeData);

	//展开根节点
	/*function filter(node) {
		return (node.pid == 0);
	}
	var filter_nodes = zTreeObj.getNodesByFilter(filter); // 查找根节点集合 
	for (var i = 0; i < filter_nodes.length; i++) {
		zTreeObj.expandNode(filter_nodes[i], true, true, true);
	}*/

}

//初始化文件的图片
function init_disk_select_fileImg(ztreeData){
	if(',jpg,png,jpeg,gif,'.indexOf(','+ ztreeData.fileType +',')==-1){
		//非图片类型需要判断显示的图片
		//iconOpen:文件夹树形结构打开图片
		//iconClose:文件夹树形结构关闭图片
		//icon:文件夹树形结构叶子图片
		//fileImg:桌面显示图片
		switch (ztreeData.fileType) {
		case 'folder_company':
			ztreeData.iconOpen='custom/images/disk_module1.png';
			ztreeData.iconClose='custom/images/disk_module1_close.png';
			ztreeData.icon='custom/images/disk_module1_close.png';
			ztreeData.fileImg='disk_module1_close.png';
			break;
		case 'folder_share':
			ztreeData.iconOpen='custom/images/disk_module2.png';
			ztreeData.iconClose='custom/images/disk_module2_close.png';
			ztreeData.icon='custom/images/disk_module2_close.png';
			ztreeData.fileImg='disk_module2_close.png';
			break;
		/*case 'folder_myFile':
			ztreeData.iconOpen='custom/images/disk_module3.png';
			ztreeData.iconClose='custom/images/disk_module3_close.png';
			ztreeData.icon='custom/images/disk_module3_close.png';
			ztreeData.fileImg='disk_module3_close.png';
			break;
		case 'folder_myShare':
			ztreeData.iconOpen='custom/images/disk_module4.png';
			ztreeData.iconClose='custom/images/disk_module4_close.png';
			ztreeData.icon='custom/images/disk_module4_close.png';
			ztreeData.fileImg='disk_module4_close.png';
			break;*/
		case 'folder':
			ztreeData.iconOpen='custom/images/disk_module5.png';
			ztreeData.iconClose='custom/images/disk_module5_close.png';
			ztreeData.icon='custom/images/disk_module5_close.png';
			ztreeData.fileImg='disk_module5_close.png';
			break;
		case 'rar':
			ztreeData.fileImg='disk_rar.png';
			break;
		case 'txt':
			ztreeData.fileImg='disk_unknow.png';
			break;
		case 'ppt':
			ztreeData.fileImg='disk_ppt.png';
			break;
		case 'pdf':
			ztreeData.fileImg=='disk_pdf.png';
			break;
		case 'excel':
			ztreeData.fileImg='disk_excel.png';
			break;
		case 'word':
			ztreeData.fileImg='disk_word.png';
			break;
		default:
			ztreeData.fileImg='disk_unknow.png';
			break;
		}
	}
}

//文件的下载
function disk_downFolder(handler){
	//右键下载文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	var list_rows;
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
	}
	else{
		//如果是块状时
		var list_rows = $('.disk_content_lump').find('.disk_content_lump_click');
	}
	
	if(list_rows.length==0){
		var txt =  "请选择要下载的文件!!!";
		var option = {
			title: "下载提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.confirm,option);
	}
	else{
		var txt2 =  "是否要下载选中的文件!!!";
		var option2 = {
			title: "下载提示",
			onOk: function(){
				/*//获得选中的数据
				var rows_data = [];
				for(var i=0;i<list_rows.length;i++ ){
					if($(list_rows[i]).data('lump_data')){
						//获得块状的数据
						rows_data.push($(list_rows[i]).data('lump_data'));
					}
					else{
						//获得列表的数据
						rows_data.push(list_rows[i]);
					}
				}*/
				//下载文件
				$('<a href="https://codeload.github.com/douban/douban-client/legacy.zip/master" download="proposed_file_name">Download</a>')[0].click();
			}
		}
		window.wxc.xcConfirm(txt2, window.wxc.xcConfirm.typeEnum.warning,option2);
	}
}

//上传文件的显示
function disk_uploadFolder(handler){
	//右键上传文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	var strVar = "";
    strVar += "<div class=\"row\" style=\"margin:0px;width:800px;padding: 0px;border-radius: 5px;overflow: hidden;\">\n";
    strVar += "	<div class=\"disk_move_title\"><span>选择文件上传<\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
    strVar += "	<div class=\"disk_upload_content col-md-12\">\n";
    strVar += "		<div class=\"col-md-6 disk_upload_left_content\">\n";
    strVar += "			<div class=\"disk_upload_left_content_container\" id=\"disk_upload_drop\" >\n";
    strVar += "				<img src=\"custom/images/disk_uploadBg.png\" width=\"70\" height=\"60\" />\n";
    strVar += "				<div><span onclick=\"$(this).next().click()\">选择文件上传<\/span><input onchange=\"disk_upload_file()\" type=\"file\" style=\"display:none;\" multiple=\"multiple\" /><\/div>\n";
    strVar += "				<div>或者将文件拖拽到此处<\/div>\n";
    strVar += "				<div>可一次选择多个文件<\/div>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "		<div class=\"col-md-6\">\n";
    strVar += "			<div class=\"col-md-12 disk_upload_right_header\">\n";
    strVar += "				<div class=\"col-md-7\">文件名<\/div>\n";
    strVar += "				<div class=\"col-md-5\">文件大小<\/div>\n";
    strVar += "			<\/div>\n";
    strVar += "			<div class=\"col-md-12 disk_upload_right_content\">\n";
    /*strVar += "				<div class=\"col-md-12\">\n";
    strVar += "					<div class=\"col-md-7\"><span>1.<\/span><span title=\"ASP操作手册ASP操作手册ASP操作手册.doc\">ASP操作手册ASP操作手册ASP操作手册.doc<\/span><\/div>\n";
    strVar += "					<div class=\"col-md-5\">\n";
    strVar += "						<span>12KB<\/span>\n";
    strVar += "						<div class=\"progress disk_progress\" style=\"display:none;\">\n";
    strVar += "						 	<div style='width:50%' class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" >\n";
    strVar += "						    	<!-- 50% -->\n";
    strVar += "						  	<\/div>\n";
    strVar += "						<\/div>\n";
    strVar += "						<span class=\"glyphicon glyphicon-ok\" style=\"display:inline-block;\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-pause\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-remove\"><\/span>\n";
    strVar += "					<\/div>\n";
    strVar += "				<\/div>\n";
    strVar += "				<div class=\"col-md-12\">\n";
    strVar += "					<div class=\"col-md-7\"><span>10.<\/span><span title=\"ASP操作手册.doc\">ASP操作手册.doc<\/span><\/div>\n";
    strVar += "					<div class=\"col-md-5\">\n";
    strVar += "						<span>1024KB<\/span>\n";
    strVar += "						<div class=\"progress disk_progress\">\n";
    strVar += "						 	<div style='width:90%' class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" >\n";
    strVar += "						    	<!-- 50% -->\n";
    strVar += "						  	<\/div>\n";
    strVar += "						<\/div>\n";
    strVar += "						<span class=\"glyphicon glyphicon-ok\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-pause\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-remove\"><\/span>\n";
    strVar += "					<\/div>\n";
    strVar += "				<\/div>\n";
    strVar += "				<div class=\"col-md-12\">\n";
    strVar += "					<div class=\"col-md-7\"><span>110.<\/span><span title=\"ASP操作手册.doc\">ASP操作手册.doc<\/span><\/div>\n";
    strVar += "					<div class=\"col-md-5\">\n";
    strVar += "						<span>12KB<\/span>\n";
    strVar += "						<div class=\"progress disk_progress\">\n";
    strVar += "						 	<div style='width:20%' class=\"progress-bar progress-bar-striped active\" role=\"progressbar\" >\n";
    strVar += "						    	<!-- 50% -->\n";
    strVar += "						  	<\/div>\n";
    strVar += "						<\/div>\n";
    strVar += "						<span class=\"glyphicon glyphicon-ok\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-pause\"><\/span>\n";
    strVar += "						<span class=\"glyphicon glyphicon-remove\"><\/span>\n";
    strVar += "					<\/div>\n";
    strVar += "				<\/div>\n";*/
    strVar += "			<\/div>\n";
    strVar += "			<div class=\"col-md-12 disk_upload_right_bottom\">\n";
    strVar += "				已选择<span id=\"disk_upload_fileCount\">0<\/span>个文件,共<span id=\"disk_upload_fileSize\">0B<\/span>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "	<\/div>\n";
    strVar += "	<div class=\"disk_upload_btn col-md-12\">\n";
    strVar += "		<div class=\"col-md-6\"><\/div>\n";
    strVar += "		<div class=\"col-md-6\"><span>上传<\/span><span onclick='$.fancybox.close()'>取消<\/span><\/div>\n";
    strVar += "	<\/div>\n";
    strVar += "<\/div>\n";
	$.fancybox.open(strVar,{
		//显示之前触发
    	beforeShow : function( instance, current ) {
    		//去掉fancybox原来的间距
    		$('.fancybox-skin').css('padding','0');
		},
		//显示之后触发
    	afterShow : function( instance, current ){
    		//隐藏右上角的X
    		$('.fancybox-close').hide();
    	}
	});
	
	//初始化文件的拖拉上传
	init_disk_drop();
}

//初始化文件的拖拉上传
function init_disk_drop(){
	var drop_content = $('#disk_upload_drop')[0];
	//当被鼠标拖动的对象进入其容器范围内时触发此事件
	drop_content.ondragenter = function(event) {  
		//阻止默认行为
		$.jfbrother.preventDefualt();
		$(this).css('borderColor','#ccc');
    }
	//当被鼠标拖动的对象离开其容器范围内时触发此事件
	drop_content.ondragleave = function(event) {  
		//阻止默认行为
		$.jfbrother.preventDefualt();
		$(this).css('borderColor','#eee');
    }
	//当某被拖动的对象在另一对象容器范围内拖动时触发此事件
    drop_content.ondragover = function(event) {  
    	//阻止默认行为
		$.jfbrother.preventDefualt();
		$(this).css('borderColor','#ccc');
    }  
    //在一个拖动过程中，释放鼠标键时触发此事件
	drop_content.ondrop = function(event) {
		$(this).css('borderColor','#eee');
		//阻止默认行为
		$.jfbrother.preventDefualt();  
        //拖入的文件必须是外部的，不能使浏览器内的  
		var files = event.dataTransfer.files;
		for(var i=0;i<files.length;i++){
			disk_create_uploadList(files[i]);
		}
    }
}

//文件的上传
function disk_upload_file(){
	var files = event.currentTarget.files;
	for(var i=0;i<files.length;i++){
		disk_create_uploadList(files[i]);
	}
}

//根据一个json来渲染上传文件的列表
function disk_create_uploadList(json_data){
	var $contaner = $('<div></div>').addClass('col-md-12');
	$contaner.data('upload_data',json_data);
	
	var $contaner_left = $('<div></div>').addClass('col-md-7');
	var $contaner_right = $('<div></div>').addClass('col-md-5');
	$contaner.append($contaner_left).append($contaner_right);
	
	//索引
	var $index_span = $('<span></span>');
	var file_index = $('.disk_upload_right_content>div').length+1;
	$index_span.text(file_index+'.');
	//文件名
	var $file_name = $('<span></span>');
	$file_name.attr('title',json_data.name);
	$file_name.text(json_data.name);
	$contaner_left.append($index_span).append($file_name);
	
	//文件大小
	var $file_size = $('<span></span>');
	$file_size.text($.jfbrother.fileSizeToStr(json_data.size));
	$file_size.attr('title',$.jfbrother.fileSizeToStr(json_data.size));
	//进度条
	var $progress = $('<div></div>').addClass('progress disk_progress');
	var $progress_value = $('<div class="progress-bar progress-bar-striped active" role="progressbar"></div>');
	$progress_value.css('width','0%');
	$progress.append($progress_value);
	//ok
	var $ok_span = $('<span></span>').addClass('glyphicon glyphicon-ok');
	//pause
	var $pause_span = $('<span></span>').addClass('glyphicon glyphicon-pause');
	$pause_span.bind('click',disk_uploadFile_stop);
	//remove
	var $remove_span = $('<span></span>').addClass('glyphicon glyphicon-remove');
	$remove_span.bind('click',disk_uploadFile_remove);
	
	$contaner_right.append($file_size).append($progress).append($ok_span).append($pause_span).append($remove_span);
	
	$('.disk_upload_right_content').append($contaner);
	
	//计算文件的大小以及个数
	$('#disk_upload_fileCount').text(file_index);
	var old_size = $('#disk_upload_fileSize').data('old_size') || 0;
	var new_size = old_size + json_data.size;
	$('#disk_upload_fileSize').text($.jfbrother.fileSizeToStr(new_size));
	//把原来的大小存放起来,便于以后的计算
	$('#disk_upload_fileSize').data('old_size',new_size);
}

//上传文件的删除
function disk_uploadFile_remove(){
	//去掉上传信息
	var $container = $(this).parent().parent();
	var file_size = $container.data('upload_data').size;
	//删除节点之后的所有文件信息的索引都减一
	$container.nextAll().each(function(index,element){
		var $span_index = $(element).children('div').eq(0).find('span').eq(0);
		var index = $span_index.text();
		$span_index.text(index.substring(0, index.length-1)-1+'.');
	})
	$container.remove();
	
	//修改文件个数和大小
	$('#disk_upload_fileCount').text($('#disk_upload_fileCount').text()-1);
	var old_size = $('#disk_upload_fileSize').data('old_size');
	var new_size = old_size-file_size;
	$('#disk_upload_fileSize').text($.jfbrother.fileSizeToStr(new_size));
	//把原来的大小存放起来,便于以后的计算
	$('#disk_upload_fileSize').data('old_size',new_size);
}

//文件上传的暂停和开始
function disk_uploadFile_stop(){
	if($(this).hasClass('glyphicon-pause')){
		//暂停
		
	}
	else{
		//开始
		
	}
	//进度条的动态效果
	$(this).prev().prev().find('.progress-bar').toggleClass('active');
	//修改图标
	$(this).toggleClass('glyphicon-play');
	$(this).toggleClass('glyphicon-pause');	 
}

//显示回收站
function disk_rubbish(){
	//删掉目录导航栏
	$('.disk_search_center>a').eq(0).nextAll().remove();
	
	//显示切换按钮
	$('.disk_content_toggleBtn').show();
	//标记下是否是切换到了回收站
	$('#disk_rubbish').data('rubbish',true);
	//模拟几条垃圾数据
	var infos = [
		{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
		{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
		{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
		{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
		{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
		{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
		{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'},
	]
	$('.disk_content_header>div:first-child>a').hide();
	$('.disk_rubbishBtn').show();
	
	//如果是列表时,或者是在分享码的列表时
	if($('.disk_content_toggleBtn').data('toggleList')||$('#disk_shareCode').data('shareCode')){
		//渲染列表
		init_disk_rubbish_list(infos);
	}
	else{
		//渲染块状
		//先清空容器
		$('.disk_content_lump').html('');
		//渲染块状
		for(var i = 0 ; i<infos.length;i++){
			init_disk_createLump(infos[i]);
		}	
	}
}

//还原文件
function disk_reductionFolder(handler){
	//右键还原文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		if(list_rows.length==0){
			var txt3 =  "请选择要还原的文件!!!";
			var option3 = {
				title: "还原提示",
				btn:parseInt("0001",2)
			}
			window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.confirm,option3);
		}
		else{
			var txt4 =  "是否要还原选中的文件!!!";
			var option4 = {
				title: "还原提示",
				onOk: function(){
					for(var i = 0; i<list_rows.length;i++){						
						//根据id来删除行
						$('#disk_content_list').bootstrapTable('removeByUniqueId',list_rows[i].id);
						//然后做还原操作
					}
				}
			}
			window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.warning,option4);
		}
	}
	else{
		//如果是块状时
		var lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		if(lump_rows.length==0){
			var txt1 =  "请选择要还原的文件!!!";
			var option1 = {
				title: "还原提示",
				btn:parseInt("0001",2)
			}
			window.wxc.xcConfirm(txt1, window.wxc.xcConfirm.typeEnum.confirm,option1);
		}
		else{
			var txt2 =  "是否要还原选中的文件!!!";
			var option2 = {
				title: "还原提示",
				onOk: function(){
					//先做删除
					for(var i = 0 ; i < lump_rows.length ; i ++){
						$(lump_rows[i]).parent().remove();
					}
					//再还原
				}
			}
			window.wxc.xcConfirm(txt2, window.wxc.xcConfirm.typeEnum.warning,option2);
		}
	}
}

//彻底删除文件
function disk_thoroughDeleteFolder(handler){
	//右键彻底删除文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
		if(list_rows.length==0){
			var txt3 =  "请选择要彻底删除的文件!!!";
			var option3 = {
				title: "彻底删除提示",
				btn:parseInt("0001",2)
			}
			window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.confirm,option3);
		}
		else{
			var txt4 =  "是否要彻底删除选中的文件!!!";
			var option4 = {
				title: "彻底删除提示",
				onOk: function(){
					for(var i = 0; i<list_rows.length;i++){						
						//根据id来删除行
						$('#disk_content_list').bootstrapTable('removeByUniqueId',list_rows[i].id);
						//然后做彻底删除操作
					}
				}
			}
			window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.warning,option4);
		}
	}
	else{
		//如果是块状时
		var lump_rows = $('.disk_content_lump').find('.disk_content_lump_click');
		if(lump_rows.length==0){
			var txt1 =  "请选择要彻底删除的文件!!!";
			var option1 = {
				title: "彻底删除提示",
				btn:parseInt("0001",2)
			}
			window.wxc.xcConfirm(txt1, window.wxc.xcConfirm.typeEnum.confirm,option1);
		}
		else{
			var txt2 =  "是否要彻底删除选中的文件!!!";
			var option2 = {
				title: "彻底删除提示",
				onOk: function(){
					//先做删除
					for(var i = 0 ; i < lump_rows.length ; i ++){
						console.log($(lump_rows[i]).data('lump_data'))
						$(lump_rows[i]).parent().remove();
					}
					//再彻底删除
				}
			}
			window.wxc.xcConfirm(txt2, window.wxc.xcConfirm.typeEnum.warning,option2);
		}
	}
}

//文件的共享
function disk_shareFolder(handler){
	//右键分享文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}
	
    var list_rows;
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
	}
	else{
		//如果是块状时
		var list_rows = $('.disk_content_lump').find('.disk_content_lump_click');
	}
	
	if(list_rows.length==0){
		var txt =  "请选择要分享的文件!!!";
		var option = {
			title: "分享提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.confirm,option);
		return;
	}
	
	//获得选中的数据
	var rows_data = [];
	for(var i=0;i<list_rows.length;i++ ){
		if($(list_rows[i]).data('lump_data')){
			//获得块状的数据
			rows_data.push($(list_rows[i]).data('lump_data'));
		}
		else{
			//获得列表的数据
			rows_data.push(list_rows[i]);
		}
	}
	console.log(rows_data)
	
	var strVar = "";
    strVar += "<div class=\"row\" style=\"margin:0px;width:468px;padding: 0px;border-radius: 5px;overflow: hidden;\">\n";
    strVar += "	<div class=\"disk_move_title\">分享文件 : <span><\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
    strVar += "	<div class=\"disk_createShare\">\n";
    strVar += "		<div class=\"col-md-12 disk_createShare_content\">\n";
    strVar += "			<div class=\"col-md-3\">分享的形式 : <\/div>\n";
    strVar += "			<div class=\"col-md-9\">\n";
    strVar += "				<select class=\"form-control\" id=\"disk_createShare_after_password\">\n";
    strVar += "					 <option value=\"0\">加密<\/option>\n";
    strVar += "					 <option value=\"1\">公开<\/option>\n";
    strVar += "		    	<\/select>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "		<div class=\"col-md-12 disk_createShare_content\">\n";
    strVar += "			<div class=\"col-md-3\">有效期选择 : <\/div>\n";
    strVar += "			<div class=\"col-md-9\">\n";
    strVar += "				<select class=\"form-control\" id=\"disk_createShare_after_date\">\n";
    strVar += "					 <option>永久有效<\/option>\n";
    strVar += "					 <option>7天<\/option>\n";
    strVar += "					 <option>1天<\/option>\n";
    strVar += "		    	<\/select>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "		<div class=\"col-md-12 disk_createShare_btn\">			\n";
    strVar += "			<span onclick=\"disk_createShare()\">创建链接<\/span><span onclick=\"$.fancybox.close()\">取消<\/span>\n";
    strVar += "		<\/div>\n";
    strVar += "	<\/div>\n";
    strVar += "	<div class=\"disk_createShare_after\">\n";
    strVar += "		<div class=\"disk_createShare_after_title\"><span class=\"glyphicon glyphicon-ok\"><\/span><span>分享文件链接创建成功 , <\/span><span id=\"disk_createShare_after_time\"><\/span><\/div>\n";
    strVar += "		<div class=\"col-md-12 disk_createShare_content\">\n";
    strVar += "			<div class=\"col-md-3\">分享链接 : <\/div>\n";
    strVar += "			<div class=\"col-md-9\">\n";
    strVar += "				<input type=\"text\" oninput=\"$(this).val($(this).data('value'));$(this).select()\" onfocus=\"$(this).select();\" class=\"form-control\" id=\"disk_createShare_after_link\"/>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "		<div class=\"col-md-12 disk_createShare_content\" style=\"margin-bottom:30px;\">\n";
    strVar += "			<div class=\"col-md-3\">分享密码 : <\/div>\n";
    strVar += "			<div class=\"col-md-9\">\n";
    strVar += "				<div class=\"col-md-6\"><input oninput=\"$(this).val($(this).data('value'));$(this).select()\" onfocus=\"$(this).select();\" type=\"text\" class=\"form-control\" id=\"disk_createShare_after_pwd\"/><\/div>\n";
    strVar += "				<div class=\"col-md-6\"><span onclick=\"disk_share_copy()\">复制链接和分享码<\/span><\/div>\n";
    strVar += "			<\/div>\n";
    strVar += "		<\/div>\n";
    strVar += "		<div id=\"disk_share_copy_message\" style=\"display:none;text-align:center;margin-bottom:0px;\" class=\"col-md-12 alert alert-success\" role=\"alert\">\n";
    strVar += "  		<a href=\"#\" class=\"alert-link\">复制成功<\/a>\n";
    strVar += "		<\/div>\n";
    strVar += "	<\/div>\n";
    strVar += "<\/div>\n";
	
	//分享文件
	$.fancybox.open(strVar,{
    	//显示之前触发
    	beforeShow : function( instance, current ) {
    		//去掉fancybox原来的间距
    		$('.fancybox-skin').css('padding','0');
		},
		//显示之后触发
    	afterShow : function( instance, current ){
    		//隐藏右上角的X
    		$('.fancybox-close').hide();
    	}
    });
	
	//如果只有一个文件时
	if(rows_data.length==1){
		$('.disk_move_title>span').eq(0).text(rows_data[0].fileName);
		$('.disk_move_title>span').eq(0).attr('title',rows_data[0].fileName);
	} 
	else{
		var fileNames = '';
		for(var i = 0 ;i<rows_data.length;i++){
			fileNames += rows_data[i].fileName + ',';
		}
		//截取掉最后一个','并且加个总个数
		fileNames = fileNames.substring(0, fileNames.length-1) + '(共'+ rows_data.length +'项)';
		$('.disk_move_title>span').eq(0).text(fileNames);
		$('.disk_move_title>span').eq(0).attr('title',fileNames);
	}    	
		
}

//创建分享链接
function disk_createShare(){
	$('.disk_createShare').hide();
	$('.disk_createShare_after').show();
	//分享形式
	var pwd = $('#disk_createShare_after_password').val();
	//有效时间
	var time = $('#disk_createShare_after_date').val();
	if(time=='永久有效'){
		$('#disk_createShare_after_time').text(time);
	}
	else{
		$('#disk_createShare_after_time').text('链接'+time+'后失效');
	}
	//如果分享为加密时
	if($('#disk_createShare_after_password').val()==0){
		//随机产生4位的随机数
		var rand = $.jfbrother.randomWord(true,4,4);
		$('#disk_createShare_after_pwd').val(rand);
	}
	else{
		//如果为公开时
		$('#disk_createShare_after_pwd').parent().css('visibility','hidden');
		$('#disk_createShare_after_pwd').parent().parent().prev().css('visibility','hidden');
		$('#disk_createShare_after_pwd').parent().next().find('span').text('复制链接');
	}
	
	//把原来的值存放起来
	$('#disk_createShare_after_pwd').data('value',$('#disk_createShare_after_pwd').val());
	//链接
	var old_href = location.href;
	var new_href = old_href.substring(0, old_href.lastIndexOf('/'));	
	$('#disk_createShare_after_link').val(new_href+'/share');
	//把原来的值存放起来
	$('#disk_createShare_after_link').data('value',$('#disk_createShare_after_link').val());	
}

//分享文件的链接和分享码
function disk_share_copy(){
	//要复制的内容
	var value;
	if($('#disk_createShare_after_pwd').val()==''){
		value = '链接 : '+$('#disk_createShare_after_link').val();
	}
	else{
		value ='链接 : '+$('#disk_createShare_after_link').val()+' 密码 : '+$('#disk_createShare_after_pwd').val();
	}
	//创建一个新的输入框来存放
	var oInput = $('<input type="text" />').val(value);
	$('body').append(oInput);
	//选中对象
	oInput.select();
	//执行浏览器复制命令
	document.execCommand("Copy");
	//复制后移除
	oInput.remove();
	//显示提示
	$('#disk_share_copy_message').fadeIn();
	//定时关闭了提示
	setTimeout(function() {
		$('#disk_share_copy_message').fadeOut();
	}, 3000)
}

//共享文件
function disk_enjoyFolder(handler){
	//右键共享文件时,如果是不能点击时
	if(handler&&$(handler).hasClass('disk_menu_noClick')){
		return;
	}

	var rows;
	//如果是列表时
	if($('.disk_content_toggleBtn').data('toggleList')){
		//如果是列表时
		rows = $('#disk_content_list').bootstrapTable('getSelections');
	}
	else{
		//如果是块状时
		rows = $('.disk_content_lump').find('.disk_content_lump_click');
	}
	
	if(rows.length==0){
		var txt =  "请选择要共享的文件!!!";
		var option = {
			title: "提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.confirm,option);
		return;
	}
	
	//获得选中的数据
	var rows_data = [];
	for(var i=0;i<rows.length;i++ ){
		if($(rows[i]).data('lump_data')){
			//获得块状的数据
			rows_data.push($(rows[i]).data('lump_data'));
		}
		else{
			//获得列表的数据
			rows_data.push(rows[i]);
		}
	}
	
	console.log(rows_data)
	
	var strVar = "";
    strVar += "<div style=\"width:268px;padding:0px;border-radius:5px;overflow:hidden;\">\n";
    strVar += "	<div class=\"disk_move_title\"><span>选择要共享的人<\/span><span onclick=\"$.fancybox.close()\" class=\"glyphicon glyphicon-remove\"><\/span><\/div>\n";
    strVar += "	<div id=\"disk_enjoyUser_tree\" style=\"height:220px;overflow:auto;\" class=\"ztree disk_move_tree\"><\/div>\n";
    strVar += "	<div class=\"disk_move_btn\">\n";
    strVar += "		<span onclick=\"disk_enjoyUser_save()\">确定<\/span><span onclick=\"$.fancybox.close()\">取消<\/span>\n";
    strVar += "	<\/div>\n";
    strVar += "<\/div>\n";
    
    $.fancybox.open(strVar,{
    	//显示之前触发
    	beforeShow : function( instance, current ) {
    		//去掉fancybox原来的间距
    		/*$('.fancybox-opened').css('width','268px');*/
    		$('.fancybox-skin').css('padding','0');
		},
		//显示之后触发
    	afterShow : function( instance, current ){
    		//隐藏右上角的X
    		$('.fancybox-close').hide();
    	}
    });
	
	//初始化文件目录
    init_disk_enjoyUser_tree(rows_data);
}

//我的分享码
function disk_shareCode(){
	$('#disk_shareCode').data('shareCode',true);
	//删掉目录导航栏
	$('.disk_search_center>a').eq(0).nextAll().remove();
	//隐藏切换视图的功能
	$('.disk_content_toggleBtn').hide();
	
	//模拟几条垃圾数据
	var infos = [
		{id:'uuid1',fileName:'分享文件1',shareTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB',shareCode:'UkN5',shareLink:'http://localhost:8080/jfV5portal/share',activeTime:'永久有效'},
		{id:'uuid2',fileName:'分享文件2',shareTime:'2018-06-18 12:10',fileType:'word',fileSize:'2MB',shareCode:'5238',shareLink:'http://localhost:8080/jfV5portal/share',activeTime:'7天后'},
		{id:'uuid3',fileName:'分享文件3',shareTime:'2018-06-18 12:10',fileType:'excel',fileSize:'5MB',shareCode:'fsdf',shareLink:'http://localhost:8080/jfV5portal/share',activeTime:'1天后'},
		{id:'uuid4',fileName:'分享文件4',shareTime:'2018-06-18 12:10',fileType:'rar',fileSize:'3MB',shareCode:'sd12',shareLink:'http://localhost:8080/jfV5portal/share',activeTime:'永久有效'},
		{id:'uuid5',fileName:'分享文件5',shareTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB',shareCode:'tret',shareLink:'http://localhost:8080/jfV5portal/share',activeTime:'永久有效'}
	]
	
	//显示取消分享的按钮
	$('.disk_content_header>div:first-child>a').hide();
	$('.disk_shareCodeBtn').show();
	
	//显示列表
	$('.disk_content_list').show();
	$('.disk_content_lump').hide();
	
	//渲染列表
	init_disk_shareCode_list(infos);	
}

//取消分享
function disk_cancelShareCode(handler){
	var list_rows = $('#disk_content_list').bootstrapTable('getSelections');
	if(list_rows.length==0){
		var txt3 =  "请选择要取消分享的文件!!!";
		var option3 = {
			title: "取消分享提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.confirm,option3);
	}
	else{
		var txt4 =  "是否要取消分享选中的文件!!!";
		var option4 = {
			title: "取消分享提示",
			onOk: function(){
				for(var i = 0; i<list_rows.length;i++){						
					//根据id来删除行
					$('#disk_content_list').bootstrapTable('removeByUniqueId',list_rows[i].id);
					//然后做取消分享操作
				}
			}
		}
		window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.warning,option4);
	}
}

//初始化我的分享码的列表
function init_disk_shareCode_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	
	$('#disk_content_list').bootstrapTable('destroy').bootstrapTable({
	     /* showColumns:true,
	     showToggle:true,
	     showRefresh:true,
	     search:true, */
	     /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
	     data:infos,
	     cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
	     /* striped: true,  //表格显示条纹，默认为false */
	     pagination: false, // 在表格底部显示分页组件，默认false
	     pageList: [5,10,15,20], // 设置页面可以显示的数据条数
	     pageSize: 10, // 页面数据条数
	     pageNumber: 1, // 首页页码,
	     uniqueId:'id',
	     clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
	     queryParams:function(params){
				  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
					   // limit: params.limit,   //页面大小  
					    offset: params.offset,  //页码  
					    pageSize:this.pageSize,  
					    pageNumber:this.pageNumber
					    /* projectId: $("#projectId").val(),  
					    requirement_Id:$("#requirement_Id").val(),  
					    length: 6  */ 
					};  
					return temp;
	     },
	     columns: [
	         {
	             checkbox: true, // 显示一个勾选框
	             align: 'center', // 居中显示
	             valign: 'middle'
	         },{
	             field: 'fileName',
	             title: '文件名称',
	             align: 'left',
	             valign: 'middle',
	             width:400,
	             formatter: function (value, row, index) { 
	            	 return '<div class="row disk_content_list_fileName"><div class="col-md-2"><img src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ></div><div class="col-md-10"><div style="color:#666;cursor:text;">'+ value +'</div><input type="text" value='+ value +' class="form-control" onblur="disk_input_blur(this)" /></div></div>';  
	             }
	         }, {
	             field: 'shareTime',
	             title: '分享时间',
	             align: 'center',
	             valign: 'middle',
	             order:'asc',
	             sortable:'true'
	         }, {
	             field: 'fileType',
	             title: '类型',
	             align: 'center',
	             valign: 'middle'
	         },{
	             field: 'fileSize',
	             title: '大小',
	             align: 'center',
	             valign: 'middle'
	         },{
	             field: 'shareCode',
	             title: '分享码',
	             align: 'center',
	             valign: 'middle'
	         },{
	             field: 'shareLink',
	             title: '分享链接',
	             align: 'center',
	             valign: 'middle'
	         },{
	             field: 'activeTime',
	             title: '有效时间',
	             align: 'center',
	             valign: 'middle'
	         }
	     ],
	     //选中时隐藏菜单
	     onCheck:function(row){
	    	 $('#disk_shareCode_menu').hide();
	     }
	})
}
