//全局存放下拉框的数据
var index_module_selectData ;

$(function(){
	//页面加载时给全局变量赋值
	index_module_selectData=jwAppPortletModel.jwAppsPortletDataAction.listAllPTemplate(/*{FIELD_COLUMN_ID:$('.layout_center_navClick').data('uuid')}*/).rowSet;
	
	//初始化地图
	init_index_map();
	
	//初始化搜索条件的点击事件
	init_index_search();
	
	//初始化合作伙伴的效果
	init_index_partner();
	
	//模块的拖动效果
	$( ".index_container" ).sortable({
		handle:'.index_container_header',//限制排序的动作只能在item元素中的某个元素开始。
		cancel:".index_container_header>img,.index_module_noMove,.index_container_big,.index_module_select",//图片都禁止拖动
		connectWith: ".index_container", //可放置的位置
		placeholder: "index_module_sortable", //提示的样式
		opacity: 0.5,//拖动的透明度 
		revert: true, //缓冲效果 
		/*stop: function(event, ui) {
			index_update_module();
		},*/
		update:function(event, ui){
			$('.index_insert_module>span').eq(3).show();
			$('.index_insert_module>span').eq(4).show();
			$('.index_insert_module>span').eq(2).hide();
			//显示提示信息
			$('.index_insert_module>.index_module_tip').show();
			index_module_edit();
		}
    });
	
	//初始化模块
	init_index_module();
	
	//动态添加新增模块的宽度
	$('.index_insert_module').css('width',$('.index_footer').width());
	
	//初始化应用
	init_index_application();
	
	//初始化日历控件
	init_index_fullCalendar();
	
})

//初始化模块
function init_index_module(){
	//d6926714-c220-4a7e-9ec0-3a23caebb179
	var data = jwAppPortletModel.jwAppsPortletDataAction.listAllPTemplateByUser({FIELD_COLUMN_ID:$('.layout_center_navClick').data('uuid')}).rowSet;
	//渲染模块
	index_load_module(data);
}

//渲染模块
function index_load_module(data){
	//先清除之前的html
	$('.index_container>.index_module').remove();
	//把原来的json数据保存起来
	//$('.index_container').data('jsonData',data);
	for(var i = 0 ;i < data.length ; i++){
		var crtDiv = $('<div></div>').addClass('index_module');
		var parentContainer=$("<div></div>").appendTo(crtDiv);
		$($('.index_container>.index_module_noMove')[0]).before(crtDiv);
		//正文填充
		index_module_fillContent(parentContainer,data[i]);
		
	}
	
}

//根据一个容器和某一个模块的数据数据去填充容器,如果传来下拉框的数据时,再创建下拉框
function index_module_fillContent(parentContainer,data,selectJson){
	var top=$("<div></div>").addClass('index_container_header');
	var context=$("<div></div>").addClass('index_module_container');
	parentContainer.append(top).append(context);
	
	//top头部布局
	top.append('<label class='+ data.ICON_CSS +'></label>');
	top.append('<span style="margin-right:5px;">'+data.TITLE+'</span>');
	top.append('<span>'+data.ENG_TITLE+'</span>');
	
	//是否传入下拉框
	if(selectJson){
		top.find('span').hide();
		//显示下拉框
		var selectData = selectJson;
		var select = $('<select></select>').addClass('index_module_select').bind('change',function(){
			index_module_select($(this),selectData);
		});
		//过滤数据
		select.bind('click',function(){
			var selectData = index_module_selectFilterData(index_module_selectData,$(this).prev().prev().text());
			//清除之前的数据
			select.html('');
			for(var i=0;i<selectData.length;i++){
				var option = $('<option></option>').text(selectData[i].TITLE).data('json',selectData[i]);
				if($(this).prev().prev().text()==selectData[i].TITLE){
					option.attr('selected','selected');
				}
				select.append(option);
			}
		});
		//一开始就加载一个
		var option = $('<option></option>').text(top.find('span').eq(0).text());
		select.append(option);
		
		//option.attr('selected','selected');
		top.append(select);
		select.click();
	}
	
	top.append('<img src="'+ctx+'/custom/images/index4_sectionover.png" width="17" height="17" onclick="index_module_remove(this)">');
	//是否显示最大按钮
	if(data.MAX_BTN==1){
		top.append('<img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)">');
	}
	top.append('<img src="'+ctx+'/custom/images/index4_sectionsmall.png" width="17" height="17" onclick="index_module_toggle(this)">');
	
	//初始化容器宽度
	var width;
	switch (data.WIDTH) {
	case 1:
		width='33.33%';
		break;
	case 2:
		width='66.66%';
		break;
	case 3:
		width='100%';
		break;
	default:
		width='33.33%';
		break;
	}
	context.parent().parent().css('width',width);
	switch (data.P_TYPE) {
	case '0':
		//手工录入
		//存在样式时
		if(data.P_STYLE){
			context.append('<style type="text/css">'+ data.P_STYLE +'</style>')
		}
		context.append(data.CONTENT);
		break;
	case '1':
		//单点集成
		//添加加载时的效果
		context.append($.jfbrother.loadStyle());
		var iframe = $('<iframe src="'+ data.URL +'" frameborder="0" width="100%" height="100%" ></iframe>');
		context.append(iframe);

		//iframe加载完之后的处理
		ifame_isLoad(iframe);
		
		break;
	case '3':
		//RSS订阅
		//添加加载时的效果
		context.append($.jfbrother.loadStyle());
		$.jfbrother.readRSS(data.URL,context,function(rss,context){
			//去掉加载时的效果
			context.html('');
			var item = rss.rss.channel.item; 
			var itemContainer = $('<div class="index_container_two_right_text"></div>');
			var index = item.length>10?10:infos.length;
			for(var i = 0 ; i < index;i++){
				//如果长度超过10时就不继续添加了
				if(item.length>10 && i==index-1){
					break;
				}
				var itemDiv = $('<div></div>').data('item',item[i]).bind('click',function(){
					if(data.IS_POP=='0'){
						//1.弹出框
						$.fancybox.open({href:$(this).data('item').link,type: 'iframe','width':$('.index_container').width()-10});
					}
					else{
						//2.新页面
						window.open($(this).data('item').link);
					}
				});
				itemDiv.hover(function(){
					$(this).find('label').stop().animate({'marginRight':'0'});
				},function(){
					$(this).find('label').stop().animate({'marginRight':'10px'});
				})
				var itemTitle=$('<span></span>').text(item[i].title);
				var itemImg = $('<label></label>').text('>');
				itemDiv.append(itemImg).append(itemTitle)
				itemContainer.append(itemDiv);
			}
			context.append(itemContainer)
			
			//如果个数超过10个的时候显示更多
			if(item.length>10){
				var module_more = $('<div class="index_module_more">>>更多</div>');
				module_more.bind('click',function(){
					index_rss_more(data,item,1,10);
				})
				itemContainer.append(module_more);
			}
			
		});
		
		break;
	case '4':
		//模拟登录
		//添加加载时的效果
		context.append($.jfbrother.loadStyle());
		//1.先做模拟登录
		var web_info= data.WEB_INFO;
		//新建一个iframe加到body去
		var index_module_iframeContainer = $('<iframe width="0" height="0" frameborder="0" />').attr('name',data.PORTLET_ID).attr('src',data.URL);
		$(document.body).append(index_module_iframeContainer);
		
		var base = new Base64();
		//创建表单
		var info_form=$('<form style="display:none"></form>').attr('action',web_info.URL).attr('target',data.PORTLET_ID);
		var info_input=web_info.FORM_NAME.split(',');
		var info_userName=$('<input />').attr('name',info_input[0]).val(web_info.USER_ID);
		var info_password=$('<input />').attr('name',info_input[1]).val(base.decode(web_info.USER_PWD));
		info_form.append(info_userName).append(info_password);
		context.append(info_form);
		//表单提交
		info_form.submit();
		//表单提交的iframe加载完成时
		ifame_isLoad(index_module_iframeContainer,function(){
			//去除表单
			info_form.remove();
			//再请求一个iframe
			var iframe = $('<iframe src="'+ index_module_iframeContainer.attr('src') +'" frameborder="0" width="100%" height="100%"></iframe>');
			//去除之前创建的iframe
			index_module_iframeContainer.remove();
			context.append(iframe);
			ifame_isLoad(iframe);
		});
		
		break;
	case '5':
		//内容发布,列表
		var listContainer = $('<div></div>').addClass('index_container_two_right_text');
		var infos = data.INFOS;
		var index = infos.length>10?10:infos.length;
		for(var i= 0;i<index;i++){
			if(infos.length>10 && i==index-1){
				break;
			}
			var infos_title = $('<div></div>').data('info',infos[i]);
			infos_title.hover(function(){
				$(this).find('label').stop().animate({'marginRight':'0'});
			},function(){
				$(this).find('label').stop().animate({'marginRight':'10px'});
			})
			infos_title.append('<label>></label>');
			infos_title.append('<span>'+ infos[i].TITLE +'</span>');
			infos_title.bind('click',function(){
				var info = $(this).data('info');
				if(data.IS_POP=='0'){
					//弹出
					var infe_detal = $('<div style="min-height:500px;"><div class="index_module_infoTitle">'+info.TITLE+'</div><div class="index_module_infoContent">'+info.CONTENT+'</div></div>');
					infe_detal.css('width',$('.index_container').width()-10);
					$.fancybox.open(infe_detal);
				}
				else{
					//新页面	
					alert('新页面')
					console.log(data)
				}
			})
			listContainer.append(infos_title);
		}
		
		if(infos.length>10){
			var module_more = $('<div class="index_module_more">>>更多</div>');
			module_more.bind('click',function(){
				index_contentList_more(infos,1,10);
				//end
			})
			listContainer.append(module_more);
		}
		context.append(listContainer);
		break;
	default:
		break;
	}
	//绑定数据
	context.parent().data('data',data);
}

//初始化合作伙伴的效果
function init_index_partner(){
	$('.index_container_partner_text img').hover(function(){
		var src = $(this).attr('src');
		var index = src.lastIndexOf("_");
		$(this).attr('src',src.substring(0, index)+'.jpg');
	},function(){
		var src = $(this).attr('src');
		var index = src.lastIndexOf(".");
		$(this).attr('src',src.substring(0, index)+'_gray.jpg');
	})
}

function init_index_search(){
	//搜索的效果
	$('.index_search_show_content span').unbind("click").bind('click',function(){
		if($(this).attr('class')=='index_search_show_result_click'){
			return;
		}	
		var index = $('.index_search_show_content span').index($(this));
		/*var oldIndex = $('.index_search_show_content span').index($(this).parent().find('.index_search_show_result_click'));
		$(this).parent().find('.index_search_show_result_click').removeClass('index_search_show_result_click');*/
		$(this).addClass('index_search_show_result_click');
		$(this).data('id',index);
		/*//先删除之前选中的
		$('#index_search_show_result>div').each(function(index,element){
			if($(element).data('id')==oldIndex){
				$(element).remove();
			}
		})*/
		//添加到搜索结果中
		var $div = $('<div class="index_search_show_result_content"><span>'+ $(this).text() +'</span><span onclick="index_search_show_result_remove(this)"><img src="'+ctx+'/custom/images/search_turn off.png" width="10" height="10" /></span></div>');
		$div.data('id',index);
		$('#index_search_show_result').append($div);
		animate_autoHeight($('.index_search_content'));
	})
}
//初始化地图
function init_index_map(key){
	//先显示加载图片
	$('#index_map').prev().show();
	/*var map = new BMap.Map("index_map");
	map.centerAndZoom(new BMap.Point(116.404, 39.915), 11);
	map.addControl(new BMap.MapTypeControl({mapTypes: [BMAP_NORMAL_MAP,BMAP_HYBRID_MAP]}));     //2D图，卫星图    右上角
	map.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_LEFT}));    //左上角，默认地图控件
	map.setCurrentCity("北京");   //由于有3D图，需要设置城市哦   ,目前支持北京、上海、广州、深圳4个城市3D图*/	

	//地图信息
	var map = new BMap.Map("index_map");
	var geolocation = new BMap.Geolocation();
	geolocation.getCurrentPosition(function(r){
		if(this.getStatus() == BMAP_STATUS_SUCCESS){
			/*map.panTo(r.point);//地图中心点移到当前位置*/  		
			/*alert('您的位置：'+r.point.lng+','+r.point.lat);*/
			var point = new BMap.Point(r.point.lng,r.point.lat);
			map.centerAndZoom(point,12);
			/*map.enableScrollWheelZoom(true);     //开启鼠标滚轮缩放*/
			// 创建地理编码实例      
			var myGeo = new BMap.Geocoder();      
			if(key){
				// 将地址解析结果显示在地图上,并调整地图视野
				myGeo.getPoint(key, function(result){
					point = result;
					map.centerAndZoom(point, 12);
					if(result){
						//如果存在时则添加一个标注
						map.addOverlay(new BMap.Marker(point));
					}
					//文字提示
					index_show_mapTip(map,myGeo,point);
				});
			}
			else{
				var mk = new BMap.Marker(r.point);
				map.addOverlay(mk);
				//文字提示
				index_show_mapTip(map,myGeo,point);
			}
		}
		else {
			alert('failed'+this.getStatus());
		}        
	});
	
	//地图加载完毕时
	map.addEventListener("tilesloaded",function(){
		$('#index_map').prev().fadeOut();
		
		//修改信息窗口样式
		$('.index_map_more').hover(function(){
			$(this).css('borderBottom','1px solid #1887f6');
		},function(){
			$(this).css('borderBottom','0');
		})
		$('.BMap_bubble_title').css({'fontWeight':'bold','fontSize':'16px','marginBottom':'10px'});
	});
}

//显示地图的提示文字
function index_show_mapTip(map,myGeo,point){
	// 根据坐标得到地址描述    
	myGeo.getLocation(point, function(result){      
	    if (result){    
	    	var opts = {    
			    width : 80,     // 信息窗口宽度    
			    height: 90,     // 信息窗口高度    
			    title : "您所在的位置:",  // 信息窗口标题
			}  
			//创建信息窗口对象   
	    	if(result.addressComponents.province==result.addressComponents.city){
	    		var infoWindow = new BMap.InfoWindow(result.addressComponents.province + " - " + result.addressComponents.district +"<div style='float:right;margin-top:30px;' class='index_map_more'><a style='color:#1887f6' href='javascript:window.open(\"http://www.edushi.com/mapcity.html\")'>查看三维地图详情</a></div>", opts);
	    	}
	    	else{
	    		var infoWindow = new BMap.InfoWindow(result.addressComponents.province + " - " + result.addressComponents.city + " - " + result.addressComponents.district +"<div style='float:right;margin-top:30px;' class='index_map_more'><a style='color:#1887f6' href='javascript:window.open(\"http://www.edushi.com/mapcity.html\")'>查看三维地图详情</a></div>", opts);
	    	}
	    	
	    	//map.addControl(new BMap.NavigationControl());  //左上角移动控件
			map.addControl(new BMap.ScaleControl());       //左下角标尺控件
			map.addControl(new BMap.OverviewMapControl()); //右下角缩略地图，注意观察，不然看不到
			map.addControl(new BMap.MapTypeControl({mapTypes: [BMAP_NORMAL_MAP,BMAP_HYBRID_MAP]}));     //右上角  地图控件
			
			if(result.addressComponents.city=="北京市"||result.addressComponents.city=="上海市"||result.addressComponents.city=="广州市"||result.addressComponents.city=="深圳市"){
				map.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_LEFT}));    //左上角 地图控件	
				map.setCurrentCity(result.addressComponents.city);   //由于有3D图，需要设置城市哦   ,目前支持北京、上海、广州、深圳4个城市3D图
			}
			else{
				map.addControl(new BMap.MapTypeControl({anchor: BMAP_ANCHOR_TOP_LEFT,mapTypes: [BMAP_NORMAL_MAP,BMAP_SATELLITE_MAP,BMAP_HYBRID_MAP]}));    //左上角 地图控件
			}
	    	
			//打开信息窗口
			map.openInfoWindow(infoWindow, map.getCenter());           
	    }      
	});
}


//点击搜索时
function index_search(handler){
	$('.index_search_content>input').val('');
	var $obj = $(handler).parent(); 
	$obj.css({"background":"white"});
	animate_autoHeight($obj);
}	

//animate 自适应容器的高度
function animate_autoHeight(handler){
	var $obj = $(handler); 
	var currentHeight = $obj.css("height");
	$obj.css({"height":"auto"});
	var animateHeight = $obj.css("height");
	$obj.css("height", currentHeight);
	$obj.animate({height: animateHeight});
}

//删除查询条件
function index_search_show_result_remove(handler){
	var oldIndex = $(handler).parent().data('id');
	$(handler).parent().remove();
	animate_autoHeight($('.index_search_content'));
	$('.index_search_show_content span').each(function(index,element){
		if($(element).data('id')==oldIndex){
			$(element).removeClass('index_search_show_result_click');
		}
	})
}

//点击取消时
function index_search_show_result_close(){
	$('.index_search_content').animate({height:'48px'},function(){
		if($('.index_search_content>input').val()==''){
			$('.index_search_content>input').val('大数据搜索引擎');
		}
	});
}

//模块隐藏的效果
function index_hide_active(selectedEffect, handler, callback) {
	// 从中获取特效类型
	var selectedEffect = selectedEffect;

	// 大多数的特效类型默认不需要传递选项
	var options = {};
	// 一些特效带有必需的参数
	if (selectedEffect === "scale") {
		options = {
			percent : 0
		};
	} else if (selectedEffect === "size") {
		options = {
			to : {
				width : 200,
				height : 60
			}
		};
	}

	if (typeof callback == 'function') {
		// 运行特效
		$(handler).hide(selectedEffect, options, 1000, callback);
	} else {
		// 运行特效
		$(handler).hide(selectedEffect, options, 1000);
	}
}

//模块显示的效果
function index_show_active(selectedEffect, handler, callback) {
	// 从中获取特效类型
	var selectedEffect = selectedEffect;

	// 大多数的特效类型默认不需要传递选项
	var options = {};
	// 一些特效带有必需的参数
	if (selectedEffect === "scale") {
		options = {
			percent : 100
		};
	} else if (selectedEffect === "size") {
		options = {
			to : {
				width : 280,
				height : 185
			}
		};
	}

	if (typeof callback == 'function') {
		// 运行特效
		$(handler).show(selectedEffect, options, 500, callback);
	} else {
		// 运行特效
		$(handler).show(selectedEffect, options, 500);
	}
}

//伸缩模块
function index_module_toggle(handler){
	if($(handler).parent().nextAll().is(":animated")){
		return;
	}	
	if($(handler).attr('src')==ctx+'/custom/images/index4_sectionsmall.png'){
		$(handler).attr('src',ctx+'/custom/images/index4_sectionlarge.png');
		//如果存在最大功能就隐藏
		if($(handler).parents('.index_module').data('data')&&$(handler).parents('.index_module').data('data').MAX_BTN==1){
			//隐藏变大功能
			$(handler).prev().remove();
		}
	}
	else{
		$(handler).attr('src',ctx+'/custom/images/index4_sectionsmall.png');
		//如果存在最大功能就显示
		if($(handler).parents('.index_module').data('data')&&$(handler).parents('.index_module').data('data').MAX_BTN==1){
			//显示变大功能
			$(handler).before('<img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)">');
		}
	}
	$(handler).parent().nextAll().slideToggle();
}

//删除模块
function index_module_remove(handler){
	var txt=  "是否要删除该板块!!!";
	var option = {
		title: "删除提示",
		onOk: function(){
				
				//删除模板的html代码
				index_hide_active('shake',$(handler).parent().parent().parent(),function(){
				$(handler).parent().parent().parent().remove();
				//显示模块修改提示
				index_module_custom($('.index_insert_module').find('span').eq(2));
			});
		},
		onCancel:function(){
			
		}
	}
	window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.warning,option);
}

//修改模块到数据库
function index_update_module(handler){
	//1.把现在的布局保存在index_container容器中
	var newJson = [];
	$('.index_module>div').each(function(index,element){
		newJson.push($(element).data('data'))
		//去掉下拉框
		$(element).find('.index_container_header>span').show();
		$(element).find('.index_container_header>select').hide();
		//显示标题
	})
	//$('.index_container').data('jsonData',newJson);
	
	//2.存放到数据库
	var portlets=[];
	for(var i=0;i<newJson.length;i++){
		//如果是新增模块时
		if(!newJson[i]){
			$.fancybox.open('<div style="color: #1887f6;font-weight: bold;font-size:18px;line-height:30px;">还有资源没有选择...</div>');
			setTimeout('$.fancybox.close();index_module_edit()',1000);
			return;	
		}
		var requestObj={};
		requestObj.PORTLET_ID=newJson[i].PORTLET_ID;
		portlets.push(requestObj);
	}
	var layout={
		columnsId:$('.layout_center_navClick').data('uuid'),
		portlets:portlets
	};
	layout=JSON.stringify(layout);
	var result = jwAppPortletModel.jwAppsPortletActAction.saveLayout({
	    layout: layout
	});
	if(result.NAME==2){
		//3.隐藏确定和取消按钮
		$(handler).prev().hide();
		$(handler).hide();
		//显示自定义资源
		$(handler).prev().prev().show();
		//隐藏提示信息
		$('.index_insert_module>.index_module_tip').hide();
	}
}

//取消模块的移动
function index_cancel_module(handler){
	//根据index_container原来的布局数据去重新渲染下
	//index_load_module($('.index_container').data('jsonData'));
	//隐藏确定和取消按钮
	$(handler).next().hide();
	$(handler).hide();
	//显示自定义资源
	$(handler).prev().show();
	//隐藏提示信息
	$('.index_insert_module>.index_module_tip').hide();
	
	$('.index_module').each(function(index,element){
		//去掉下拉框
		$(element).find('.index_container_header>span').show();
		$(element).find('.index_container_header>select').hide();
		//显示标题
	})
	
}

//放大功能
function index_changeBig_calendar(handler){
	if($(handler).prevAll('select').css('display')=='inline-block'){
		$.fancybox.open('<div style="color: #1887f6;font-weight: bold;font-size:18px;line-height:30px;">正处于编辑状态,无法放大...</div>');
		setTimeout('$.fancybox.close()',1000);
		return;
	}
	//先判断下其他模块有没有放大
	if($('.index_container_big').length!=0){
		$('.index_container_big').find('.index_container_header>img').click()
	}
	var data = $(handler).parents('.index_module').data('data');
	$(handler).parents('.index_module').css({'top':$(handler).offset().top-14,'width':$('.index_footer').outerWidth(),'left':$('.index_footer').offset().left});
	$(handler).parents('.index_module').addClass('index_container_big');
	var $imgParent = $(handler).parent();
	$imgParent.find('img').remove();
	$imgParent.append('<img src="'+ ctx +'/custom/images/index4_sectionsmall.png" style="display:block;" width="17" height="17" onclick="index_changeSmall_calendar(this)">');
	$imgParent.next().css({'maxHeight':'500px','height':'auto','minHeight':'315px'});
	if(!data){
		$imgParent.parent().parent().data("width", "33.33%");
		return;
	}
	switch (data.WIDTH) {
	case 1:
		$imgParent.parent().parent().data("width", "33.33%");
		break;
	case 2:
		$imgParent.parent().parent().data("width", "66.66%");
		break;
	case 3:
		$imgParent.parent().parent().data("width", "100%");
		break;
	default:
		$imgParent.parent().parent().data("width", "33.33%");
		break;
	}	
}

//缩小功能
function index_changeSmall_calendar(handler){
	$(handler).parents('.index_module').css({'width':$(handler).parents('.index_module').data('width')});
	$(handler).parents('.index_module').removeClass('index_container_big');
	var $imgParent = $(handler).parent();
	$imgParent.find('img').remove();
	$imgParent.append('<img src="'+ctx+'/custom/images/index4_sectionover.png" width="17" height="17" onclick="index_module_remove(this)" /><img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)" /><img src="'+ctx+'/custom/images/index4_sectionsmall.png" width="17" height="17" onclick="index_module_toggle(this)" />');
	$imgParent.next().css({'maxHeight':'','minHeight':'','height':'315px'});
}

//判断ifame是否加载完成,参数jquery的iframe对象
function ifame_isLoad(iframe,callback){
	if(iframe[0].attachEvent){
		//ie浏览器
		iframe[0].attachEvent("onreadystatechange", function() {
			//此事件在内容没有被载入时候也会被触发，所以我们要判断状态
			//有时候会比较怪异 readyState状态会跳过 complete 所以我们loaded状态也要判断
			if (iframe[0].readyState === "complete" || iframe[0].readyState == "loaded") {
				//代码能执行到这里说明已经载入成功完毕了
				//要清除掉事件
				if(typeof callback == 'function'){
					callback();
				}
				else{
					iframe.prev().remove();
				}
				iframe[0].detachEvent("onreadystatechange", arguments.callee);
				//这里是回调函数
			}
		});
	}
	else{
		//其他浏览器（Firefox,Opera,chrome等 ）
		iframe[0].addEventListener("load", function() {
			//代码能执行到这里说明已经载入成功完毕了
			this.removeEventListener("load", arguments.call, false);
			//这里是回调函数
			if(typeof callback == 'function'){
				callback();
			}
			else{
				iframe.prev().remove();
			}
		}, false);
	}
}

//点击自定义资源时
function index_module_custom(handler){
	$(handler).next().show();
	$(handler).next().next().show();
	$(handler).hide();
	index_module_edit();	
	//显示提示信息
	$('.index_insert_module>.index_module_tip').show();
}

//模块的修改
function index_module_edit(){
	//如果有模块已经放大时
	if($('.index_container_big').length!=0){
		$('.index_container_big').find('.index_container_header>img').click();
	}
	
	$('.index_module').each(function(index,element){
		//隐藏标题
		$(element).find('.index_container_header>span').hide();
		if($(element).find('select').length!=0){
			$(element).find('select').show();
			return;
		}
		
		//显示下拉框
		var select = $('<select></select>').addClass('index_module_select').bind('change',function(){
			index_module_select($(this),index_module_selectData);
		});
		//过滤数据
		select.bind('click',function(){
			data = index_module_selectFilterData(index_module_selectData,$(this).prev().prev().text());
			//清除之前的数据
			select.html('');
			if($(this).prev().prev().text()=='新增资源'){
				select.append('<option selected>请选择资源</option>');
			}

			for(var i=0;i<data.length;i++){
				var option = $('<option></option>').text(data[i].TITLE).data('json',data[i]);
				if($(this).prev().prev().text()==data[i].TITLE){
					option.attr('selected','selected');
				}
				select.append(option);
			}
			
		});
		//一开始就加载一个
		var option = $('<option></option>').text($(element).find('.index_container_header>span').eq(0).text());
		select.append(option);
		
		//如果是新增时就新插入一条
		if($(element).find('label').next().text()=="新增资源"){			
			select.prepend('<option selected>请选择资源</option>');
		}
		$(element).find('.index_container_header>label+span+span').after(select);
		select.click();
	})
}

//下拉框的数据过滤
function index_module_selectFilterData(data,text){
	var newData=[];
	var oldData=[];
	$('.index_module').each(function(index,element){
		var title = $(element).find('.index_container_header>span').eq(0).text();
		if(title!=text){
			oldData.push(title);
		}
	})
	for(var i = 0;i<data.length;i++){  
        var flag = true;   
        for(var j=0; j < oldData.length; j++){   
            if(data[i].TITLE == oldData[j])   
            flag = false;   
        }   
        if(flag){
        	newData.push(data[i]);  
        }   
    }
	return newData;
}

//选中的下拉
function index_module_select(handler,selectJson){
	var data = $(handler).find('option:selected').data('json');
	//先清空现有的html
	var parent = $(handler).parents('.index_module>div');
	parent.html('');
	//根据json数据去渲染模板
	index_module_fillContent(parent,data,selectJson);
	
}

//新增资源
function index_module_insert(handler){
	var creDiv = $('<div></div>').addClass('index_module');
	var parentContainer = $("<div></div>").appendTo(creDiv);
	var top=$("<div></div>").addClass('index_container_header');
	var context=$("<div></div>").addClass('index_module_container');
	parentContainer.append(top).append(context);
	//top头部布局
	top.append('<label class="icon-edit"></label>');
	top.append('<span style="margin-right:5px;">新增资源</span>');
	top.append('<span>Insert Resource</span>');
	
	top.append('<img src="'+ctx+'/custom/images/index4_sectionover.png" width="17" height="17" onclick="index_module_remove(this)">');
	top.append('<img src="'+ctx+'/custom/images/index4_sectionbig.png" width="17" height="17" onclick="index_changeBig_calendar(this)">');
	top.append('<img src="'+ctx+'/custom/images/index4_sectionsmall.png" width="17" height="17" onclick="index_module_toggle(this)">');
	var contextContainer = $('<div class="index_module_insertBtn">请选择资源</div>');
	context.append(contextContainer);
	$($('.index_container>.index_module_noMove')[0]).before(creDiv);
	index_module_custom($(handler).next());
}

//Base64编码
function Base64() {  
	   
    // private property  
    _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";  
   
    // public method for encoding  
    this.encode = function (input) {  
        var output = "";  
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;  
        var i = 0;  
        input = _utf8_encode(input);  
        while (i < input.length) {  
            chr1 = input.charCodeAt(i++);  
            chr2 = input.charCodeAt(i++);  
            chr3 = input.charCodeAt(i++);  
            enc1 = chr1 >> 2;  
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);  
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);  
            enc4 = chr3 & 63;  
            if (isNaN(chr2)) {  
                enc3 = enc4 = 64;  
            } else if (isNaN(chr3)) {  
                enc4 = 64;  
            }  
            output = output +  
            _keyStr.charAt(enc1) + _keyStr.charAt(enc2) +  
            _keyStr.charAt(enc3) + _keyStr.charAt(enc4);  
        }  
        return output;  
    }  
   
    // public method for decoding  
    this.decode = function (input) {  
        var output = "";  
        var chr1, chr2, chr3;  
        var enc1, enc2, enc3, enc4;  
        var i = 0;  
        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");  
        while (i < input.length) {  
            enc1 = _keyStr.indexOf(input.charAt(i++));  
            enc2 = _keyStr.indexOf(input.charAt(i++));  
            enc3 = _keyStr.indexOf(input.charAt(i++));  
            enc4 = _keyStr.indexOf(input.charAt(i++));  
            chr1 = (enc1 << 2) | (enc2 >> 4);  
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);  
            chr3 = ((enc3 & 3) << 6) | enc4;  
            output = output + String.fromCharCode(chr1);  
            if (enc3 != 64) {  
                output = output + String.fromCharCode(chr2);  
            }  
            if (enc4 != 64) {  
                output = output + String.fromCharCode(chr3);  
            }  
        }  
        output = _utf8_decode(output);  
        return output;  
    }  
   
    // private method for UTF-8 encoding  
    _utf8_encode = function (string) {  
        string = string.replace(/\r\n/g,"\n");  
        var utftext = "";  
        for (var n = 0; n < string.length; n++) {  
            var c = string.charCodeAt(n);  
            if (c < 128) {  
                utftext += String.fromCharCode(c);  
            } else if((c > 127) && (c < 2048)) {  
                utftext += String.fromCharCode((c >> 6) | 192);  
                utftext += String.fromCharCode((c & 63) | 128);  
            } else {  
                utftext += String.fromCharCode((c >> 12) | 224);  
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);  
                utftext += String.fromCharCode((c & 63) | 128);  
            }  
   
        }  
        return utftext;  
    }  
   
    // private method for UTF-8 decoding  
    _utf8_decode = function (utftext) {  
        var string = "";  
        var i = 0;  
        var c = c1 = c2 = 0;  
        while ( i < utftext.length ) {  
            c = utftext.charCodeAt(i);  
            if (c < 128) {  
                string += String.fromCharCode(c);  
                i++;  
            } else if((c > 191) && (c < 224)) {  
                c2 = utftext.charCodeAt(i+1);  
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));  
                i += 2;  
            } else {  
                c2 = utftext.charCodeAt(i+1);  
                c3 = utftext.charCodeAt(i+2);  
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));  
                i += 3;  
            }  
        }  
        return string;  
    }  
} 

//uuid
function uuid() {
    var s = [];
    var hexDigits = "0123456789abcdef";
    for (var i = 0; i < 36; i++) {
        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
    }
    s[14] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
    s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01
    s[8] = s[13] = s[18] = s[23] = "-";
 
    var uuid = s.join("");
    return uuid;
}

//应用管理的点击
function index_application(handler){
	//如果有模块已经放大时
	if($('.index_container_big').length!=0){
		$('.index_container_big').find('.index_container_header>img').click();
	}

	$.fancybox.open({href:ctx+'/jfcas04/application.jsp',type: 'iframe',width:$('.index_container').width()-10});
}

//初始化应用
function init_index_application(data){
	var list_row = data;
	var app_container = $('.index_container_application_text');
	//清空容器
	app_container.html('');
	//把未安装的app过滤掉
	var list_insert = [];
	if(!data){
		list_row = jwAppAppsModel.jwAppsAppsDataAction.list_allApps_by_user();

		var list_allApps = list_row.apps.rowSet;
		//flag区分是否存在已经安装的
		var flag = true;
		for(var j=0;j<list_allApps.length;j++){
			if(list_allApps[j].USERID){
				list_insert.push(list_allApps[j]);
				flag=false;
			}
		}
		//如果没有应用时
		if(flag==true){
			app_container.append('<span onclick="index_application()" class="index_application_noApp">暂无安装的应用,请去添加...</span>');
			return;
		}
	}
	else{	
		list_insert = list_row;
		if(list_insert.length==0){
			app_container.append('<span onclick="index_application()" class="index_application_noApp">暂无安装的应用,请去添加...</span>');
			return;
		}
	}
	
	//形成模板
	for(var i = 0;i<list_insert.length;i++){
		var app_div = $('<div></div>');
		var app_contet=$('<div></div>').data('app',list_insert[i]);
		app_contet.bind('click',function(){
			var data = $(this).data('app');
			if(data.IS_POPUP=='1'){
				//弹出框
				$.fancybox.open({href:data.LINK,type: 'iframe',width:$('.index_container').width()-10});
			}	
			else{
				//新页面
				window.open(data.LINK);
			}
		});
		/*//每隔5个加个样式
		if((i+1)%5==0){
			app_div.css('marginRight','0');
		}*/
		var app_img=$('<img  width="100" height="100" />').attr('src',ctx+'/photo/photo.jsp?ls_photo='+list_insert[i].IMG_ID_S);
		var app_span=$('<span></span>').text(list_insert[i].NAME);
		app_contet.append(app_img).append(app_span);
		app_div.append(app_contet);
		app_container.append(app_div);
	}
}

//内容发布,列表的显示更多
function index_contentList_more(infos,pageNumber,pageSize){
	var table_uuid = uuid();			
	var table=$('<div><table id='+table_uuid+'></table></div>').css({'width':$('.index_container').width()-27,'min-height':'430px'});
	$.fancybox({
		content : table
	})
	$.fancybox.prev();	
	//start
	$('#'+table_uuid).bootstrapTable({
          showColumns:true,
          showToggle:true,
          /*showRefresh:true,*/
          search:true,
          /*url: "bootstrap-table/data/data1.json", // 获取表格数据的url*/
          data:infos,
          cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
          striped: true,  //表格显示条纹，默认为false
          pagination: true, // 在表格底部显示分页组件，默认false
          pageList: [5,10,15,20], // 设置页面可以显示的数据条数
          pageSize: pageSize, // 页面数据条数
          pageNumber: pageNumber, // 首页页码
          columns: [
              /*{
                  checkbox: true, // 显示一个勾选框
                  align: 'center' // 居中显示
              },*/
              {
                  field: 'index', // 返回json数据中的name
                  title: '序号', // 表格表头显示文字
                  align: 'center', // 左右居中
                  valign: 'middle', // 上下居中
                  formatter: function (value, row, index) {  
                        return index+1;  
                  }
              }, {
                  field: 'TITLE',
                  title: '标题',
                  align: 'center',
                  valign: 'middle',
              }, {
                  field: 'CREATE_TIME',
                  title: '创建时间',
                  align: 'center',
                  valign: 'middle',
                  formatter: function (value, row, index){ // 单元格格式化函数
                      var time =  moment(value.time).format('YYYY-MM-DD HH:mm:ss')
                	  return time;
                  }
              }
          ],
          onClickRow:function(row,element){
        	  	var infe_rowDetal = $('<div style="min-height:500px;"><div class="index_module_infoTitle">'+row.TITLE+'</div><div class="index_module_infoContent">'+row.CONTENT+'</div></div>');
        	  	infe_rowDetal.css('width',$('.index_container').width()-27);
        	  	var pageNumText = $('.fixed-table-pagination .page-item.active>a').text();	
				var pageSizeText = $('.fixed-table-pagination .page-size').text();
        	  	$.fancybox({
					content : infe_rowDetal,
					afterShow:function(){
						//注意要把分页大小和页码转为number类型的
						//关闭时触发
						$('.fancybox-overlay').bind('click',function(){						
							index_contentList_more(infos,parseInt(pageNumText),parseInt(pageSizeText));
						})
						$('.fancybox-close').bind('click',function(){
							index_contentList_more(infos,parseInt(pageNumText),parseInt(pageSizeText));
							event.stopPropagation();
						})
						$('.fancybox-overlay>div').bind('click',function(){
							event.stopPropagation();
						})
					}
				});
				$.fancybox.prev();
		} 
    })
}

//rss订阅的更多详情
function index_rss_more(data,infos,pageNumber,pageSize){
	var table_uuid = uuid();			
	var table=$('<div><table id='+table_uuid+'></table></div>').css({'width':$('.index_container').width()-27,'min-height':'430px'});
	$.fancybox({
		content : table
	})
	$.fancybox.prev();	
	//start
	$('#'+table_uuid).bootstrapTable({
          showColumns:true,
          showToggle:true,
          /*showRefresh:true,*/
          search:true,
          /*url: "bootstrap-table/data/data1.json", // 获取表格数据的url*/
          data:infos,
          cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
          striped: true,  //表格显示条纹，默认为false
          pagination: true, // 在表格底部显示分页组件，默认false
          pageList: [5,10,15,20], // 设置页面可以显示的数据条数
          pageSize: pageSize, // 页面数据条数
          pageNumber: pageNumber, // 首页页码
          columns: [
              /*{
                  checkbox: true, // 显示一个勾选框
                  align: 'center' // 居中显示
              },*/
              {
                  field: 'index', // 返回json数据中的name
                  title: '序号', // 表格表头显示文字
                  align: 'center', // 左右居中
                  valign: 'middle', // 上下居中
                  formatter: function (value, row, index) {  
                        return index+1;  
                  }
              }, {
                  field: 'title',
                  title: '标题',
                  align: 'center',
                  valign: 'middle',
              }, {
                  field: 'pubDate',
                  title: '发布时间',
                  align: 'center',
                  valign: 'middle'
              }, {
                  field: 'source',
                  title: '来源',
                  align: 'center',
                  valign: 'middle'
              }, {
                  field: 'link',
                  title: '链接',
                  align: 'center',
                  valign: 'middle'
              }
          ],
          onClickRow:function(row,element){
        	  	var pageNumText = $('.fixed-table-pagination .page-item.active>a').text();	
				var pageSizeText = $('.fixed-table-pagination .page-size').text();
        	  	if(data.IS_POP=='0'){
        	  		//弹出层
        	  		$.fancybox({
            	  		href:row.link,
            	  		type:'iframe',
            	  		width:$('.index_container').width()-27,	
    					afterShow:function(){
    						//注意要把分页大小和页码转为number类型的
    						//关闭时触发
    						$('.fancybox-overlay').bind('click',function(){						
    							index_rss_more(data,infos,parseInt(pageNumText),parseInt(pageSizeText));
    						})
    						$('.fancybox-iframe',window.parent.document).parent().parent().parent().find('.fancybox-close').unbind().bind('click',function(event){
    							index_rss_more(data,infos,parseInt(pageNumText),parseInt(pageSizeText));
    						});
    					}
    				});
    				$.fancybox.prev();
        	  	}
        	  	else{
        	  		//2.新页面
        	  		window.open(row.link);
        	  	}
		} 
    })
}


//初始化日历插件
function init_index_fullCalendar() {
	$('#index_calendar').fullCalendar({
		header : {
			/*left : 'prev,next today prevYear,nextYear',*/
			left : 'prev,next today',
			center : 'title',
			right : 'month,agendaWeek,agendaDay'
		},
		/*defaultDate: '2018-03-12',*/
		navLinks : true, // can click day/week names to navigate views
		selectable : true,
		selectHelper : true,
		dayClick : function(date, allDay, jsEvent, view) {
			
			var start;
			var end;
			if (date._ambigTime == true) {
				start = moment(date, 'DD.MM.YYYY').format('YYYY-MM-DD');
				end = moment(date, 'DD.MM.YYYY').add(1, 'days').format('YYYY-MM-DD');
			} else {
				start = moment(date, 'mm.HH.DD.MM.YYYY').format('YYYY-MM-DD HH:mm');
				end = moment(date, 'mm.HH.DD.MM.YYYY').add(1, 'hour').format('YYYY-MM-DD HH:mm');
			}
			var strVar = index_fullCalendar_template('', '新增事件', '记录你将要做的一件事...', date._ambigTime, start, end);

			$.fancybox.open(strVar);
			init_index_color();

		},
		//编辑
		eventClick : function(calEvent, element, view) {
			
			//id
			var id = calEvent.id;
			//标题
			var title = calEvent.title;
			//是否全天
			var allDay = calEvent.allDay;
			//开始时间
			var start = calEvent.start._i;
			//结束时间
			var end = calEvent.end._i;
			//颜色
			var color = calEvent.color;

			var strVar = index_fullCalendar_template(id, '编辑事件', title, allDay, start, end);
			$.fancybox.open(strVar);
			init_index_color(color);

		},
		/*editable : true,*/
		/*eventLimit : true, // allow "more" link when too many events*/	
		events : ctx+'/date.json' 
	});
}

//模板  参数id,头标签,日程内容,开始时间,结束时间,是否是全天
function index_fullCalendar_template(id, header, title, allDay, start, end) {
	var strVar = "";
	strVar += "<div class=\"index_calendar\">\n";
	strVar += "	<input type=\"hidden\" value=\"@{id}\" id=\"index_calendarId\" />\n";
	strVar += "	<div class=\"index_calendar_header\">@{header}<\/div>\n";
	strVar += "    <div class=\"index_calendar_container\">\n";
	strVar += "	    <div class=\"index_calendar_text\">\n";
	strVar += "	    	<label for=\"index_calendarTitle\">日程内容：<\/label><input type=\"text\" id=\"index_calendarTitle\" value=\"@{title}\" />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_date\">\n";
	strVar += "	    	<label for=\"index_calendarStart\">开始时间：<\/label><input class=\"Wdate\" @{startTime} type=\"text\" id=\"index_calendarStart\" value=\"@{start}\"  />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_date\">\n";
	strVar += "	    	<label for=\"index_calendarEnd\">结束时间：<\/label><input class=\"Wdate\" @{endTime} type=\"text\" id=\"index_calendarEnd\" value=\"@{end}\" />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_date\">\n";
	strVar += "	    	<label for=\"index_calendarColor\">背景颜色：<\/label><input id=\"index_calendarColor\" />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_selete\">\n";
	strVar += "	    	<label><input onClick=\"index_allDay(this)\" type=\"checkbox\" value=\"1\" id=\"index_isAllDay\" @{allDay}> 全天<\/label>\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_btn\">\n";
	strVar += "	    	<span @{deleteBtn} onClick=\"index_removeDay()\">删除<\/span>\n";
	strVar += "	    	<span onClick=\"$.fancybox.close()\">取消<\/span>\n";
	strVar += "	    	<span onClick=\"index_submitClick()\">确定<\/span>\n";
	strVar += "	    <\/div>\n";
	strVar += "    <\/div>\n";
	strVar += "<\/div>\n";

	var json={
		id:id,
		header:header,
		title:title,
		allDay:allDay,
		start:start,
		end:end
	};
	//删除按钮
	if (id == '') {
		json.deleteBtn = 'style="display:none;"';
	}
	//全天
	if (allDay == true) {
		json.allDay='checked';
		json.startTime='onClick="index_startAllday()"';
		json.endTime='onClick="index_endAllday()"';
	} else {
		json.startTime='onClick="index_start()"';
		json.endTime='onClick="index_end()"';
	}
	newStr=$.jfbrother.replaceByJson(strVar,json);
	return newStr;
}

//点击全天时
function index_allDay(handler) {
	if ($(handler).prop('checked') == true) {

		if ($('#index_calendarStart').val() != '') {
			$(handler).data('startHour', $('#index_calendarStart').val().substring($('#index_calendarStart').val().length - 6));
			$(handler).data('start', $('#index_calendarStart').val().substring(0, $('#index_calendarStart').val().length - 6));
		} else {
			$(handler).data('start', $('#index_calendarStart').val());
		}

		if ($('#index_calendarEnd').val() != '') {
			$(handler).data('endHour', $('#index_calendarEnd').val().substring($('#index_calendarEnd').val().length - 6));
			$(handler).data('end', $('#index_calendarEnd').val().substring(0, $('#index_calendarEnd').val().length - 6));
		} else {
			$(handler).data('end', $('#index_calendarEnd').val());
		}

		var startParent = $('#index_calendarStart').parent();
		$('#index_calendarStart').remove();
		var newStartInput = $('<input class="Wdate" onclick="index_startAllday()" type="text" id="index_calendarStart" style="margin-left:-4px;" />');
		newStartInput.val($(handler).data('start'));
		startParent.append(newStartInput);

		var endParent = $('#index_calendarEnd').parent();
		$('#index_calendarEnd').remove();
		var newEndInput = $('<input class="Wdate" onclick="index_endAllday()" type="text" id="index_calendarEnd" style="margin-left:-4px;" />');
		newEndInput.val($(handler).data('end'));
		endParent.append(newEndInput);

	} else {

		if ($('#index_calendarStart').val() != '') {
			if ($(handler).data('startHour')) {
				$(handler).data('start', $('#index_calendarStart').val() + $(handler).data('startHour'));
			} else {
				$(handler).data('start', $('#index_calendarStart').val() + ' 00:00');
			}

		} else {
			$(handler).data('start', $('#index_calendarStart').val());
		}
		if ($('#index_calendarEnd').val() != '') {

			if ($(handler).data('endHour')) {
				$(handler).data('end', $('#index_calendarEnd').val() + $(handler).data('endHour'));
			} else {
				$(handler).data('end', $('#index_calendarEnd').val() + ' 00:00');
			}

		} else {
			$(handler).data('end', $('#index_calendarEnd').val());
		}

		var startParent = $('#index_calendarStart').parent();
		$('#index_calendarStart').remove();
		var newStartInput = $('<input class="Wdate" onclick="index_start()" type="text" id="index_calendarStart" style="margin-left:-4px;" />');
		newStartInput.val($(handler).data('start'));
		startParent.append(newStartInput);

		var endParent = $('#index_calendarEnd').parent();
		$('#index_calendarEnd').remove();
		var newEndInput = $('<input class="Wdate" onclick="index_end()" type="text" id="index_calendarEnd" style="margin-left:-4px;" />');
		newEndInput.val($(handler).data('end'));
		endParent.append(newEndInput);
	}
}

function index_startAllday() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd',
		minDate : '%y-%M-%d'
	});
}
function index_start() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd HH:mm',
		minDate : '%y-%M-%d {%H}:%m'
	})
}
function index_endAllday() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd',
		minDate : '#F{$dp.$D(\'index_calendarStart\',{d:1});}'
	})
}
function index_end() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd HH:mm',
		minDate : '#F{$dp.$D(\'index_calendarStart\',{H:1});}'
	})
}

//删除时间事件
function index_removeDay() {
	var txt=  "是否要删除该事件!!!";
	var option = {
		title: "删除提示",
		onOk: function(){
			alert($('#index_calendarId').val())
			//删除日历的事件
			$('#index_calendar').fullCalendar('removeEvents', $('#index_calendarId').val())
			//删除数据库的数据
			
			$.fancybox.close();
		},
		onCancel:function(){
			
		}
	}
	window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.warning,option);
	
}

//点击确定时
function index_submitClick() {
	if ($('#index_calendarTitle').val() == '' || $('#index_calendarStart').val() == '' || $('#index_calendarEnd').val() == '') {
		return;
	}
	var jsonDate = {};
	jsonDate.id = $('#index_calendarId').val();
	jsonDate.title = $('#index_calendarTitle').val();
	jsonDate.start = $('#index_calendarStart').val();
	jsonDate.end = $('#index_calendarEnd').val();
	jsonDate.allDay = $('#index_isAllDay').prop('checked');
	jsonDate.color = $('#index_calendarColor').val();
	console.log(jsonDate)

	$('#index_calendar').fullCalendar('refetchEvents'); //重新获取所有事件数据
	//保存到数据库

	$.fancybox.close();
}

//初始化颜色插件
function init_index_color(color) {
	var color;
	if (color) {
		color = color;
	} else {
		color = '#ECC';
	}
	$("#index_calendarColor").val(color);
	$("#index_calendarColor").spectrum({
		/*allowEmpty:true,*/
		color : color,
		showInput : true,
		containerClassName : "full-spectrum",
		showInitial : true,
		showPalette : true,
		showSelectionPalette : true,
		showAlpha : true,
		maxPaletteSize : 10,
		preferredFormat : "hex",
		localStorageKey : "spectrum.demo",
		move : function(color) {
			//updateBorders(color);
		},
		show : function() {},
		beforeShow : function() {},
		hide : function(color) {
			var hexColor = "transparent";
			if (color) {
				hexColor = color.toHexString();
			}
			$("#docs-content").css("border-color", hexColor);
			$(this).val(color);
		},

		palette : [
			[ "rgb(0, 0, 0)", "rgb(67, 67, 67)", "rgb(102, 102, 102)", /*"rgb(153, 153, 153)","rgb(183, 183, 183)",*/
				"rgb(204, 204, 204)", "rgb(217, 217, 217)", /*"rgb(239, 239, 239)", "rgb(243, 243, 243)",*/ "rgb(255, 255, 255)" ],
			[ "rgb(152, 0, 0)", "rgb(255, 0, 0)", "rgb(255, 153, 0)", "rgb(255, 255, 0)", "rgb(0, 255, 0)",
				"rgb(0, 255, 255)", "rgb(74, 134, 232)", "rgb(0, 0, 255)", "rgb(153, 0, 255)", "rgb(255, 0, 255)" ],
			[ "rgb(230, 184, 175)", "rgb(244, 204, 204)", "rgb(252, 229, 205)", "rgb(255, 242, 204)", "rgb(217, 234, 211)",
				"rgb(208, 224, 227)", "rgb(201, 218, 248)", "rgb(207, 226, 243)", "rgb(217, 210, 233)", "rgb(234, 209, 220)",
				"rgb(221, 126, 107)", "rgb(234, 153, 153)", "rgb(249, 203, 156)", "rgb(255, 229, 153)", "rgb(182, 215, 168)",
				"rgb(162, 196, 201)", "rgb(164, 194, 244)", "rgb(159, 197, 232)", "rgb(180, 167, 214)", "rgb(213, 166, 189)",
				"rgb(204, 65, 37)", "rgb(224, 102, 102)", "rgb(246, 178, 107)", "rgb(255, 217, 102)", "rgb(147, 196, 125)",
				"rgb(118, 165, 175)", "rgb(109, 158, 235)", "rgb(111, 168, 220)", "rgb(142, 124, 195)", "rgb(194, 123, 160)",
				"rgb(166, 28, 0)", "rgb(204, 0, 0)", "rgb(230, 145, 56)", "rgb(241, 194, 50)", "rgb(106, 168, 79)",
				"rgb(69, 129, 142)", "rgb(60, 120, 216)", "rgb(61, 133, 198)", "rgb(103, 78, 167)", "rgb(166, 77, 121)",
				/*"rgb(133, 32, 12)", "rgb(153, 0, 0)", "rgb(180, 95, 6)", "rgb(191, 144, 0)", "rgb(56, 118, 29)",
				"rgb(19, 79, 92)", "rgb(17, 85, 204)", "rgb(11, 83, 148)", "rgb(53, 28, 117)", "rgb(116, 27, 71)",*/
				"rgb(91, 15, 0)", "rgb(102, 0, 0)", "rgb(120, 63, 4)", "rgb(127, 96, 0)", "rgb(39, 78, 19)",
				"rgb(12, 52, 61)", "rgb(28, 69, 135)", "rgb(7, 55, 99)", "rgb(32, 18, 77)", "rgb(76, 17, 48)" ]
		]
	});
}