$(function(){
	//初始化分享列表
	init_shareDetail();
})

//初始化分享列表
function init_shareDetail(){
	var list_infos = [
		{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
		{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
		{id:'uuid3',fileName:'我的文件',fileImg:'disk_module3.png',lastTime:'2018-06-15 12:50',fileType:'folder_myFile',fileSize:'50KB'},
		{id:'uuid4',fileName:'我的共享',fileImg:'disk_module4.png',lastTime:'2018-06-13 15:10',fileType:'folder_myShare',fileSize:'5MB'},
		{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
		{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
		{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
		{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
		{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
		{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
		{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
	]
	
	init_shareDetail_list(list_infos);
}

//初始化文件的列表
function init_shareDetail_list(infos){
	for(var i=0;i<infos.length;i++){
		init_disk_select_fileImg(infos[i]);
	}
	
	$('#shareDetail_list').bootstrapTable('destroy').bootstrapTable({
       /* showColumns:true,
       showToggle:true,
       showRefresh:true,
       search:true, */
       /* url: "bootstrap-table/data/data1.json", // 获取表格数据的url */
       data:infos,
       cache: false, // 设置为 false 禁用 AJAX 数据缓存， 默认为true
       /* striped: true,  //表格显示条纹，默认为false */
       pagination: false, // 在表格底部显示分页组件，默认false
       pageList: [5,10,15,20], // 设置页面可以显示的数据条数
       pageSize: 10, // 页面数据条数
       pageNumber: 1, // 首页页码,
       uniqueId:'id',
       clickToSelect:true,//True to select checkbox or radiobox when the column is clicked.
       queryParams:function(params){
			  	var temp = {   //这里的键的名字和控制器的变量名必须一直，这边改动，控制器也需要改成一样的  
				   // limit: params.limit,   //页面大小  
				    offset: params.offset,  //页码  
				    pageSize:this.pageSize,  
				    pageNumber:this.pageNumber
				    /* projectId: $("#projectId").val(),  
				    requirement_Id:$("#requirement_Id").val(),  
				    length: 6  */ 
				};  
				return temp;
       },
       columns: [
           {
               checkbox: true, // 显示一个勾选框
               align: 'center', // 居中显示
               valign: 'middle'
           },{
               field: 'fileName',
               title: '文件名称',
               align: 'left',
               valign: 'middle',
               formatter: function (value, row, index) { 
            	   return '<img style="margin-right:10px;vertical-align:top;" src="'+ctx+'/custom/images/'+ row.fileImg +'" height="44" ><span style="margin-top:12px;display:inline-block;">'+value+'</span>';
               }
           }, {
               field: 'lastTime',
               title: '修改时间',
               align: 'center',
               valign: 'middle',
               order:'asc',
               sortable:'true'
           }, {
               field: 'fileType',
               title: '类型',
               align: 'center',
               valign: 'middle'
           },{
               field: 'fileSize',
               title: '大小',
               align: 'center',
               valign: 'middle'
           },{
               field: 'ck',
               title: '操作',
               align: 'center',
               valign: 'middle',
               formatter: function (value, row, index) {
            	   return '<span class="shareDetail_downLoad" onclick="$.jfbrother.stopPropagation();shareDetail_downLoad(\''+row.id+'\')">下载</span>';
             }
           }
       ],
       //当用户双击某一行的时候触发
       onDblClickRow:function(row, $element){
	      	 //根据id重新渲染列表    	   
	      	 shareDetail_list_dbClick(row);
       }
       //
 })
}

//双击列表时,根据id重新渲染列表    	   
function shareDetail_list_dbClick(row){
	console.log(row)
	
	//添加目录的导航效果
	var $search_center =  $('.shareDetail_container_mulu');
	//如果是第一次双击时
	if($search_center.find('span').length==0){
		//把全部文件隐藏起来
		$search_center.find('label').hide();
		//返回上一级
		var $prev_span = $('<span></span>').text('返回上一级');
		$prev_span.bind('click',function(){
			shareDetail_nav_click($search_center.find('.shareDetail_container_mulu_noClick').prev().prev());
		})
		//竖线
		var $shuxian_span = $('<span></span>').text('|').addClass('shareDetail_container_mulu_shuxian');
		//全部文件
		var $allFiles_span = $('<span></span>').text('全部文件');
		$allFiles_span.bind('click',function(){
			shareDetail_nav_click($(this));
		})
		$search_center.append($prev_span).append($shuxian_span).append($allFiles_span);
	}
	
	//改变最后添加之前最后一个的样式,并且绑定一个事件
	var $noClick_span = $search_center.find('.shareDetail_container_mulu_noClick').removeClass('shareDetail_container_mulu_noClick');
	$noClick_span.bind('click',function(){
		shareDetail_nav_click($(this));
	})
	
	//箭头
	var $jiantou_span = $('<span></span>').text('>').addClass('shareDetail_container_mulu_shuxian');
	//文件名
	var $file_span = $('<span></span>').text(row.fileName).addClass('shareDetail_container_mulu_noClick');
	//把文件的id存放起来
	$file_span.data('fileId',row.id);
	
	$search_center.append($jiantou_span).append($file_span);
	
	//重新渲染列表,模拟几条数据
	var infos = [
		{id:'uuid8',fileName:'我的文件1',fileImg:'disk_module5.png',lastTime:'2018-06-19 14:20',fileType:'folder',fileSize:'200KB'},
		{id:'uuid9',fileName:'我的文件2',fileImg:'disk_module5.png',lastTime:'2018-06-18 15:50',fileType:'folder',fileSize:'100KB'},
		{id:'uuid10',fileName:'我的文件3',fileImg:'disk_module5.png',lastTime:'2018-06-15 12:50',fileType:'folder',fileSize:'50KB'}
	]
	
	init_shareDetail_list(infos);
}

//点击文件时
function shareDetail_nav_click(handler){
	console.log($(handler).data('fileId'));
	var fileId = $(handler).data('fileId');
	//要显示的列表
	var result_list;
	//如果操作的是全部文件时
	if(!fileId){
		var $all_label = $('.shareDetail_container_mulu>label');  
		//显示全部文件
		$all_label.show();
		//去掉之后的所有导航
		$all_label.nextAll().remove();
		//模拟数据
		var result_list = [
			{id:'uuid1',fileName:'公司文件',fileImg:'disk_module1.png',lastTime:'2018-06-19 14:20',fileType:'folder_company',fileSize:'200KB'},
			{id:'uuid2',fileName:'共享文件',fileImg:'disk_module2.png',lastTime:'2018-06-18 15:50',fileType:'folder_share',fileSize:'100KB'},
			{id:'uuid3',fileName:'我的文件',fileImg:'disk_module3.png',lastTime:'2018-06-15 12:50',fileType:'folder_myFile',fileSize:'50KB'},
			{id:'uuid4',fileName:'我的共享',fileImg:'disk_module4.png',lastTime:'2018-06-13 15:10',fileType:'folder_myShare',fileSize:'5MB'},
			{id:'uuid5',fileName:'压缩文件夹',fileImg:'disk_rar.png',lastTime:'2018-06-18 12:10',fileType:'rar',fileSize:'1MB'},
			{id:'uuid6',fileName:'我的文档',fileImg:'disk_word.png',lastTime:'2018-06-19 8:10',fileType:'word',fileSize:'200KB'},
			{id:'uuid7',fileName:'我的EXCEL',fileImg:'disk_excel.png',lastTime:'2018-06-19 8:10',fileType:'excel',fileSize:'100KB'},
			{id:'uuid8',fileName:'我的PPT',fileImg:'disk_ppt.png',lastTime:'2018-06-17 8:10',fileType:'ppt',fileSize:'500KB'},
			{id:'uuid9',fileName:'我的PDF',fileImg:'disk_pdf.png',lastTime:'2018-06-19 23:10',fileType:'pdf',fileSize:'500KB'},
			{id:'uuid10',fileName:'超级狙击手.png',fileImg:'disk_uploadImg.png',lastTime:'2018-06-19 20:10',fileSize:'50KB',fileType:'png'},
			{id:'uuid11',fileName:'disk_unknow.bsl',fileImg:'disk_unknow.png',lastTime:'2018-06-19 22:10',fileType:'未知文件格式',fileSize:'30KB'}
		]
	}
	else{
		//去掉点击本身之后的所有导航
		$(handler).nextAll().remove();
		//并改变自身的样式
		$(handler).addClass('shareDetail_container_mulu_noClick');
		//解除自身的绑定事件
		$(handler).unbind();
		//模拟数据
		var result_list = [
			{id:'uuid8',fileName:'我的文件1',fileImg:'disk_module5.png',lastTime:'2018-06-19 14:20',fileType:'folder',fileSize:'200KB'},
			{id:'uuid9',fileName:'我的文件2',fileImg:'disk_module5.png',lastTime:'2018-06-18 15:50',fileType:'folder',fileSize:'100KB'},
			{id:'uuid10',fileName:'我的文件3',fileImg:'disk_module5.png',lastTime:'2018-06-15 12:50',fileType:'folder',fileSize:'50KB'}
		]
	}
	//重新渲染列表
	init_shareDetail_list(result_list);
}

//初始化文件的图片
function init_disk_select_fileImg(ztreeData){
	if(',jpg,png,jpeg,gif,'.indexOf(','+ ztreeData.fileType +',')==-1){
		//非图片类型需要判断显示的图片
		//iconOpen:文件夹树形结构打开图片
		//iconClose:文件夹树形结构关闭图片
		//icon:文件夹树形结构叶子图片
		//fileImg:桌面显示图片
		switch (ztreeData.fileType) {
		case 'folder_company':
			ztreeData.iconOpen='custom/images/disk_module1.png';
			ztreeData.iconClose='custom/images/disk_module1_close.png';
			ztreeData.icon='custom/images/disk_module1_close.png';
			ztreeData.fileImg='disk_module1_close.png';
			break;
		case 'folder_share':
			ztreeData.iconOpen='custom/images/disk_module2.png';
			ztreeData.iconClose='custom/images/disk_module2_close.png';
			ztreeData.icon='custom/images/disk_module2_close.png';
			ztreeData.fileImg='disk_module2_close.png';
			break;
		case 'folder_myFile':
			ztreeData.iconOpen='custom/images/disk_module3.png';
			ztreeData.iconClose='custom/images/disk_module3_close.png';
			ztreeData.icon='custom/images/disk_module3_close.png';
			ztreeData.fileImg='disk_module3_close.png';
			break;
		case 'folder_myShare':
			ztreeData.iconOpen='custom/images/disk_module4.png';
			ztreeData.iconClose='custom/images/disk_module4_close.png';
			ztreeData.icon='custom/images/disk_module4_close.png';
			ztreeData.fileImg='disk_module4_close.png';
			break;
		case 'folder':
			ztreeData.iconOpen='custom/images/disk_module5.png';
			ztreeData.iconClose='custom/images/disk_module5_close.png';
			ztreeData.icon='custom/images/disk_module5_close.png';
			ztreeData.fileImg='disk_module5_close.png';
			break;
		case 'rar':
			ztreeData.fileImg='disk_rar.png';
			break;
		case 'txt':
			ztreeData.fileImg='disk_unknow.png';
			break;
		case 'ppt':
			ztreeData.fileImg='disk_ppt.png';
			break;
		case 'pdf':
			ztreeData.fileImg=='disk_pdf.png';
			break;
		case 'excel':
			ztreeData.fileImg='disk_excel.png';
			break;
		case 'word':
			ztreeData.fileImg='disk_word.png';
			break;
		default:
			ztreeData.fileImg='disk_unknow.png';
			break;
		}
	}
}

//取消分享
function shareDetail_cancelShare(){
	var list_rows = $('#shareDetail_list').bootstrapTable('getSelections');
	if(list_rows.length==0){
		var txt3 =  "请选择要取消分享的文件!!!";
		var option3 = {
			title: "取消分享提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.confirm,option3);
	}
	else{
		var txt4 =  "是否要取消分享选中的文件!!!";
		var option4 = {
			title: "取消分享提示",
			onOk: function(){
				for(var i = 0; i<list_rows.length;i++){						
					//根据id来删除行
					$('#shareDetail_list').bootstrapTable('removeByUniqueId',list_rows[i].id);
					//然后做取消分享操作
				}
			}
		}
		window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.warning,option4);
	}
}

//下载
function shareDetail_downLoad(id){
	var list_rows;
	var txt4 =  "是否要下载选中的文件!!!";
	if(id){
		list_rows = $('#shareDetail_list').bootstrapTable('getRowByUniqueId',id);
		txt4="是否要下载该文件!!!";
	}
	else{
		list_rows = $('#shareDetail_list').bootstrapTable('getSelections');
	}
	
	if(list_rows.length==0){
		var txt3 =  "请选择要下载的文件!!!";
		var option3 = {
			title: "下载提示",
			btn:parseInt("0001",2)
		}
		window.wxc.xcConfirm(txt3, window.wxc.xcConfirm.typeEnum.confirm,option3);
	}
	else{
		/*var txt4 =  "是否要下载选中的文件!!!";*/
		var option4 = {
			title: "下载提示",
			onOk: function(){
				
				window.open('https://codeload.github.com/douban/douban-client/legacy.zip/master');
			}
		}
		window.wxc.xcConfirm(txt4, window.wxc.xcConfirm.typeEnum.warning,option4);
	}
}
