<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<jsp:include page="../header.jsp"></jsp:include>
<script type="text/javascript" src="${pageContext.request.contextPath}/jwapp/pages/portlet/js/jwAppPortletModule.js" charset="utf-8"></script>
<style>
.sp-preview{
	border:none;
}
</style>
<div id="index_calendar" class="index_changeSmall_calendar"></div>
<script type="text/javascript">
var ctx='${pageContext.request.contextPath}';
$(function(){
	init_index_fullCalendar();
});

//初始化日历插件
function init_index_fullCalendar() {
	$('#index_calendar').fullCalendar({
		header : {
			/*left : 'prev,next today prevYear,nextYear',*/
			left : 'prev,next today',
			center : 'title',
			right : 'month,agendaWeek,agendaDay'
		},
		/*defaultDate: '2018-03-12',*/
		navLinks : true, // can click day/week names to navigate views
		selectable : true,
		selectHelper : true,
		dayClick : function(date, allDay, jsEvent, view) {

			var start;
			var end;
			if (date._ambigTime == true) {
				start = moment(date, 'DD.MM.YYYY').format('YYYY-MM-DD');
				end = moment(date, 'DD.MM.YYYY').add(1, 'days').format('YYYY-MM-DD');
			} else {
				start = moment(date, 'mm.HH.DD.MM.YYYY').format('YYYY-MM-DD HH:mm');
				end = moment(date, 'mm.HH.DD.MM.YYYY').add(1, 'hour').format('YYYY-MM-DD HH:mm');
			}
			var strVar = index_fullCalendar_template('', '新增事件', '记录你将要做的一件事...', date._ambigTime, start, end);

			$.fancybox.open(strVar);
			init_index_color();

		//$('.index_calendar_header').text('111');
		},
		//编辑
		eventClick : function(calEvent, element, view) {
			
			//id
			var id = calEvent.id;
			//标题
			var title = calEvent.title;
			//是否全天
			var allDay = calEvent.allDay;
			//开始时间
			var start = calEvent.start._i;
			//结束时间
			var end = calEvent.end._i;
			//颜色
			var color = calEvent.color;

			var strVar = index_fullCalendar_template(id, '编辑事件', title, allDay, start, end);
			$.fancybox.open(strVar);
			init_index_color(color);

		},
		/*editable : true,*/
		/*eventLimit : true, // allow "more" link when too many events*/	
		/* events : ctx+'/date.json' */
	});
}

//模板  参数id,头标签,日程内容,开始时间,结束时间,是否是全天
function index_fullCalendar_template(id, header, title, allDay, start, end) {
	var strVar = "";
	strVar += "<div class=\"index_calendar\">\n";
	strVar += "	<input type=\"hidden\" value=\"@{id}\" id=\"index_calendarId\" />\n";
	strVar += "	<div class=\"index_calendar_header\">@{header}<\/div>\n";
	strVar += "    <div class=\"index_calendar_container\">\n";
	strVar += "	    <div class=\"index_calendar_text\">\n";
	strVar += "	    	<label for=\"index_calendarTitle\">日程内容：<\/label><input type=\"text\" id=\"index_calendarTitle\" value=\"@{title}\" />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_date\">\n";
	strVar += "	    	<label for=\"index_calendarStart\">开始时间：<\/label><input class=\"Wdate\" @{startTime} type=\"text\" id=\"index_calendarStart\" value=\"@{start}\"  />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_date\">\n";
	strVar += "	    	<label for=\"index_calendarEnd\">结束时间：<\/label><input class=\"Wdate\" @{endTime} type=\"text\" id=\"index_calendarEnd\" value=\"@{end}\" />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_date\">\n";
	strVar += "	    	<label for=\"index_calendarColor\">背景颜色：<\/label><input id=\"index_calendarColor\" />\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_selete\">\n";
	strVar += "	    	<label><input onClick=\"index_allDay(this)\" type=\"checkbox\" value=\"1\" id=\"index_isAllDay\" @{allDay}> 全天<\/label>\n";
	strVar += "	    <\/div>\n";
	strVar += "	    <div class=\"index_calendar_btn\">\n";
	strVar += "	    	<span @{deleteBtn} onClick=\"index_removeDay()\">删除<\/span>\n";
	strVar += "	    	<span onClick=\"$.fancybox.close()\">取消<\/span>\n";
	strVar += "	    	<span onClick=\"index_submitClick()\">确定<\/span>\n";
	strVar += "	    <\/div>\n";
	strVar += "    <\/div>\n";
	strVar += "<\/div>\n";

	var json={
		id:id,
		header:header,
		title:title,
		allDay:allDay,
		start:start,
		end:end
	};
	//删除按钮
	if (id == '') {
		json.deleteBtn = 'style="display:none;"';
	}
	//全天
	if (allDay == true) {
		json.allDay='checked';
		json.startTime='onClick="index_startAllday()"';
		json.endTime='onClick="index_endAllday()"';
	} else {
		json.startTime='onClick="index_start()"';
		json.endTime='onClick="index_end()"';
	}
	newStr=$.jfbrother.replaceByJson(strVar,json);
	return newStr;
}

//点击全天时
function index_allDay(handler) {
	if ($(handler).prop('checked') == true) {

		if ($('#index_calendarStart').val() != '') {
			$(handler).data('startHour', $('#index_calendarStart').val().substring($('#index_calendarStart').val().length - 6));
			$(handler).data('start', $('#index_calendarStart').val().substring(0, $('#index_calendarStart').val().length - 6));
		} else {
			$(handler).data('start', $('#index_calendarStart').val());
		}

		if ($('#index_calendarEnd').val() != '') {
			$(handler).data('endHour', $('#index_calendarEnd').val().substring($('#index_calendarEnd').val().length - 6));
			$(handler).data('end', $('#index_calendarEnd').val().substring(0, $('#index_calendarEnd').val().length - 6));
		} else {
			$(handler).data('end', $('#index_calendarEnd').val());
		}

		var startParent = $('#index_calendarStart').parent();
		$('#index_calendarStart').remove();
		var newStartInput = $('<input class="Wdate" onclick="index_startAllday()" type="text" id="index_calendarStart" style="margin-left:-4px;" />');
		newStartInput.val($(handler).data('start'));
		startParent.append(newStartInput);

		var endParent = $('#index_calendarEnd').parent();
		$('#index_calendarEnd').remove();
		var newEndInput = $('<input class="Wdate" onclick="index_endAllday()" type="text" id="index_calendarEnd" style="margin-left:-4px;" />');
		newEndInput.val($(handler).data('end'));
		endParent.append(newEndInput);

	} else {

		if ($('#index_calendarStart').val() != '') {
			if ($(handler).data('startHour')) {
				$(handler).data('start', $('#index_calendarStart').val() + $(handler).data('startHour'));
			} else {
				$(handler).data('start', $('#index_calendarStart').val() + ' 00:00');
			}

		} else {
			$(handler).data('start', $('#index_calendarStart').val());
		}
		if ($('#index_calendarEnd').val() != '') {

			if ($(handler).data('endHour')) {
				$(handler).data('end', $('#index_calendarEnd').val() + $(handler).data('endHour'));
			} else {
				$(handler).data('end', $('#index_calendarEnd').val() + ' 00:00');
			}

		} else {
			$(handler).data('end', $('#index_calendarEnd').val());
		}

		var startParent = $('#index_calendarStart').parent();
		$('#index_calendarStart').remove();
		var newStartInput = $('<input class="Wdate" onclick="index_start()" type="text" id="index_calendarStart" style="margin-left:-4px;" />');
		newStartInput.val($(handler).data('start'));
		startParent.append(newStartInput);

		var endParent = $('#index_calendarEnd').parent();
		$('#index_calendarEnd').remove();
		var newEndInput = $('<input class="Wdate" onclick="index_end()" type="text" id="index_calendarEnd" style="margin-left:-4px;" />');
		newEndInput.val($(handler).data('end'));
		endParent.append(newEndInput);
	}
}

function index_startAllday() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd',
		minDate : '%y-%M-%d'
	});
}
function index_start() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd HH:mm',
		minDate : '%y-%M-%d {%H}:%m'
	})
}
function index_endAllday() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd',
		minDate : '#F{$dp.$D(\'index_calendarStart\',{d:1});}'
	})
}
function index_end() {
	WdatePicker({
		dateFmt : 'yyyy-MM-dd HH:mm',
		minDate : '#F{$dp.$D(\'index_calendarStart\',{H:1});}'
	})
}

//删除时间事件
function index_removeDay() {
	var txt=  "是否要删除该事件!!!";
	var option = {
		title: "删除提示",
		onOk: function(){
			alert($('#index_calendarId').val())
			//删除日历的事件
			$('#index_calendar').fullCalendar('removeEvents', $('#index_calendarId').val())
			//删除数据库的数据
			
			$.fancybox.close();
		},
		onCancel:function(){
			
		}
	}
	window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.warning,option);
	
}

//点击确定时
function index_submitClick() {
	if ($('#index_calendarTitle').val() == '' || $('#index_calendarStart').val() == '' || $('#index_calendarEnd').val() == '') {
		return;
	}
	var jsonDate = {};
	jsonDate.id = $('#index_calendarId').val();
	jsonDate.title = $('#index_calendarTitle').val();
	jsonDate.start = $('#index_calendarStart').val();
	jsonDate.end = $('#index_calendarEnd').val();
	jsonDate.allDay = $('#index_isAllDay').prop('checked');
	jsonDate.color = $('#index_calendarColor').val();
	console.log(jsonDate)

	$('#index_calendar').fullCalendar('refetchEvents'); //重新获取所有事件数据
	//保存到数据库

	$.fancybox.close();
}

//初始化颜色插件
function init_index_color(color) {
	var color;
	if (color) {
		color = color;
	} else {
		color = '#ECC';
	}
	$("#index_calendarColor").val(color);
	$("#index_calendarColor").spectrum({
		/*allowEmpty:true,*/
		color : color,
		showInput : true,
		containerClassName : "full-spectrum",
		showInitial : true,
		showPalette : true,
		showSelectionPalette : true,
		showAlpha : true,
		maxPaletteSize : 10,
		preferredFormat : "hex",
		localStorageKey : "spectrum.demo",
		move : function(color) {
			//updateBorders(color);
		},
		show : function() {},
		beforeShow : function() {},
		hide : function(color) {
			var hexColor = "transparent";
			if (color) {
				hexColor = color.toHexString();
			}
			$("#docs-content").css("border-color", hexColor);
			$(this).val(color);
		},

		palette : [
			[ "rgb(0, 0, 0)", "rgb(67, 67, 67)", "rgb(102, 102, 102)", /*"rgb(153, 153, 153)","rgb(183, 183, 183)",*/
				"rgb(204, 204, 204)", "rgb(217, 217, 217)", /*"rgb(239, 239, 239)", "rgb(243, 243, 243)",*/ "rgb(255, 255, 255)" ],
			[ "rgb(152, 0, 0)", "rgb(255, 0, 0)", "rgb(255, 153, 0)", "rgb(255, 255, 0)", "rgb(0, 255, 0)",
				"rgb(0, 255, 255)", "rgb(74, 134, 232)", "rgb(0, 0, 255)", "rgb(153, 0, 255)", "rgb(255, 0, 255)" ],
			[ "rgb(230, 184, 175)", "rgb(244, 204, 204)", "rgb(252, 229, 205)", "rgb(255, 242, 204)", "rgb(217, 234, 211)",
				"rgb(208, 224, 227)", "rgb(201, 218, 248)", "rgb(207, 226, 243)", "rgb(217, 210, 233)", "rgb(234, 209, 220)",
				"rgb(221, 126, 107)", "rgb(234, 153, 153)", "rgb(249, 203, 156)", "rgb(255, 229, 153)", "rgb(182, 215, 168)",
				"rgb(162, 196, 201)", "rgb(164, 194, 244)", "rgb(159, 197, 232)", "rgb(180, 167, 214)", "rgb(213, 166, 189)",
				"rgb(204, 65, 37)", "rgb(224, 102, 102)", "rgb(246, 178, 107)", "rgb(255, 217, 102)", "rgb(147, 196, 125)",
				"rgb(118, 165, 175)", "rgb(109, 158, 235)", "rgb(111, 168, 220)", "rgb(142, 124, 195)", "rgb(194, 123, 160)",
				"rgb(166, 28, 0)", "rgb(204, 0, 0)", "rgb(230, 145, 56)", "rgb(241, 194, 50)", "rgb(106, 168, 79)",
				"rgb(69, 129, 142)", "rgb(60, 120, 216)", "rgb(61, 133, 198)", "rgb(103, 78, 167)", "rgb(166, 77, 121)",
				/*"rgb(133, 32, 12)", "rgb(153, 0, 0)", "rgb(180, 95, 6)", "rgb(191, 144, 0)", "rgb(56, 118, 29)",
				"rgb(19, 79, 92)", "rgb(17, 85, 204)", "rgb(11, 83, 148)", "rgb(53, 28, 117)", "rgb(116, 27, 71)",*/
				"rgb(91, 15, 0)", "rgb(102, 0, 0)", "rgb(120, 63, 4)", "rgb(127, 96, 0)", "rgb(39, 78, 19)",
				"rgb(12, 52, 61)", "rgb(28, 69, 135)", "rgb(7, 55, 99)", "rgb(32, 18, 77)", "rgb(76, 17, 48)" ]
		]
	});
}
</script>