;
(function($) {
	// 记录列表
	$.fn.checklist = function() {
		return $.checklist(this);
	}
	$.checklist = function(Obj) {
		var _this = Obj ? Obj : $({});
		var tempArray = _this.data("list");
		if (!tempArray) {
			tempArray = [];
			_this.data("list", tempArray);
		}
		var oc = {
			getList : function() {
				return this.data("list");
			},
			cleanList : function() {
				this.data("list", [])
			},
			checkList : function(checkedObj, op) {
				var a = this.data("list");
				var index = $.inArray(checkedObj, a);
				if (op) {
					a.push(checkedObj);
				} else {
					a.splice(index, 1);
				}
				$.unique(a);
			},
			testList : function(checkedObj) {
				var a = _this.data("list");
				var index = $.inArray(checkedObj, a);
				return (index == -1) ? false : true;
			}
		}
		$.extend(Obj, oc);
		return Obj;
	}
	// 校验
	$.fn.checker = function() {
		return $.checker(this);
	}
	$.checker = function(Obj) {
		var oc = {
			act : function(eventType) {
				var _this = this;
				for (var i = 0; i < arguments.length; i++) {
					this.bind(arguments[i], function() {
								_this.exc()
							});
				}
				return _this;
			},
			reg : function() {
				var queue = (this.data("checkqueue") && this.data("checkqueue").constructor == Array)
						? this.data("checkqueue")
						: [];
				for (var i = 0; i < arguments.length; i++) {
					queue.push(arguments[i]);
				}
				this.data("checkqueue", queue);
				return this;
			},
			exc : function() {
				var queue = this.data("checkqueue");
				for (var i = 0; queue && i < queue.length; i++) {
					if (!(queue[i].call(this))) {
						return false;
					}
				}
				return true;
			}
		};
		$.extend(Obj ? Obj : $({}), oc);
		return Obj;
	}
	// 在元素附近写一些信息
	$.fn.checkwrite = function(msg) {
		$.checkwrite(this, msg);
	}
	$.checkwrite = function(obj, msg) {
		try {
			var jobj = $(obj), top = jobj.position().top, left = jobj
					.position().left, width = jobj.outerWidth(), height = jobj
					.outerHeight(), newleft = left, newtop = top + height;
			// alert("top:"+top+"left:"+left+"width:"+width+"height:"+height+"newleft:"+newleft+"newtop:"+newtop);
			if (msg) {
				if (jobj.next().is("p[name='msgbox']")) {
					jobj.next().html(msg);
				} else {
					jobj
							.after($("<p name='msgbox' style='clear:both;*clear:none;' />")
									.css("position", "absolute").css("z-index", "90").css("width",
											"auto").css("text-align", "left")
									.css("border", "2px outset white").css(
											"background-color", "#FFFFCC").css(
											"color", "red").css("top", newtop)
									.css("left", newleft).html(msg));
				}
			} else {
				jobj.next("p[name='msgbox']").remove();
			}
		} catch (err) {
			// s += err.message
		}

	}
	// json对象比较
	$.compareJsonObj = function(o1, o2) {
		if (typeof arguments[0] != typeof arguments[1])
			return false;
		if (arguments[0] instanceof Array) {
			if (arguments[0].length != arguments[1].length)
				return false;
			var allElementsEqual = true;
			for (var i = 0; i < arguments[0].length; ++i) {
				if (typeof arguments[0][i] != typeof arguments[1][i])
					return false;
				if (typeof arguments[0][i] == 'number'
						&& typeof arguments[1][i] == 'number')
					allElementsEqual = (arguments[0][i] == arguments[1][i]);
				else
					allElementsEqual = arguments.callee(arguments[0][i],
							arguments[1][i]); // 递归判断对象是否相等
			}
			return allElementsEqual;
		}
		if (arguments[0] instanceof Object && arguments[1] instanceof Object) {
			var result = true;
			var attributeLengthA = 0, attributeLengthB = 0;
			for (var o in arguments[0]) {
				// 判断两个对象的同名属性是否相同（数字或字符串）
				if (typeof arguments[0][o] == 'number'
						|| typeof arguments[0][o] == 'string')
					result = eval("arguments[0]['" + o + "'] == arguments[1]['"
							+ o + "']");
				else {
					// 如果对象的属性也是对象，则递归判断两个对象的同名属性
					// if (!arguments.callee(arguments[0][o], arguments[1][o]))
					if (!arguments.callee(eval("arguments[0]['" + o + "']"),
							eval("arguments[1]['" + o + "']"))) {
						result = false;
						return result;
					}
				}
				++attributeLengthA;
			}
			for (var o in arguments[1]) {
				++attributeLengthB;
			}
			// 如果两个对象的属性数目不等，则两个对象也不等
			if (attributeLengthA != attributeLengthB)
				result = false;
			return result;
		}
		return arguments[0] == arguments[1];
	}
})(jQuery);

function Map() {
	this.javaClass = "java.util.HashMap";
	this.map = {};
	this.add = function(key, value) {
		this.map[key] = value;
	}
}
function List() {
	this.javaClass = "java.util.ArrayList";
	this.list = [];
	this.add = function(obj) {
		this.list.push(obj);
	}
}
