/** 
 * 自定义全局通用函数 
 *  
 * @author  
 */  
(function($) {  
    $.sendGet = function(url, data, callback, errCallback, type){  
        return $.send(url, data, callback, errCallback, type, 'GET');  
    }  
  
    $.sendPost = function(url, data, callback, errCallback, type){
        return  $.send(url, data, callback, errCallback, type, 'POST');
    } 
    
    $.sendPostTb = function(url, data, callback, errCallback, type){
        return  $.send(url, data, callback, errCallback, type, 'POST',false);
    }
  
    $.sendPut = function(url, data, callback, errCallback, type){  
        data._method='PUT';  
        return $.send(url, data, callback, errCallback, type, 'POST');  
    }  
  
    $.sendDelete = function(url, data, callback, errCallback, type){  
        data._method='DELETE';  
        return $.send(url, data, callback, errCallback, type, 'POST');  
    }  
      
    $.send = function(url, data, callback, errCallback, dtype, stype,async){  
        if ( jQuery.isFunction(data) ) {  
            if( !jQuery.isFunction( callback ) ){  
                dtype = callback;  
                errCallback = data;//没有定义错误处理方法时，采用成功的处理方式  
            }else{  
                dtype = errCallback;  
                errCallback = callback;  
            }  
            callback = data;  
            data = {};  
        }else if( !jQuery.isFunction( errCallback ) ) {  
            dtype = errCallback;  
            errCallback = callback;//没有定义错误处理方法时，采用成功的处理方式  
        }  
          
        if(stype==null){  
            stype = "GET";  
        }  
        
        if(async==null){  
        	async = true;  
        }
  
        //访问成功后回调  
        var cmpCallback = function( res, status ) {  
            var data = jQuery.parseJSON(res.responseText);  
            var code = 200;  
            try{  
                code = data.bq_status;  
            }catch(e){}  
  
        }  
          
        return jQuery.ajax({  
            type: stype,  
            url : url,  
            data: data, 
            async: async,
            success : function( data, status, xhr ){  
                var type = "success";  
                try{  
                    type = data.bq_type;  
                }catch(e){}  
                if(type=="error"){  
                    errCallback.call(this, data, status, xhr);  
                }else{  
                    callback.call(this, data, status, xhr);  
                }  
            },  
            error   : errCallback,  
            complete: cmpCallback,  
            dataType: dtype  
        });  
    }  
      
})(jQuery);

BusinessObject = function() {
	return {
		delegate : function(type) {
			for (var p in this) {
				if (typeof(this[p]) == "function") {
					if (p != 'delegate') {
						this[p] = function() {
							var mn = p;
							return function() {
							   if(type=="" || type==null) return "-1";
							   this.action = type;
							   var param = arguments[0];
							   var struts2MethodURL=this.action + "_" + mn;
							   if(this.module!="" && this.module.length>0 && this.module != null){
								   struts2MethodURL = this.module + "/" + struts2MethodURL;
							   }
							   function load_val(callback){
								 $.sendPostTb(
									  struts2MethodURL, 
									  param, 
									  function(data){
										 callback(data);  
								      },
									  null,
									  "json"
								  );
							   }
							   var jsonDATA = {};
							   load_val(function(data){
								   jsonDATA = data; 
							   });
							   return jsonDATA;
							};
						}();
					}
				}
			}
		 return this;
		}
	};
}();

var tempJsonData = {};

function getTempJsonData(){
	return tempJsonData;
}
function setTempJsonData(data){
	tempJsonData = data;
}


function renderDATA(data,row,rowsid){
    $.each(data, function(i,n){
     var jsonObj = eval(n);
     for(var property in jsonObj)
     {
      row.find("#"+property).text(jsonObj[property]);
     }
     row.appendTo("#"+rowsid);//添加到模板的容器中
     row = row.clone();
   });
  }

function renderDATAFORM(data,row){
    $.each(data, function(i,n){
    	row.find("#"+i).val(n);
    });
  }

function renderDATAROW(data,row){
    $.each(data, function(i,n){
    	row.find("#"+i).text(n);
    });
  }

function getSearchData(data,rowName){
	var arr_data = [];
    $.each(data, function(i,n){
    	var jsonObj = eval(n);
    	arr_data[i] = jsonObj[rowName];
    });
    return arr_data;
  }

//------------自动加载修正----------------------------------
function renderSPAN(data,row,rowsid){
    $.each(data, function(i,n){
     var jsonObj = eval(n);
     row.find("span").each(function(){
    	if($(this).attr("id")+''!='undefined'){
    		var tid = $(this).attr("id");
    		if(jsonObj[tid]+''=='undefined'){
    			$(this).text('');
    		}else{
    			$(this).text(jsonObj[tid]);
    		}
    		
    	}
     });
     row.appendTo("#"+rowsid);//添加到模板的容器中
     row = row.clone();
   });
  }

function loadCSS(css,target){
	
	
	var eHead = document.getElementById(target);
	var eLink = document.createElement("link");
	eLink.rel = "stylesheet";
	eLink.type = "text/css";
	eLink.href = css;

	eHead.appendChild(eLink);
}

function loadJS(js,callback){
	$.getScript(js,callback);
}


/**
 * 单条json转string
 * @param o
 * @returns {String}
 */
function json2str(o) { 
  var arr = []; 
  var fmt = function(s) { 
  if (typeof s == 'object' && s != null) return json2str(s); 
      return /^(string|number)$/.test(typeof s) ? "'" + s + "'" : s; 
  } 
  for (var i in o) arr.push("'" + i + "':" + fmt(o[i])); 
  return '{' + arr.join(',') + '}'; 
 }

/**
 * json数组转string
 * @param jsonArray
 * @returns {String}
 */
function JsonArrayToString(jsonArray){ 
    var JsonArrayString = "["; 
    for(var i=0;i<jsonArray.length;i++){ 
      JsonArrayString=JsonArrayString+json2str(jsonArray[i])+","; 
    } 
    JsonArrayString = JsonArrayString.substring(0,JsonArrayString.length-1)+"]"; 
    return JsonArrayString; 
}

/**
 * 获取表单数据
 * @param formid
 * @returns {String}
 */
function getFormData(formid){//serializeArray=json,serialize=string
	var jsonArray = $('#'+formid).serializeArray();
    var JsonArrayString = "{"; 
    for(var i=0;i<jsonArray.length;i++){ 
      JsonArrayString=JsonArrayString + "'" + jsonArray[i]["name"]+ "'" + ":"+ "'" + jsonArray[i]["value"]+"',"; 
    } 
    JsonArrayString = JsonArrayString.substring(0,JsonArrayString.length-1)+"}"; 
    return eval("(" + JsonArrayString + ")"); 
}

/**
 * 获取checkbox选中值
 */
 function getCheckBoxValue(checkboxname){
	 var str="";
     $("input[name='"+checkboxname+"']:checkbox").each(function(){ 
        if($(this).attr("checked")){
           str += $(this).val()+",";
        }
     });
     if(str.length>1){
    	 str = str.substring(0, str.length - 1);
     }
     return str;
 }


//修改名称显示
function changeNameDisplay(str,length){
    var l = str.length;
    if(l<length){
        return str;
    }else{
        return str.substring(0,length)+"...";
    }
}

(function($){
	$.getUrlParam = function(name){
	var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
	var r = window.location.search.substr(1).match(reg);
	if (r!=null) return unescape(r[2]); return null;
	};
}(jQuery));


