<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<c:set var="ctx" value="${pageContext.request.contextPath}" />
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>PortletApi</title>
<script type="text/javascript" src="${ctx}/lib/js/jquery-1.8.2.min.js"></script>
<script type="text/javascript" src="${ctx}/jwapp/common/js/lang_json.js"></script>
<script type="text/javascript" src="${ctx}/jwapp/pages/portlet/js/jwAppPortletModule.js"></script>
<style>
pre {
	outline: 1px solid #ccc;
	padding: 5px;
	margin: 5px;
}

.string {
	color: green;
}

.number {
	color: darkorange;
}

.boolean {
	color: blue;
}

.null {
	color: magenta;
}

.key {
	color: red;
}

table {
	width: 100%;
}

table tr td .pre {
	width: 100%;
	height: 200px;
	overflow: auto;
}

.look {
	cursor: pointer;
	color: blue;
}
</style>
</head>

<body>
	<input type="button" value="清空" onclick="clearPre();" />
	<table id="tbl_001">
		<tr>
			<td>编号</td>
			<td>001</td>
		</tr>
		<tr>
			<td>描述</td>
			<td>获取当前登陆人的资源列表</td>
		</tr>
		<tr>
			<td>调用</td>
			<td><pre>var result = jwAppPortletModel.jwAppsPortletDataAction.listAllPTemplateByUser({
    FIELD_COLUMN_ID: 'd6926714-c220-4a7e-9ec0-3a23caebb179'
})</pre></td>
		</tr>
		<tr>
			<td>参数备注</td>
			<td>FIELD_COLUMN_ID:栏目id</td>
		</tr>
		<tr>
			<td><span class="look">结果查看</span></td>
			<td><pre class="pre"></pre></td>
		</tr>
	</table>

	<table id="tbl_002">
		<tr>
			<td>编号</td>
			<td>002</td>
		</tr>
		<tr>
			<td>描述</td>
			<td>获取所有的门户栏目</td>
		</tr>
		<tr>
			<td>调用</td>
			<td><pre>var result = jwAppPortletModel.jwAppsPortletDataAction.listAllPortletColumns()</pre></td>
		</tr>
		<tr>
			<td>参数备注</td>
			<td></td>
		</tr>
		<tr>
			<td><span class="look">结果查看</span></td>
			<td><pre class="pre"></pre></td>
		</tr>
	</table>

	<table id="tbl_003">
		<tr>
			<td>编号</td>
			<td>003</td>
		</tr>
		<tr>
			<td>描述</td>
			<td>获取所有的资源列表</td>
		</tr>
		<tr>
			<td>调用</td>
			<td><pre>var result = jwAppPortletModel.jwAppsPortletDataAction.listAllPTemplate({
    FIELD_COLUMN_ID: 'd6926714-c220-4a7e-9ec0-3a23caebb179'
})</pre></td>
		</tr>
		<tr>
			<td>参数备注</td>
			<td>FIELD_COLUMN_ID:栏目id</td>
		</tr>
		<tr>
			<td><span class="look">结果查看</span></td>
			<td><pre class="pre"></pre></td>
		</tr>
	</table>
	
	<table id="tbl_004">
		<tr>
			<td>编号</td>
			<td>004</td>
		</tr>
		<tr>
			<td>描述</td>
			<td>保存用户的资源列表</td>
		</tr>
		<tr>
			<td>调用</td>
			<td><pre>var layout = {
    columnsId: 'd6926714-c220-4a7e-9ec0-3a23caebb179',
    portlets: [{
        "PORTLET_ID": "a9a27fe8-8215-44a1-8e65-f93c74962240"
    },
    {
        "PORTLET_ID": "8538986b-f177-4f70-a525-59f78d557c6b"
    }]
};
layout = JSON.stringify(layout);
var result = jwAppPortletModel.jwAppsPortletActAction.saveLayout({
    layout: layout
});</pre></td>
		</tr>
		<tr>
			<td>参数备注</td>
			<td>1.columnsId:栏目id；2.portlets：portlets的id数组</td>
		</tr>
		<tr>
			<td><span class="look">结果查看</span></td>
			<td><pre class="pre"></pre></td>
		</tr>
	</table>
</body>
<script type="text/javascript">
	$(function() {
		$("table").each(function() {
			var $table = $(this);
			var tr4 = $(this).find('tr').eq(4);
			tr4.find('td').eq(0).find('span').click(function() {
				var click = $table.find('tr').eq(2).find('td').eq(1).find('pre').text();
				eval(click);
				tr4.find('td').eq(1).find('pre').html(syntaxHighlight(result));
			});
		});
	});

	function clearPre() {
		$("pre").html('');
	}

	function syntaxHighlight(json) {
		if (typeof json != 'string') {
			json = JSON.stringify(json, undefined, 2);
		}
		json = json.replace(/&/g, '&').replace(/</g, '<').replace(/>/g, '>');
		return json.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g, function(match) {
			var cls = 'number';
			if (/^"/.test(match)) {
				if (/:$/.test(match)) {
					cls = 'key';
				} else {
					cls = 'string';
				}
			} else if (/true|false/.test(match)) {
				cls = 'boolean';
			} else if (/null/.test(match)) {
				cls = 'null';
			}
			return '<span class="' + cls + '">' + match + '</span>';
		});
	}
</script>
</html>
