package com.jw.app.apps.action;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.gaowj.business.util.SessionUtil;
import com.jw.app.business.AppsBusiness;
import com.jw.app.business.utils.QueryParamUtil;

import net.sf.json.JSONObject;

public class dataAction extends BasicAction{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4630126275397330597L;
	private JSONObject jsonObject = new JSONObject();
	private int rows = 20;// 每页显示的记录数
    private int page = 1;// 当前第几页

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}

	public int getRows() {
		rows = getPageSize();
		return rows;
	}

	public void setRows(int rows) {
		setPageSize(rows);
		this.rows = getPageSize();
	}

	public int getPage() {
		page = getPageNo();
		return page;
	}

	public void setPage(int page) {
		setPageNo(page);
		this.page = getPageNo();
	}
	
	public String list_allApps_by_user() throws BusinessException{
		jsonObject=new JSONObject();
		//1.根据用户id,获取
		AppsBusiness business = BusinessManager
				.getBusiness(AppsBusiness.class);
		Map<String, Object> query = RequestUtils.getUpdateFieldMap(request,
				RequestUtils.UPDATEDATAFIELDPREFIX);
		try {
			query = QueryParamUtil.StringToDate(query);
			//设置当前登陆人
			List<Map<String, Object>> listData = business
					.list_allApps_by_user(query);
			//flag=true表示未安装
			Boolean flag = true;
			
			//查找所有的app类型
			Map<String, Object> queryCategory = RequestUtils.getUpdateFieldMap(request,
					RequestUtils.UPDATEDATAFIELDPREFIX);
			List<Map<String, Object>> listCategory = business
					.list_allCategory(queryCategory);
			private_putMapByKey("types",listCategory);
			 
			for (Map<String, Object> rm : listData) {
				if(rm.get("USERID")!=null){
					private_putMapByKey("apps",listData);
					flag=false;
					/*System.out.println("正常");*/
					break;
				}
			}
			//2上述结果中的USERID全部为null,表示一个app都没安装
			if(flag==true){
				//3.根据用户id来验证apps_uninstall有没有数据
				List<Map<String, Object>> listUninstallData = business
						.list_allUninstallApps_by_user(query);
				if(listUninstallData.size()!=0){
					//要把所有的应用都返回出去
					Map<String, Object> queryApp = RequestUtils.getUpdateFieldMap(request,
							RequestUtils.UPDATEDATAFIELDPREFIX);
					List<Map<String, Object>> listAllApps = business
							.list_AllApps(queryApp);
					/*System.out.println("未安装表里有");*/
					private_putMapByKey("apps",listAllApps);
				}
				else{
					//4.如果也没有,表示这个用户是新建用户,需要初始化应用
					//5.初始化应用
					//6.把默认的app应用添加到install表中
					//7.把不默认的app应用添加到uninstall表中
					Map<String, Object> queryDefaultApp = RequestUtils.getUpdateFieldMap(request,
							RequestUtils.UPDATEDATAFIELDPREFIX);
					business.init_defaultApps(queryDefaultApp);
					//8.重新查询关联表获得数据
					List<Map<String, Object>> defaultData = business
							.list_allApps_by_user(query);
					/*System.out.println("默认");*/
					private_putMapByKey("apps",defaultData);
				}
				
			}
			
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return "json";
	}

	private void private_putMapByKey(String key,List<Map<String, Object>> list) throws SQLException {
		Map<String, Object> listMap = new HashMap<String, Object>();
		listMap.put("rowSet", QueryParamUtil.DateToString(list));
		listMap.put("pageNo", 1);
		listMap.put("pageSize", list.size());
		listMap.put("pageCount", list.size());
		listMap.put("rows", listMap.get("rowSet"));
		listMap.put("total", list.size());
		jsonObject.put(key,listMap);
	}

}
