package com.jw.app.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;

@Service
public interface AppsBusiness {
	
	/**获取该用户的所有应用
	 * 
	 * @param query
	 * @return
	 * @throws BusinessException
	 */
	List<Map<String,Object>> list_allApps_by_user(Map<String, Object> query) throws BusinessException ;

	/**获得所有应用的所属类型
	 * 
	 * @param query
	 * @return
	 */
	List<Map<String, Object>> list_allCategory(Map<String, Object> query) throws BusinessException ;
	
	/**卸载应用
	 * 
	 * @param query
	 */
	void insert_unInstallApp(Map<String, Object> query) throws BusinessException ;
	
	/**安装应用
	 * 
	 * @param query
	 */
	void insert_installApp(Map<String, Object> query) throws BusinessException ;

	/**根据用户id来查找apps_uninstall的数据
	 * 
	 * @param query
	 * @return
	 */
	List<Map<String, Object>> list_allUninstallApps_by_user(Map<String, Object> query) throws BusinessException ;

	/**查找所有的app应用
	 * 
	 * @param queryApp
	 * @return
	 */
	List<Map<String, Object>> list_AllApps(Map<String, Object> query) throws BusinessException ;
	
	/**把默认的app应用添加到install表中并把不默认的app应用添加到uninstall表中
	 * 
	 * @param queryDefaultApp
	 */
	void init_defaultApps(Map<String, Object> query) throws BusinessException ;
}
