package com.jw.app.portlet.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.gaowj.business.action.BasicAction;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.RequestUtils;
import com.jw.app.business.PortletBusiness;
import com.jw.app.business.utils.Status;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;

public class actAction extends BasicAction {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8065624929370521607L;
	
	private JSONObject jsonObject = new JSONObject();

	public JSONObject getJsonObject() {
		return jsonObject;
	}

	public void setJsonObject(JSONObject jsonObject) {
		this.jsonObject = jsonObject;
	}
	
	public String saveLayout() throws BusinessException{
		String layout=RequestUtils.getString(request, "layout");
		//layout="{columnsId:'d6926714-c220-4a7e-9ec0-3a23caebb179',portlets:[{\"PORTLET_ID\":\"a9a27fe8-8215-44a1-8e65-f93c74962240\"},{\"PORTLET_ID\":\"8538986b-f177-4f70-a525-59f78d557c6b\"}]}";
		JSONObject json=JSONObject.fromObject(layout);
		//获取栏目id
		String columnsId=json.get("columnsId").toString();
		//解析protlets
		JSONArray array=JSONArray.fromObject(json.get("portlets"));
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		for(Iterator iter = array.iterator(); iter.hasNext();){  
            JSONObject jsonObject = (JSONObject)iter.next();  
            list.add((Map<String, Object>) JSONObject.toBean(jsonObject, Map.class));  
        }
		
		PortletBusiness business = BusinessManager.getBusiness(PortletBusiness.class);
		business.saveLayout(columnsId, list);
		jsonObject.putAll(Status.getStatus(Status.UPDATE_OK));
		return "json";
	}

}
