package com.gaowj.business.standard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.RowBounds;

import com.gaowj.business.StandardBusiness;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.QueryParamUtil;
import com.gaowj.standard.utils.CacheKit;

public class StandardBusinessImpl implements StandardBusiness {
	
	private StandardDAO standardDAO;
	
	public StandardDAO getStandardDAO() {
		return standardDAO;
	}

	public void setStandardDAO(StandardDAO standardDAO) {
		this.standardDAO = standardDAO;
	}
	
	private String prefix = "ST";

	@Override
    public Page<Map<String, Object>> list_all_tables(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException {

        // 计算起始记录
        int pageStart = (pageNo - 1) * pageSize;

        // 获取列表
        List<Map<String, Object>> items = standardDAO.list_all_tables(new RowBounds(pageStart, pageSize),query);
        // 获取列表个数
        int count = standardDAO.list_all_tables_count(query);

        // 创建分页对象
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);

        return page;
    }
	
	@Override
    public List<Map<String, Object>> list_all_tables(Map<String, Object> query)throws BusinessException {
        // 获取列表
        List<Map<String, Object>> list  = standardDAO.list_all_tables(query);
        return list;
    }

    @Override
    public int list_all_tables_count(Map<String, Object> query) throws BusinessException{

        return standardDAO.list_all_tables_count(query);

    }
    
    @Override
    public Page<Map<String, Object>> list_all_columns(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException {

        // 计算起始记录
        int pageStart = (pageNo - 1) * pageSize;

        // 获取列表
        List<Map<String, Object>> items = standardDAO.list_all_columns(new RowBounds(pageStart, pageSize),query);
        // 获取列表个数
        int count = standardDAO.list_all_columns_count(query);

        // 创建分页对象
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);

        return page;
    }
	
	@Override
    public List<Map<String, Object>> list_all_columns(Map<String, Object> query)throws BusinessException {
        // 获取列表
        List<Map<String, Object>> list  = standardDAO.list_all_columns(query);
        return list;
    }

    @Override
    public int list_all_columns_count(Map<String, Object> query) throws BusinessException{

        return standardDAO.list_all_columns_count(query);

    }
    
    @Override
    public Page<Map<String, Object>> list_tables_info(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException {

        // 计算起始记录
        int pageStart = (pageNo - 1) * pageSize;

        // 获取列表
        List<Map<String, Object>> items = standardDAO.list_tables_info(new RowBounds(pageStart, pageSize),query);
        // 获取列表个数
        int count = standardDAO.list_tables_info_count(query);

        // 创建分页对象
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);

        return page;
    }
	
	@Override
    public List<Map<String, Object>> list_tables_info(Map<String, Object> query)throws BusinessException {
        // 获取列表
        List<Map<String, Object>> list  = standardDAO.list_tables_info(query);
        return list;
    }

    @Override
    public int list_tables_info_count(Map<String, Object> query) throws BusinessException{

        return standardDAO.list_tables_info_count(query);

    }

    @Override
    public void delete_tables_info(Map<String, Object> entity) throws BusinessException{

    	standardDAO.delete_tables_info(entity);

    }

    public void insert_tables_info(Map<String, Object> entity) throws BusinessException{

        @SuppressWarnings("unchecked")
        List<Map<String, Object>> list = (List<Map<String, Object>>) entity.get("insertInfoList");
        entity.remove("insertInfoList");
        for (Map<String, Object> map : list) {
            if (map.keySet() != null) {
                Set<String> key = map.keySet();
                for (Iterator<String> it = key.iterator(); it.hasNext();) {
                    String s = it.next();
                    if (map.get(s) == null) {
                        map.put(s, "");
                    }
                }
            }
        }
        List<String> infoListKey = new ArrayList<String>();
        List<Object> infoList = new ArrayList<Object>();
        Set<String> key = null;
        for (Map<String, Object> m : list) {

            key = m.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
            for (String str : key) {
            	if(StringUtils.equalsIgnoreCase("tableName", str))continue;
                infoList.add(m.get(str));
                infoListKey.add(str);
            }
            //
            infoListKey.add("TAG_DELETE");
            infoList.add("0");
            //
            entity.put("infoListKey", infoListKey);
            entity.put("infoList", infoList);
            // 插入
            
            standardDAO.insert_tables_info(entity);

            infoList.removeAll(infoList);
            infoListKey.removeAll(infoListKey);
        }
    }
    
    public void update_tables_info(Map<String, Object> entity) throws BusinessException{

        @SuppressWarnings("unchecked")
        List<Map<String, Object>> list = (List<Map<String, Object>>) entity
                .get("updateInfoList");
        entity.remove("updateInfoList");
        for (Map<String, Object> map : list) {
            if (map.keySet() != null) {
                Set<String> key = map.keySet();
                for (Iterator<String> it = key.iterator(); it.hasNext();) {
                    String s = it.next();
                    if (map.get(s) == null) {
                        map.put(s, "");
                    }
                }
            }
        }
        
        Set<String> key = null;
        for (Map<String, Object> m : list) {
        	List<Map<String, Object>> updateList = new ArrayList<Map<String, Object>>();
            key = m.keySet();
            // 将map集合中的key和value 取出来分别放到list集合里
            
			for (String str : key) {
				if (StringUtils.equalsIgnoreCase("CODE_ID",str)) {
					entity.put("CODE_ID", m.get(str));
					continue;
				}else if (StringUtils.equalsIgnoreCase("CODELIST",str)) {
					entity.put("CODELIST", QueryParamUtil.StringToList((String)m.get(str)));
					continue;
				}else if(StringUtils.equalsIgnoreCase("tableName", str))continue;
				Map<String, Object> updateMap = new HashMap<String, Object>();
				updateMap.put("key", str);
				updateMap.put("value", m.get(str));

				updateList.add(updateMap);
			}
			entity.put("info", updateList);
            //
			standardDAO.update_tables_info(entity);

        }
    }
    
    @Override
    public Page<Map<String, Object>> list_tables(int pageNo, int pageSize,Map<String, Object> query)throws BusinessException {

        // 计算起始记录
        int pageStart = (pageNo - 1) * pageSize;

        // 获取列表
        List<Map<String, Object>> items = standardDAO.list_tables(new RowBounds(pageStart, pageSize),query);
        // 获取列表个数
        int count = standardDAO.list_tables_count(query);

        // 创建分页对象
        Page<Map<String, Object>> page = new Page<Map<String, Object>>();
        page.setStart(pageStart);
        page.setLimit(pageSize);
        page.setCount(count);
        page.setItems(items);

        return page;
    }
	
	@Override
    public List<Map<String, Object>> list_tables(Map<String, Object> query)throws BusinessException {
        // 获取列表
        List<Map<String, Object>> list  = standardDAO.list_tables(query);
        return list;
    }

    @Override
    public int list_tables_count(Map<String, Object> query) throws BusinessException{

        return standardDAO.list_tables_count(query);

    }
    
    public void insert2Cache() throws BusinessException{
    	Map<String, Object> query = new HashMap<String,Object>();
    	Map<String, Object> queryData = new HashMap<String,Object>();
    	query.put("FATHER_ID", "0");
    	List<Map<String, Object>> list_all_tables = list_all_tables(query);
    	for(Map<String, Object> entity:list_all_tables){
    		String tname = (String) entity.get("CODE_ID");
    		String cacheName = prefix+"_"+tname;
    		System.out.println("加载["+tname+"]到缓存>>ehcache11>>中......");
    		queryData.put("tableName", tname);
    		List<Map<String, Object>> tableInfo = list_tables_info(queryData);
    		CacheKit.put("ehcache11", cacheName.toUpperCase(), tableInfo);
    		
    	}
    }
    
    @Override
    public List<Map<String, Object>> list_tables_info_cache(Map<String, Object> query)throws BusinessException {
        // 获取列表
    	String keyName = (String) query.get("tableName");
    	List<Map<String, Object>> list = CacheKit.get("ehcache11", prefix+"_"+keyName.toUpperCase());
    	if(list == null){
    		list  = standardDAO.list_tables_info(query);
    		CacheKit.put("ehcache11", prefix+"_"+keyName.toUpperCase(),list);
    	}
        return list;
    }
    
    public void updateCache(Map<String, Object> query)throws BusinessException {
    	String keyName = (String) query.get("tableName");
    	List<Map<String, Object>> list = CacheKit.get("ehcache11", prefix+"_"+keyName.toUpperCase());
    	if(list == null){
    		list  = standardDAO.list_tables_info(query);
    		CacheKit.put("ehcache11", prefix+"_"+keyName.toUpperCase(),list);
    	}else{
    		list  = standardDAO.list_tables_info(query);
    		CacheKit.update("ehcache11", prefix+"_"+keyName.toUpperCase(),list);
    	}
    }

}
