package com.gaowj.standard.utils;

public class CacheKit {
	
    private static org.springframework.cache.support.CompositeCacheManager cacheManager;
	
	public static void setCacheManager(
			org.springframework.cache.support.CompositeCacheManager cacheManager) {
		CacheKit.cacheManager = cacheManager;
	}

	public static org.springframework.cache.support.CompositeCacheManager getCacheManager() {
		return cacheManager;
	}
	
	public static void put(String cacheName,String key,Object obj){
		CacheKit.cacheManager.getCache(cacheName).put(key, obj);
	}
	
	public static <T> T get(String cacheName, Object key){
		return CacheKit.cacheManager.getCache(cacheName).get(key)!=null?
				(T) CacheKit.cacheManager.getCache(cacheName).get(key).get():null;
	}
	
	public static void remove(String cacheName,String key){
		CacheKit.cacheManager.getCache(cacheName).evict(key);
	}
	
	public static void update(String cacheName,String key,Object obj){
		remove(cacheName,key);
		CacheKit.cacheManager.getCache(cacheName).put(key, obj);
	}
}


