package com.gaowj.business;

import java.util.List;
import java.util.Map;

import net.sf.ehcache.Ehcache;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

/**
 * 缓存管理
 * @author 高伟杰
 * @time 2014-09-11
 */
@Service
public interface SystemCacheBusiness {
	
	/**
	 * 清除所有缓存
	 */
	
    public void ClearAllCache() throws BusinessException;
    
    /**
     * 显示缓存列表
     */

    public List<Map<String,Object>> listCache() throws BusinessException;
    
    /**
     * 分页显示缓存列表
     */
    public Page<Map<String, Object>> listCache(int pageNo, int pageSize, Map<String, Object> query);
    
   /**
    * 显示某个Ehcache缓存中的信息列表
    */
    
    public List<Map<String, Object>> listCacheKey(String cacheName) throws BusinessException;
    
    /**
     * 分页显示某个Ehcache缓存中的信息列表
     */
    public Page<Map<String, Object>> listCacheKey(int pageNo, int pageSize, Map<String, Object> query);
    
    /**
     * 卸载某个Ehcache
     */
    public boolean shutdownCache(String cacheName) throws BusinessException;
    
    /**
     * 删除某个Ehcache中某个key值
     */
    public boolean removeCache(String cacheName,String Key) throws BusinessException;
    
    /**
     * 创建Ehcache
     */
    public boolean createCache(String cacheName)throws BusinessException;
}
