package com.gaowj.system.back;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.action.BasicActionMethod;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;
/**
 * 部门操作
 */
public class DepartAction extends BasicAction implements BasicActionMethod{

	
	private static final long serialVersionUID = -1111678333322335298L;
	private List<Map<String,Object>> loginuser;//所有人员

	public List<Map<String, Object>> getLoginuser() {
		return loginuser;
	}

	public void setLoginuser(List<Map<String, Object>> loginuser) {
		this.loginuser = loginuser;
	}

	@Override
	public String grid() throws BusinessException {
		Map<String,Object> query = new HashMap<String,Object>();
		String departid=RequestUtils.getString(request, "departid");
        query.put("DPT_NO", departid);
        
        SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Page<Map<String, Object>> listGrid = systemOpeBusiness.listDepartmentInfo(pageNo, pageSize, query);
		setListdata(listGrid.getItems());
		setPageCount((listGrid.getCount() - 1)/pageSize + 1);
	    return "grid";
	}

	@Override
	public String insert() throws BusinessException {
		getAllLoginuser();
		return "insert";
	}

	@Override
	public String update() throws BusinessException {
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("DPT_NO", ls_myzd_id);
			editdata = systemOpeBusiness.listDepartmentInfo(query).get(0);
		}
		getAllLoginuser();
	    return "update";
	}

	@Override
	public String save() throws BusinessException {
		String method = RequestUtils.getString(request,"method");
		Map<String,Object> data = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(method.equalsIgnoreCase("insert")){
			systemOpeBusiness.insert_depart(data);
		}else if(method.equalsIgnoreCase("update")){
			systemOpeBusiness.update_depart(data);
			editdata = data;
		}
		getAllLoginuser();
		return "save";
	}

	@Override
	public String delete() throws BusinessException {

		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = new HashMap<String,Object>();
		query.put("DPT_NO", ls_myzd_id);
		systemOpeBusiness.delete_depart(query);
		
		Page<Map<String, Object>> listGrid = systemOpeBusiness.listDepartmentInfo(pageNo, pageSize, null);
		setListdata(listGrid.getItems());
		setPageCount((listGrid.getCount() - 1)/pageSize + 1);
	    return "delete";
	}

	@Override
	public String copy() throws BusinessException {
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("DPT_NO", ls_myzd_id);
			editdata = systemOpeBusiness.listDepartmentInfo(query).get(0);
			editdata.remove("DPT_NO");
		}
		getAllLoginuser();
	    return "copy";
	}
	
	public void getAllLoginuser(){
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		loginuser = systemOpeBusiness.listLoginUserInfo(null);
	}

}
