package com.gaowj.system.back;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.action.BasicActionMethod;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;

public class GroupAction extends BasicAction implements BasicActionMethod{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6708395059129131135L;
	
	public String grid() throws BusinessException{
		Map<String,Object> query = new HashMap<String,Object>();
		String g_id=RequestUtils.getString(request, "g_id");
        String g_state=RequestUtils.getString(request, "g_state");
        query.put("G_ID", g_id);
        query.put("G_STATE", g_state);
        
        SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Page<Map<String, Object>> listGroupAll = systemOpeBusiness.listGroupAll(pageNo, pageSize, query);
		setListdata(listGroupAll.getItems());
		setPageCount((listGroupAll.getCount() - 1)/pageSize + 1);
	    return "grid";
	}
	
	public String insert() throws BusinessException{
	    return "insert";
	}
	
	public String update() throws BusinessException{
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("G_ID", ls_myzd_id);
			editdata = systemOpeBusiness.listGroupAll(query).get(0);
		}
	    return "update";
	}
	
	public String save()   throws BusinessException{
		String method = RequestUtils.getString(request,"method");
		Map<String,Object> data = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(method.equalsIgnoreCase("insert")){
			systemOpeBusiness.insert_group(data);
		}else if(method.equalsIgnoreCase("update")){
			systemOpeBusiness.update_group(data);
			editdata = data;
		}
		return "save";
	}
	
	public String delete() throws BusinessException{
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		systemOpeBusiness.delete_group(ls_myzd_id);
		
		Page<Map<String, Object>> listGroupAll = systemOpeBusiness.listGroupAll(pageNo, pageSize, null);
		setListdata(listGroupAll.getItems());
		setPageCount((listGroupAll.getCount() - 1)/pageSize + 1);
	    return "delete";
	}
	
	public String copy() throws BusinessException{
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("G_ID", ls_myzd_id);
			editdata = systemOpeBusiness.listGroupAll(query).get(0);
			editdata.remove("G_ID");
		}
	    return "copy";
	}
}
