package com.gaowj.system.back;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.action.BasicActionMethod;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;

public class ModuleAction extends BasicAction implements BasicActionMethod{

	/**
	 * 具体功能页设置
	 */
	private static final long serialVersionUID = -1111678333322335298L;
	private List<Map<String,Object>> moduletype;

	public List<Map<String, Object>> getModuletype() {
		return moduletype;
	}

	public void setModuletype(List<Map<String, Object>> moduletype) {
		this.moduletype = moduletype;
	}

	@Override
	public String grid() throws BusinessException {
		Map<String,Object> query = new HashMap<String,Object>();
		String m_id=RequestUtils.getString(request, "m_id");
        query.put("M_ID", m_id);
        
        SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Page<Map<String, Object>> listGrid = systemOpeBusiness.listModule(pageNo, pageSize, query);
		setListdata(listGrid.getItems());
		setPageCount((listGrid.getCount() - 1)/pageSize + 1);
	    return "grid";
	}

	@Override
	public String insert() throws BusinessException {
		getModuleType();
		return "insert";
	}

	@Override
	public String update() throws BusinessException {
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("M_ID", ls_myzd_id);
			editdata = systemOpeBusiness.listModule(query).get(0);
		}
		getModuleType();
	    return "update";
	}

	@Override
	public String save() throws BusinessException {
		String method = RequestUtils.getString(request,"method");
		Map<String,Object> data = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(method.equalsIgnoreCase("insert")){
			systemOpeBusiness.insert_module(data);
		}else if(method.equalsIgnoreCase("update")){
			systemOpeBusiness.update_module(data);
			editdata = data;
		}
		getModuleType();
		return "save";
	}

	@Override
	public String delete() throws BusinessException {

		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = new HashMap<String,Object>();
		query.put("M_ID", ls_myzd_id);
		systemOpeBusiness.delete_module(query);
		
		Page<Map<String, Object>> listGrid = systemOpeBusiness.listModule(pageNo, pageSize, null);
		setListdata(listGrid.getItems());
		setPageCount((listGrid.getCount() - 1)/pageSize + 1);
	    return "delete";
	}

	@Override
	public String copy() throws BusinessException {
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("M_ID", ls_myzd_id);
			editdata = systemOpeBusiness.listModule(query).get(0);
			editdata.remove("M_ID");
		}
		getModuleType();
	    return "copy";
	}
	
	public void getModuleType(){
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		moduletype = systemOpeBusiness.listModuleType(null);
	}

}
