package com.gaowj.system.back;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.action.BasicAction;
import com.gaowj.business.action.BasicActionMethod;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;
import com.gaowj.business.util.RequestUtils;

public class ModuleTypeAction extends BasicAction implements BasicActionMethod{

	/**
	 * 功能大类
	 */
	private static final long serialVersionUID = -1111678333322335298L;

	@Override
	public String grid() throws BusinessException {
		Map<String,Object> query = new HashMap<String,Object>();
		String mt_id=RequestUtils.getString(request, "mt_id");
        query.put("MT_ID", mt_id);
        
        SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Page<Map<String, Object>> listGrid = systemOpeBusiness.listModuleType(pageNo, pageSize, query);
		setListdata(listGrid.getItems());
		setPageCount((listGrid.getCount() - 1)/pageSize + 1);
	    return "grid";
	}

	@Override
	public String insert() throws BusinessException {
		return "insert";
	}

	@Override
	public String update() throws BusinessException {
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("MT_ID", ls_myzd_id);
			editdata = systemOpeBusiness.listModuleType(query).get(0);
		}
	    return "update";
	}

	@Override
	public String save() throws BusinessException {
		String method = RequestUtils.getString(request,"method");
		Map<String,Object> data = RequestUtils.getUpdateFieldMap(request,RequestUtils.UPDATEDATAFIELDPREFIX);
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(method.equalsIgnoreCase("insert")){
			systemOpeBusiness.insert_moduleType(data);
		}else if(method.equalsIgnoreCase("update")){
			systemOpeBusiness.update_moduleType(data);
			editdata = data;
		}
		return "save";
	}

	@Override
	public String delete() throws BusinessException {

		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		Map<String,Object> query = new HashMap<String,Object>();
		query.put("MT_ID", ls_myzd_id);
		systemOpeBusiness.delete_moduleType(query);
		
		Page<Map<String, Object>> listGrid = systemOpeBusiness.listModuleType(pageNo, pageSize, null);
		setListdata(listGrid.getItems());
		setPageCount((listGrid.getCount() - 1)/pageSize + 1);
	    return "delete";
	}

	@Override
	public String copy() throws BusinessException {
		String ls_myzd_id=RequestUtils.getString(request,"myzd_id");
		SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
		if(StringUtils.isNotEmpty(ls_myzd_id)){
			Map<String,Object> query = new HashMap<String,Object>();
			query.put("MT_ID", ls_myzd_id);
			editdata = systemOpeBusiness.listModuleType(query).get(0);
			editdata.remove("MT_ID");
		}
	    return "copy";
	}

}
