package com.gaowj.business;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.gaowj.business.exception.BusinessException;
import com.gaowj.business.util.Page;

@Service
public interface StudentBusiness {
	
	/**
	 * 插入
	 * @param entity
	 * @throws BusinessException
	 */
	void insert_student(Map<String,Object> entity) throws BusinessException ;

	/**
	 * 更新
	 * @param entity
	 * @throws BusinessException
	 */
    void update_student(Map<String,Object> entity) throws BusinessException ;
    
    /**
	 * 删除记录
	 * @param entity
	 * @throws BusinessException
	 */
    void delete_student(List<String> list)throws BusinessException;
    
    /**
	 * 分页获取记录
	 * @param entity
	 * @throws BusinessException
	 */
    Page<Map<String, Object>> list_student(int pageNo, int pageSize, Map<String, Object> query)throws BusinessException ;
    
    /**
	 * 获取所有记录
	 * @param entity
	 * @throws BusinessException
	 */
    List<Map<String,Object>> list_student(Map<String, Object> query) throws BusinessException ;
    
    /**
	 * 获取所有记录数
	 * @param entity
	 * @throws BusinessException
	 */
    int listCount_student(Map<String, Object> query) throws BusinessException ;

}
