package com.gaowj.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MacAddress {
	
	private static String ls_adress = "xx-xx-xx-xx-xx-xx";
	private static String ls_charSet = "utf-8";
	
	public static void setLs_adress(String ls_adress) {
		MacAddress.ls_adress = ls_adress;
	}

	public static void setLs_charSet(String ls_charSet) {
		MacAddress.ls_charSet = ls_charSet;
	}

	public static String getOSName() {
		return System.getProperty("os.name").toLowerCase();
	}

	public static String getLinuxMACAddress() {
		String mac = null;
		BufferedReader bufferedReader = null;
		Process process = null;
		try {
			process = Runtime.getRuntime().exec("ifconfig");
			bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(),ls_charSet));
			String line = null;
			int index = -1;
			while ((line = bufferedReader.readLine()) != null) {
				index = line.indexOf(ls_adress);
				System.out.println(line);
				if (index != -1) {
					mac = ls_adress;
					break;
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (bufferedReader != null) {
					bufferedReader.close();
				}
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			bufferedReader = null;
			process = null;
		}
		return mac;
	}

	public static String getWindowsMACAddress() {
		String mac = null;
		BufferedReader bufferedReader = null;
		Process process = null;
		try {
			process = Runtime.getRuntime().exec("ipconfig /all");
			bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(),ls_charSet));
			String line = null;
			int index = -1;
			while ((line = bufferedReader.readLine()) != null) {
				index = line.indexOf(ls_adress);
				System.out.println(line);
				if (index != -1) {
					mac = ls_adress;
					break;
				}
			}
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (bufferedReader != null) {
					bufferedReader.close();
				}
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			bufferedReader = null;
			process = null;
		}
		return mac;
	}

	public static void main(String[] args) {
		String os = getOSName();      
        System.out.println(os);      
        if(os.startsWith("windows")){      
            String mac = getWindowsMACAddress();      
            System.out.println("本地是windows:"+mac);      
        }else{      
            String mac = getLinuxMACAddress();      
            System.out.println("本地是Linux系统,MAC地址是:"+mac);    
        }  
	}

}
