/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.datasource.unpooled;

import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.DataSourceException;
import org.apache.ibatis.datasource.DataSourceFactory;
import org.apache.ibatis.datasource.unpooled.UnpooledDataSource;
import org.apache.ibatis.reflection.MetaObject;

public class UnpooledDataSourceFactory
implements DataSourceFactory {
    private static final String DRIVER_PROPERTY_PREFIX = "driver.";
    private static final int DRIVER_PROPERTY_PREFIX_LENGTH = "driver.".length();
    protected DataSource dataSource = new UnpooledDataSource();

    public void setProperties(Properties properties) {
        Properties driverProperties = new Properties();
        MetaObject metaDataSource = MetaObject.forObject(this.dataSource);
        for (Object key : properties.keySet()) {
            String value;
            String propertyName = (String)key;
            if (propertyName.startsWith(DRIVER_PROPERTY_PREFIX)) {
                value = properties.getProperty(propertyName);
                driverProperties.setProperty(propertyName.substring(DRIVER_PROPERTY_PREFIX_LENGTH), value);
                continue;
            }
            if (metaDataSource.hasSetter(propertyName)) {
                value = (String)properties.get(propertyName);
                Object convertedValue = this.convertValue(metaDataSource, propertyName, value);
                metaDataSource.setValue(propertyName, convertedValue);
                continue;
            }
            throw new DataSourceException("Unknown DataSource property: " + propertyName);
        }
        if (driverProperties.size() > 0) {
            metaDataSource.setValue("driverProperties", driverProperties);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private Object convertValue(MetaObject metaDataSource, String propertyName, String value) {
        Object convertedValue = value;
        Class<?> targetType = metaDataSource.getSetterType(propertyName);
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            convertedValue = Integer.valueOf(value);
        } else if (targetType == Long.class || targetType == Long.TYPE) {
            convertedValue = Long.valueOf(value);
        } else if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            convertedValue = Boolean.valueOf(value);
        }
        return convertedValue;
    }
}

