/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.util;

import com.gaowj.business.SystemOpeBusiness;
import com.gaowj.business.comp.BusinessManager;
import com.gaowj.business.util.FormatHTMLInfo;
import com.gaowj.business.util.Java_tool;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.HTMLLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class FormatHTMLLayout
extends HTMLLayout {
    protected final int BUF_SIZE = 256;
    protected final int MAX_CAPACITY = 1024;
    static String TRACE_PREFIX = "<br>";
    private StringBuffer sbuf = new StringBuffer(256);
    String title = "Log4j-1.2.16 \u65e5\u5fd7\u4fe1\u606f";
    private Map<String, Object> log = new HashMap<String, Object>();
    public static final String TITLE_OPTION = "Title";
    boolean locationInfo = true;
    private Java_tool jt = new Java_tool();

    public String format(LoggingEvent event) {
        String[] s;
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        this.sbuf.append(String.valueOf(Layout.LINE_SEP) + "<tr>" + Layout.LINE_SEP);
        this.sbuf.append("<td width='200px' title=\"\u6267\u884c\u65f6\u95f4\">");
        String logDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
        this.sbuf.append(logDate);
        this.log.put("LOGDATE", this.jt.String3date(logDate));
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"\u7ebf\u7a0b\">");
        String logThread = Transform.escapeTags((String)event.getThreadName());
        this.sbuf.append(logThread);
        this.log.put("LOGTHREAD", logThread);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"\u7ea7\u522b\">");
        String logLevel = Transform.escapeTags((String)String.valueOf(event.getLevel()));
        this.log.put("LOGLEVEL", logLevel);
        if (event.getLevel().equals((Object)Level.FATAL)) {
            this.sbuf.append("<font color=\"#339933\">");
            this.sbuf.append(logLevel);
            this.sbuf.append("</font>");
        } else if (event.getLevel().isGreaterOrEqual((Priority)Level.WARN)) {
            this.sbuf.append("<font color=\"#993300\"><strong>");
            this.sbuf.append(logLevel);
            this.sbuf.append("</strong></font>");
        } else {
            this.sbuf.append("<font color=\"green\">");
            this.sbuf.append(logLevel);
            this.sbuf.append("</font>");
        }
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        String logCategory = Transform.escapeTags((String)event.getLoggerName());
        this.sbuf.append("<td title=\"\u7c7b\u522b\">");
        this.sbuf.append(logCategory);
        this.log.put("LOGCATEGORY", logCategory);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        if (this.locationInfo) {
            LocationInfo locInfo = event.getLocationInformation();
            this.sbuf.append("<td title=\"\u6240\u5728\u884c\">");
            String logLocation = Transform.escapeTags((String)locInfo.getFileName());
            this.sbuf.append(logLocation);
            this.sbuf.append(':');
            this.sbuf.append(locInfo.getLineNumber());
            this.log.put("LOGLOCATION", String.valueOf(logLocation) + ":" + locInfo.getLineNumber());
            this.sbuf.append("</td>" + Layout.LINE_SEP);
        }
        this.sbuf.append("<td title=\"\u4fe1\u606f\">");
        String logMessage = Transform.escapeTags((String)event.getRenderedMessage());
        this.sbuf.append(logMessage);
        this.log.put("LOGMESSAGE", logMessage);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"\u64cd\u4f5c\u4eba\">");
        String userInfo = String.valueOf(FormatHTMLInfo.getEmid()) + " || " + FormatHTMLInfo.getEmname() + " || " + FormatHTMLInfo.getClientip();
        this.sbuf.append(userInfo);
        this.log.put("USERINFO", userInfo);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"\u5ba2\u6237\u7aef\">");
        String clientInfo = String.valueOf(FormatHTMLInfo.getAgentInfo()) + " || " + FormatHTMLInfo.getProtocol() + " || " + FormatHTMLInfo.getLocale();
        this.sbuf.append(clientInfo);
        this.log.put("CLIENTINFO", clientInfo);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("<td title=\"\u670d\u52a1\u5668\">");
        String serverInfo = String.valueOf(FormatHTMLInfo.getLocalName()) + " || " + FormatHTMLInfo.getLocalAddr() + " || " + FormatHTMLInfo.getServerInfo();
        this.sbuf.append(serverInfo);
        this.log.put("SERVERINFO", serverInfo);
        this.sbuf.append("</td>" + Layout.LINE_SEP);
        this.sbuf.append("</tr>" + Layout.LINE_SEP);
        if (event.getNDC() != null) {
            this.sbuf.append("<tr><td bgcolor=\"#EEEEEE\" style=\"font-family: Arial, Helvetica, sans-serif; font-size: 11px;\" colspan=\"9\" title=\"Nested Diagnostic Context\">");
            String logNDC = Transform.escapeTags((String)event.getNDC());
            this.sbuf.append("NDC: " + logNDC);
            this.log.put("LOGNDC", logNDC);
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        if ((s = event.getThrowableStrRep()) != null) {
            this.sbuf.append("<tr><td bgcolor=\"#993300\" style=\"color:White;font-family: Arial, Helvetica, sans-serif; font-size: 11px;\" colspan=\"9\">");
            this.appendThrowableAsHTML(s, this.sbuf);
            this.log.put("LOGTHROWABLE", this.getArray(s));
            this.sbuf.append("</td></tr>" + Layout.LINE_SEP);
        }
        this.saveLogger(this.log);
        return this.sbuf.toString();
    }

    private void appendThrowableAsHTML(String[] s, StringBuffer sbuf) {
        if (s != null) {
            int len = s.length;
            if (len == 0) {
                return;
            }
            sbuf.append(Transform.escapeTags((String)s[0]));
            sbuf.append(Layout.LINE_SEP);
            int i = 1;
            while (i < len) {
                sbuf.append(TRACE_PREFIX);
                sbuf.append(Transform.escapeTags((String)s[i]));
                sbuf.append(Layout.LINE_SEP);
                ++i;
            }
        }
    }

    private String getArray(String[] s) {
        String sb = "";
        int len = s.length;
        if (len == 0) {
            return sb;
        }
        sb = Transform.escapeTags((String)s[0]);
        sb = String.valueOf(sb) + Layout.LINE_SEP;
        int i = 1;
        while (i < len) {
            sb = String.valueOf(sb) + Transform.escapeTags((String)s[i]);
            sb = String.valueOf(sb) + Layout.LINE_SEP;
            ++i;
        }
        return sb;
    }

    public String getHeader() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">" + Layout.LINE_SEP);
        sbuf.append("<html>" + Layout.LINE_SEP);
        sbuf.append("<head>" + Layout.LINE_SEP);
        sbuf.append("<title>" + this.title + "</title>" + Layout.LINE_SEP);
        sbuf.append("<style type=\"text/css\">" + Layout.LINE_SEP);
        sbuf.append("<!--" + Layout.LINE_SEP);
        sbuf.append("body, table {font-family: Arial, Helvetica, sans-serif; font-size: 11px;}" + Layout.LINE_SEP);
        sbuf.append("th {background: #336699; color: #FFFFFF; text-align: left;}" + Layout.LINE_SEP);
        sbuf.append("-->" + Layout.LINE_SEP);
        sbuf.append("</style>" + Layout.LINE_SEP);
        sbuf.append("</head>" + Layout.LINE_SEP);
        sbuf.append("<body bgcolor=\"#FFFFFF\" topmargin=\"6\" leftmargin=\"6\">" + Layout.LINE_SEP);
        sbuf.append("<table cellspacing=\"0\" cellpadding=\"4\" border=\"1\" bordercolor=\"#224466\" width=\"100%\">" + Layout.LINE_SEP);
        sbuf.append("<tr>" + Layout.LINE_SEP);
        sbuf.append("<th>\u6267\u884c\u65f6\u95f4</th>" + Layout.LINE_SEP);
        sbuf.append("<th>\u7ebf\u7a0b</th>" + Layout.LINE_SEP);
        sbuf.append("<th>\u7b49\u7ea7</th>" + Layout.LINE_SEP);
        sbuf.append("<th>\u7c7b\u522b</th>" + Layout.LINE_SEP);
        if (this.locationInfo) {
            sbuf.append("<th>\u6240\u5728\u884c</th>" + Layout.LINE_SEP);
        }
        sbuf.append("<th>\u6d88\u606f</th>" + Layout.LINE_SEP);
        sbuf.append("<th>\u64cd\u4f5c\u4eba</th>" + Layout.LINE_SEP);
        sbuf.append("<th>\u5ba2\u6237\u7aef</th>" + Layout.LINE_SEP);
        sbuf.append("<th>\u670d\u52a1\u5668</th>" + Layout.LINE_SEP);
        sbuf.append("</tr>" + Layout.LINE_SEP);
        return sbuf.toString();
    }

    public void saveLogger(Map<String, Object> log4j) {
        SystemOpeBusiness systemOpeBusiness = BusinessManager.getBusiness(SystemOpeBusiness.class);
        systemOpeBusiness.insert_log4j(log4j);
    }
}

