/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.util;

import com.gaowj.business.util.JsonDateValueProcessor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import org.apache.commons.lang.math.NumberUtils;

public class MapEntityUtil {
    public static final String DATASTORE_DATE_PREFIX = "_DATE_";

    public static Map<String, Object> fromRequestParameters(ServletRequest request) {
        return MapEntityUtil.fromRequestParameters(request, null);
    }

    public static Map<String, Object> fromRequestParameters(ServletRequest request, String[] keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (keys == null || keys.length == 0) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String value = request.getParameter(key);
                map.put(key, value);
            }
        } else {
            int i = 0;
            while (i < keys.length) {
                String key = keys[i];
                String value = request.getParameter(key);
                map.put(key, value);
                ++i;
            }
        }
        return map;
    }

    public static Map<String, Object> lowerFirstKey(Map<String, Object> map) {
        HashMap<String, Object> _map = new HashMap<String, Object>();
        try {
            Set<String> keys = map.keySet();
            for (String key : keys) {
                _map.put(String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1), map.get(key));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return _map;
    }

    private static Object getDataStoreValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof JSONObject) {
            JSONObject json = (JSONObject)value;
            if (json.isNullObject()) {
                return "";
            }
            return value;
        }
        if (value instanceof String && value.toString().startsWith(DATASTORE_DATE_PREFIX)) {
            String str = value.toString().substring(DATASTORE_DATE_PREFIX.length());
            long time = NumberUtils.toLong((String)str, (long)-1L);
            if (time == -1L) {
                return null;
            }
            return new Date(time);
        }
        return value;
    }

    public static List<Map<String, Object>> fromProperties(Properties properties) {
        String keyField = "KEY";
        String valueField = "VALUE";
        return MapEntityUtil.fromProperties(properties, keyField, valueField);
    }

    public static List<Map<String, Object>> fromProperties(Properties properties, String keyField, String valueField) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String key = names.nextElement().toString();
            String value = properties.getProperty(key);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(keyField, key);
            map.put(valueField, value);
            list.add(map);
        }
        return list;
    }

    public static Map<String, Object> fromPOJO(Object pojo) {
        if (pojo == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Class<?> clazz = pojo.getClass();
            while (clazz != null && !clazz.isInterface() && clazz != Object.class) {
                Method[] m = clazz.getDeclaredMethods();
                int i = 0;
                while (i < m.length) {
                    if (m[i].getGenericParameterTypes().length == 0 && m[i].getName().indexOf("get") == 0) {
                        map.put(m[i].getName().substring(3), m[i].invoke(pojo, new Object[0]));
                    }
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static String toJson(List<Map<String, Object>> list) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new JsonDateValueProcessor());
        JSONArray jsonObj = JSONArray.fromObject(list, (JsonConfig)jsonConfig);
        return jsonObj.toString();
    }

    public static String toJson(Map<String, Object> map) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new JsonDateValueProcessor());
        JSONObject jsonObj = JSONObject.fromObject(map, (JsonConfig)jsonConfig);
        return jsonObj.toString();
    }

    public static Object fromPOJO(Map<String, Object> map, Class<?> clazz) {
        Object pojo;
        if (map == null) {
            return null;
        }
        try {
            pojo = clazz.newInstance();
            while (clazz != null && !clazz.isInterface() && clazz != Object.class) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    Field field = clazz.getDeclaredField(entry.getKey());
                    if (field == null) continue;
                    field.setAccessible(true);
                    field.set(pojo, entry.getValue());
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return pojo;
    }

    public static Map<String, Object> fromRIAJSON(JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator it = json.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object value = json.get(key);
            value = MapEntityUtil.getDataStoreValue(value);
            map.put(key, value);
        }
        return map;
    }

    public static void parametersDateFormat(Map<String, Object> parameters) {
        Iterator<String> iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (!(parameters.get(key) instanceof Date)) continue;
            parameters.put(key, DATASTORE_DATE_PREFIX + ((Date)parameters.get(key)).getTime());
        }
    }
}

