/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.vfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileObject;

public class FileUploadFactory {
    private Log logger = LogFactory.getLog(FileUploadFactory.class);

    public void init(Properties prop) {
    }

    public List<FileObject> upload(FileObject baseDir, HttpServletRequest request, long maxMemorySize) {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return null;
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setSizeMax(maxMemorySize);
        return this.upload(baseDir, (RequestContext)new ServletRequestContext(request), (FileUpload)upload);
    }

    public List<FileObject> upload(FileObject baseDir, RequestContext context, FileUpload upload) {
        ArrayList<FileObject> files = null;
        try {
            List items = upload.parseRequest(context);
            files = new ArrayList<FileObject>();
            for (FileItem item : items) {
                FileObject file = this.processUpload(baseDir, item);
                files.add(file);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject processUpload(FileObject baseDir, FileItem item) throws Exception {
        if (item.getName() == null || item.getName().length() == 0) {
            return null;
        }
        FileObject file = null;
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        FileUploadFactory fileUploadFactory = this;
        synchronized (fileUploadFactory) {
            String ext;
            String fileName;
            do {
                ext = this.getFileExt(item.getName());
            } while ((file = baseDir.resolveFile(fileName = String.valueOf(this.generateFileName()) + (ext == null ? "" : "." + ext))).exists());
            file.createFile();
        }
        bos = new BufferedOutputStream(file.getContent().getOutputStream());
        bis = new BufferedInputStream(item.getInputStream());
        IOUtils.copy((InputStream)bis, (OutputStream)bos);
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((OutputStream)bos);
        file.close();
        return file;
    }

    protected String generateFileName() {
        long time = new Date().getTime();
        Random random = new Random();
        int randomInt = random.nextInt(100000);
        String fileName = String.valueOf(String.valueOf(time)) + String.valueOf(randomInt);
        return fileName;
    }

    protected String getFileExt(String fileName) {
        if (fileName == null) {
            return null;
        }
        int idx = fileName.indexOf(".");
        if (idx >= 0) {
            return fileName.substring(idx + 1);
        }
        return null;
    }
}

