/*
 * Decompiled with CFR 0.152.
 */
package com.gaowj.business.vfs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;

public class FileUtil {
    private FileSystemManager fsm = null;

    public FileUtil() {
        try {
            this.fsm = VFS.getManager();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    public FileObject getFile(String path) {
        try {
            return this.fsm.resolveFile(path);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void delete(String path) {
        try {
            FileObject fo = this.fsm.resolveFile(path);
            fo.delete();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }

    public boolean isDirectory(String path) {
        try {
            FileObject fo = this.fsm.resolveFile(path);
            return fo.getType().equals((Object)FileType.FOLDER);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public InputStream getInputStream(String path) {
        try {
            FileObject fo = this.fsm.resolveFile(path);
            return fo.getContent().getInputStream();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getBytes(InputStream input) {
        try {
            return IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream getOutputStream(String path) {
        try {
            FileObject fo = this.fsm.resolveFile(path);
            return fo.getContent().getOutputStream();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isFile(String path) {
        try {
            FileObject fo = this.fsm.resolveFile(path);
            return fo.getType().equals((Object)FileType.FILE);
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean mkdirs(String path) {
        String realPath = "";
        if ((path = path.replaceAll("\\\\", "/")).endsWith("/")) {
            realPath = path;
        } else {
            String fileName;
            int fileNamePoint = path.lastIndexOf("/");
            if (fileNamePoint >= 0) {
                realPath = path.substring(0, fileNamePoint);
            }
            if ((fileName = path.substring(fileNamePoint + 1)).indexOf(".") < 0) {
                realPath = path;
            }
        }
        try {
            FileObject fo = this.fsm.resolveFile(realPath);
            fo.createFolder();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean copyFile(String sourceFilePath, String targetFilePath, boolean overWrite) throws IOException {
        if (StringUtils.isBlank((String)sourceFilePath) || StringUtils.isBlank((String)targetFilePath)) {
            throw new IOException("\u6e90\u6587\u4ef6\u6216\u8005\u76ee\u6807\u6587\u4ef6\u4e3a\u7a7a");
        }
        FileObject from = this.fsm.resolveFile(sourceFilePath);
        FileObject to = this.fsm.resolveFile(targetFilePath);
        if (to.exists() && to.getType() == FileType.FILE) {
            if (overWrite && !to.delete()) {
                throw new IOException("\u76ee\u6807\u6587\u4ef6[" + targetFilePath + "]\u88ab\u4fdd\u62a4\uff0c\u4e0d\u80fd\u88ab\u8986\u76d6\uff01");
            }
            if (!overWrite) {
                throw new IOException("\u76ee\u6807\u6587\u4ef6[" + targetFilePath + "]\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        to.copyFrom(from, Selectors.SELECT_ALL);
        return true;
    }

    public static void main(String[] args) throws IOException {
        String tt = "d:/ttr/rtrte/rr/tt.doc";
        System.out.println(tt.substring(0, tt.lastIndexOf("/") + 1));
        System.out.println(tt.substring(tt.lastIndexOf("/") + 1));
    }

    public boolean moveFile(String srcFile, String targetFile, boolean overWrite) throws IOException {
        if (srcFile.equals(targetFile)) {
            return true;
        }
        FileObject src = this.fsm.resolveFile(srcFile);
        if (StringUtils.isNotBlank((String)srcFile) && !src.exists()) {
            throw new IOException("\u6e90\u6587\u4ef6[" + srcFile + "]\u4e0d\u5b58\u5728");
        }
        FileObject to = this.fsm.resolveFile(targetFile);
        if (to.exists() && to.getType() == FileType.FILE) {
            if (overWrite && !to.delete()) {
                throw new IOException("\u76ee\u6807\u6587\u4ef6[" + targetFile + "]\u88ab\u4fdd\u62a4\uff0c\u4e0d\u80fd\u88ab\u8986\u76d6\uff01");
            }
            if (!overWrite) {
                throw new IOException("\u76ee\u6807\u6587\u4ef6[" + targetFile + "]\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        src.moveTo(to);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject processUpload(FileObject baseDir, String upFileName, String Path2) throws Exception {
        if (StringUtils.isEmpty((String)upFileName)) {
            return null;
        }
        FileObject file = null;
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        FileUtil fileUtil = this;
        synchronized (fileUtil) {
            String ext;
            String fileName;
            do {
                ext = this.getFileExt(upFileName);
            } while ((file = baseDir.resolveFile(fileName = String.valueOf(this.generateFileName()) + (ext == null ? "" : "." + ext))).exists());
            file.createFile();
        }
        bos = new BufferedOutputStream(file.getContent().getOutputStream());
        bis = new BufferedInputStream(new FileInputStream(Path2));
        IOUtils.copy((InputStream)bis, (OutputStream)bos);
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((OutputStream)bos);
        file.close();
        return file;
    }

    public String generateFileName() {
        long time = new Date().getTime();
        Random random = new Random();
        int randomInt = random.nextInt(100000);
        String fileName = String.valueOf(String.valueOf(time)) + String.valueOf(randomInt);
        return fileName;
    }

    public String getFileExt(String fileName) {
        if (fileName == null) {
            return null;
        }
        int idx = fileName.indexOf(".");
        if (idx >= 0) {
            return fileName.substring(idx + 1);
        }
        return null;
    }

    public void download(FileObject file, HttpServletResponse response) {
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            bis = new BufferedInputStream(file.getContent().getInputStream());
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((OutputStream)bos);
            file.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

