/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.struts2.util.MakeIterator;

public class ValueStackDataSource
implements JRRewindableDataSource {
    private static Logger LOG = LoggerFactory.getLogger(ValueStackDataSource.class);
    Iterator iterator;
    ValueStack valueStack;
    String dataSource;
    boolean firstTimeThrough = true;

    public ValueStackDataSource(ValueStack valueStack, String dataSourceParam) {
        this.valueStack = valueStack;
        this.dataSource = dataSourceParam;
        Object dataSourceValue = valueStack.findValue(this.dataSource);
        if (dataSourceValue != null) {
            if (MakeIterator.isIterable((Object)dataSourceValue)) {
                this.iterator = MakeIterator.convert((Object)dataSourceValue);
            } else {
                Object[] array = new Object[]{dataSourceValue};
                this.iterator = MakeIterator.convert((Object)array);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Data source value for data source " + this.dataSource + " was null", new String[0]);
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        String expression = field.getDescription();
        if (expression == null) {
            expression = field.getName();
        }
        Object value = this.valueStack.findValue(expression);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Field [#0] = [#1]", new Object[]{field.getName(), value});
        }
        if (MakeIterator.isIterable((Object)value)) {
            return new ValueStackDataSource(this.valueStack, expression);
        }
        return value;
    }

    public void moveFirst() throws JRException {
        Object dataSourceValue = this.valueStack.findValue(this.dataSource);
        if (dataSourceValue != null) {
            if (MakeIterator.isIterable((Object)dataSourceValue)) {
                this.iterator = MakeIterator.convert((Object)dataSourceValue);
            } else {
                Object[] array = new Object[]{dataSourceValue};
                this.iterator = MakeIterator.convert((Object)array);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Data source value for data source [" + this.dataSource + "] was null", new String[0]);
        }
    }

    public boolean next() throws JRException {
        if (this.firstTimeThrough) {
            this.firstTimeThrough = false;
        } else {
            this.valueStack.pop();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            this.valueStack.push(this.iterator.next());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pushed next value: " + this.valueStack.findValue("."), new String[0]);
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No more values", new String[0]);
        }
        return false;
    }
}

