/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.separator;

import org.springframework.batch.item.file.separator.SimpleRecordSeparatorPolicy;
import org.springframework.util.StringUtils;

public class DefaultRecordSeparatorPolicy
extends SimpleRecordSeparatorPolicy {
    private static final String QUOTE = "\"";
    private static final String CONTINUATION = "\\";
    private String quoteCharacter = "\"";
    private String continuation = "\\";

    public DefaultRecordSeparatorPolicy() {
        this(QUOTE, CONTINUATION);
    }

    public DefaultRecordSeparatorPolicy(String quoteCharacter) {
        this(quoteCharacter, CONTINUATION);
    }

    public DefaultRecordSeparatorPolicy(String quoteCharacter, String continuation) {
        this.continuation = continuation;
        this.quoteCharacter = quoteCharacter;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public boolean isEndOfRecord(String line) {
        return !this.isQuoteUnterminated(line) && !this.isContinued(line);
    }

    public String preProcess(String line) {
        if (this.isQuoteUnterminated(line)) {
            return line + "\n";
        }
        if (this.isContinued(line)) {
            return line.substring(0, line.lastIndexOf(this.continuation));
        }
        return line;
    }

    private boolean isQuoteUnterminated(String line) {
        return StringUtils.countOccurrencesOf((String)line, (String)this.quoteCharacter) % 2 != 0;
    }

    private boolean isContinued(String line) {
        if (line == null) {
            return false;
        }
        return line.trim().endsWith(this.continuation);
    }
}

