/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.base64;

import it.sauronsoftware.base64.Base64InputStream;
import it.sauronsoftware.base64.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64 {
    public static String encode(String string) throws RuntimeException {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = Base64.encode(byArray);
        try {
            return new String(byArray2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII is not supported!", unsupportedEncodingException);
        }
    }

    public static String encode(String string, String string2) throws RuntimeException {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported charset: " + string2, unsupportedEncodingException);
        }
        byte[] byArray2 = Base64.encode(byArray);
        try {
            return new String(byArray2, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII is not supported!", unsupportedEncodingException);
        }
    }

    public static String decode(String string) throws RuntimeException {
        byte[] byArray;
        try {
            byArray = string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII is not supported!", unsupportedEncodingException);
        }
        byte[] byArray2 = Base64.decode(byArray);
        return new String(byArray2);
    }

    public static String decode(String string, String string2) throws RuntimeException {
        byte[] byArray;
        try {
            byArray = string.getBytes("ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII is not supported!", unsupportedEncodingException);
        }
        byte[] byArray2 = Base64.decode(byArray);
        try {
            return new String(byArray2, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported charset: " + string2, unsupportedEncodingException);
        }
    }

    public static byte[] encode(byte[] byArray) throws RuntimeException {
        return Base64.encode(byArray, 0);
    }

    public static byte[] encode(byte[] byArray, int n) throws RuntimeException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Base64.encode(byteArrayInputStream, byteArrayOutputStream, n);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected I/O error", iOException);
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] decode(byte[] byArray) throws RuntimeException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Base64.decode(byteArrayInputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected I/O error", iOException);
        }
        finally {
            try {
                byteArrayInputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                byteArrayOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64.encode(inputStream, outputStream, 0);
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        Base64OutputStream base64OutputStream = new Base64OutputStream(outputStream, n);
        Base64.copy(inputStream, base64OutputStream);
        base64OutputStream.commit();
    }

    public static void decode(InputStream inputStream, OutputStream outputStream) throws IOException {
        Base64.copy(new Base64InputStream(inputStream), outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(File file, File file2, int n) throws IOException {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            Base64.encode(fileInputStream, outputStream, n);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encode(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            Base64.encode(fileInputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decode(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            Base64.decode(fileInputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }
}

