/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.LazyList;

public class BindingHolder {
    private final BindingOrganizer m_organizer;
    private final String m_namespace;
    private final boolean m_elementDefault;
    private final InsertionOrderedSet m_referencedNamespaces;
    private BindingElement m_binding;
    private boolean m_finished;
    private String m_fileName;
    private String m_bindingName;
    private final LazyList m_mappings;

    public BindingHolder(String uri, boolean dflt, BindingOrganizer dir) {
        this.m_organizer = dir;
        this.m_namespace = uri;
        this.m_elementDefault = dflt;
        this.m_referencedNamespaces = new InsertionOrderedSet();
        if (uri != null) {
            this.m_referencedNamespaces.add(uri);
        }
        this.m_binding = new BindingElement();
        this.m_mappings = new LazyList();
    }

    public BindingOrganizer getOrganizer() {
        return this.m_organizer;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getElementDefaultNamespace() {
        return this.m_elementDefault ? this.m_namespace : null;
    }

    public BindingElement getBinding() {
        return this.m_binding;
    }

    public void setBinding(BindingElement bind) {
        this.m_binding = bind;
    }

    private void checkModifiable() {
        if (this.m_finished) {
            throw new IllegalStateException("Internal error - attempt to modify binding after finalized");
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String name) {
        this.m_fileName = name;
    }

    public String getBindingName() {
        return this.m_bindingName;
    }

    public void setBindingName(String name) {
        this.m_bindingName = name;
    }

    public void addMapping(MappingElementBase mapping) {
        this.checkModifiable();
        this.m_mappings.add(mapping);
    }

    public int getMappingCount() {
        return this.m_mappings.size();
    }

    public void addNamespaceDependency(String uri) {
        if (uri != null && !"http://www.w3.org/XML/1998/namespace".equals(uri)) {
            this.checkModifiable();
            if (this.m_referencedNamespaces.add(uri)) {
                this.m_organizer.addNamespaceReference(uri);
            }
        }
    }

    void finish(Collection formats, Collection includes, boolean dfltns, Set nsset, Map nsprefixmap) {
        this.checkModifiable();
        ArrayList topchilds = this.m_binding.topChildren();
        if (this.m_namespace != null && (!nsset.contains(this.m_namespace) || this.m_elementDefault)) {
            NamespaceElement ns = new NamespaceElement();
            ns.setUri(this.m_namespace);
            if (this.m_elementDefault) {
                ns.setDefaultName("elements");
            }
            if (!dfltns) {
                ns.setPrefix((String)nsprefixmap.get(this.m_namespace));
            }
            topchilds.add(ns);
        }
        ArrayList nss = this.m_referencedNamespaces.asList();
        for (int i = 0; i < nss.size(); ++i) {
            String uri = (String)nss.get(i);
            String prefix = (String)nsprefixmap.get(uri);
            this.m_binding.addNamespaceDecl(prefix == null ? "tns" : prefix, uri);
            if (nsset.contains(uri) || prefix == null) continue;
            NamespaceElement ns = new NamespaceElement();
            ns.setUri(uri);
            ns.setPrefix(prefix);
            topchilds.add(ns);
        }
        Iterator iter = formats.iterator();
        while (iter.hasNext()) {
            FormatElement format = (FormatElement)iter.next();
            if (format.getDefaultText() == null && format.getDeserializerName() == null && format.getEnumValueName() == null && format.getSerializerName() == null) continue;
            topchilds.add(format);
        }
        topchilds.addAll(includes);
        topchilds.addAll(this.m_mappings);
        this.m_finished = true;
    }
}

