/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import org.osgi.framework.BundleContext;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

public class OsgiBundleXmlApplicationContextFactory
implements BundleContextAware,
ApplicationContextFactory,
ApplicationContextAware {
    private BundleContext bundleContext;
    private ApplicationContext parent;
    private String path;
    private String displayName;

    public void setPath(String path) {
        this.path = path;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public ConfigurableApplicationContext createApplicationContext() {
        OsgiBundleXmlApplicationContext context = new OsgiBundleXmlApplicationContext(new String[]{this.path}, this.parent);
        String displayName = this.bundleContext.getBundle().getSymbolicName() + ":" + this.displayName;
        context.setDisplayName(displayName);
        context.setBundleContext(this.bundleContext);
        context.refresh();
        return context;
    }

    public String toString() {
        String bundleId = this.bundleContext == null ? null : (this.bundleContext.getBundle() == null ? this.bundleContext.toString() : "" + this.bundleContext.getBundle().getBundleId());
        return "OsgiBundleXmlApplicationContext [path=" + this.path + ", bundle=" + bundleId + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

