/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.Collection;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.support.StepExecutionAggregator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStepExecutionAggregator
implements StepExecutionAggregator {
    @Override
    public void aggregate(StepExecution result, Collection<StepExecution> executions) {
        Assert.notNull((Object)result, (String)"To aggregate into a result it must be non-null.");
        if (executions == null) {
            return;
        }
        for (StepExecution stepExecution : executions) {
            BatchStatus status = stepExecution.getStatus();
            result.setStatus(BatchStatus.max(result.getStatus(), status));
            result.setExitStatus(result.getExitStatus().and(stepExecution.getExitStatus()));
            result.setCommitCount(result.getCommitCount() + stepExecution.getCommitCount());
            result.setRollbackCount(result.getRollbackCount() + stepExecution.getRollbackCount());
            result.setReadCount(result.getReadCount() + stepExecution.getReadCount());
            result.setReadSkipCount(result.getReadSkipCount() + stepExecution.getReadSkipCount());
            result.setWriteCount(result.getWriteCount() + stepExecution.getWriteCount());
            result.setWriteSkipCount(result.getWriteSkipCount() + stepExecution.getWriteSkipCount());
        }
    }
}

