/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryListener;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.RetryState;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.RetryContextCache;
import org.springframework.batch.retry.support.DefaultRetryState;
import org.springframework.batch.retry.support.RetrySynchronizationManager;
import org.springframework.batch.retry.support.RetryTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRetryTemplate
implements RetryOperations {
    private final InnerRetryTemplate delegate = new InnerRetryTemplate();
    private final RetryTemplate regular = new RetryTemplate();

    public <T> T execute(RetryCallback<T> retryCallback, Collection<RetryState> states) throws ExhaustedRetryException, Exception {
        BatchRetryState batchState = new BatchRetryState(states);
        return (T)this.delegate.execute(retryCallback, (RetryState)batchState);
    }

    public <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, Collection<RetryState> states) throws ExhaustedRetryException, Exception {
        BatchRetryState batchState = new BatchRetryState(states);
        return (T)this.delegate.execute(retryCallback, recoveryCallback, (RetryState)batchState);
    }

    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return (T)this.regular.execute(retryCallback, recoveryCallback, retryState);
    }

    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback) throws Exception {
        return (T)this.regular.execute(retryCallback, recoveryCallback);
    }

    public final <T> T execute(RetryCallback<T> retryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return (T)this.regular.execute(retryCallback, retryState);
    }

    public final <T> T execute(RetryCallback<T> retryCallback) throws Exception {
        return (T)this.regular.execute(retryCallback);
    }

    public static List<RetryState> createState(List<?> keys) {
        ArrayList<RetryState> states = new ArrayList<RetryState>();
        for (Object key : keys) {
            states.add((RetryState)new DefaultRetryState(key));
        }
        return states;
    }

    public static List<RetryState> createState(List<?> keys, Classifier<? super Throwable, Boolean> classifier) {
        ArrayList<RetryState> states = new ArrayList<RetryState>();
        for (Object key : keys) {
            states.add((RetryState)new DefaultRetryState(key, classifier));
        }
        return states;
    }

    public void registerListener(RetryListener listener) {
        this.delegate.registerListener(listener);
        this.regular.registerListener(listener);
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.delegate.setBackOffPolicy(backOffPolicy);
        this.regular.setBackOffPolicy(backOffPolicy);
    }

    public void setListeners(RetryListener[] listeners) {
        this.delegate.setListeners(listeners);
        this.regular.setListeners(listeners);
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.delegate.setRetryContextCache(retryContextCache);
        this.regular.setRetryContextCache(retryContextCache);
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        this.regular.setRetryPolicy(retryPolicy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InnerRetryTemplate
    extends RetryTemplate {
        private InnerRetryTemplate() {
        }

        protected boolean canRetry(RetryPolicy retryPolicy, RetryContext context) {
            BatchRetryContext batchContext = (BatchRetryContext)context;
            for (RetryContext nextContext : batchContext.contexts) {
                if (super.canRetry(retryPolicy, nextContext)) continue;
                return false;
            }
            return true;
        }

        protected RetryContext open(RetryPolicy retryPolicy, RetryState state) {
            BatchRetryState batchState = (BatchRetryState)state;
            ArrayList<RetryContext> contexts = new ArrayList<RetryContext>();
            for (RetryState retryState : batchState.keys) {
                contexts.add(super.open(retryPolicy, retryState));
            }
            return new BatchRetryContext(RetrySynchronizationManager.getContext(), contexts);
        }

        protected void registerThrowable(RetryPolicy retryPolicy, RetryState state, RetryContext context, Throwable e) {
            BatchRetryState batchState = (BatchRetryState)state;
            BatchRetryContext batchContext = (BatchRetryContext)context;
            Iterator contextIterator = batchContext.contexts.iterator();
            for (RetryState retryState : batchState.keys) {
                RetryContext nextContext = (RetryContext)contextIterator.next();
                super.registerThrowable(retryPolicy, retryState, nextContext, e);
            }
        }

        protected void close(RetryPolicy retryPolicy, RetryContext context, RetryState state, boolean succeeded) {
            BatchRetryState batchState = (BatchRetryState)state;
            BatchRetryContext batchContext = (BatchRetryContext)context;
            Iterator contextIterator = batchContext.contexts.iterator();
            for (RetryState retryState : batchState.keys) {
                RetryContext nextContext = (RetryContext)contextIterator.next();
                super.close(retryPolicy, nextContext, retryState, succeeded);
            }
        }

        protected <T> T handleRetryExhausted(RecoveryCallback<T> recoveryCallback, RetryContext context, RetryState state) throws Exception {
            BatchRetryState batchState = (BatchRetryState)state;
            BatchRetryContext batchContext = (BatchRetryContext)context;
            Exception rethrowable = null;
            ExhaustedRetryException exhausted = null;
            Iterator contextIterator = batchContext.contexts.iterator();
            for (RetryState retryState : batchState.keys) {
                RetryContext nextContext = (RetryContext)contextIterator.next();
                try {
                    super.handleRetryExhausted(null, nextContext, retryState);
                }
                catch (ExhaustedRetryException e) {
                    exhausted = e;
                }
                catch (Exception e) {
                    rethrowable = e;
                }
            }
            if (recoveryCallback != null) {
                return (T)recoveryCallback.recover(context);
            }
            if (exhausted != null) {
                throw exhausted;
            }
            throw rethrowable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BatchRetryContext
    extends RetryContextSupport {
        private final Collection<RetryContext> contexts;

        public BatchRetryContext(RetryContext parent, Collection<RetryContext> contexts) {
            super(parent);
            this.contexts = contexts;
            int count = 0;
            for (RetryContext context : contexts) {
                int retryCount = context.getRetryCount();
                if (retryCount <= count) continue;
                count = retryCount;
                this.registerThrowable(context.getLastThrowable());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BatchRetryState
    extends DefaultRetryState {
        private final Collection<RetryState> keys;

        public BatchRetryState(Collection<RetryState> keys) {
            super(keys);
            this.keys = new ArrayList<RetryState>(keys);
        }
    }
}

