/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.skip;

import java.util.Collections;
import java.util.Map;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.classify.Classifier;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitCheckingItemSkipPolicy
implements SkipPolicy {
    private int skipLimit;
    private Classifier<Throwable, Boolean> skippableExceptionClassifier;

    public LimitCheckingItemSkipPolicy() {
        this(0, Collections.emptyMap());
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, Map<Class<? extends Throwable>, Boolean> skippableExceptions) {
        this(skipLimit, (Classifier<Throwable, Boolean>)new BinaryExceptionClassifier(skippableExceptions));
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, Classifier<Throwable, Boolean> skippableExceptionClassifier) {
        this.skipLimit = skipLimit;
        this.skippableExceptionClassifier = skippableExceptionClassifier;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkippableExceptionClassifier(Classifier<Throwable, Boolean> skippableExceptionClassifier) {
        this.skippableExceptionClassifier = skippableExceptionClassifier;
    }

    public void setSkippableExceptionMap(Map<Class<? extends Throwable>, Boolean> skippableExceptions) {
        this.skippableExceptionClassifier = new BinaryExceptionClassifier(skippableExceptions);
    }

    @Override
    public boolean shouldSkip(Throwable t, int skipCount) {
        if (((Boolean)this.skippableExceptionClassifier.classify((Object)t)).booleanValue()) {
            if (skipCount < this.skipLimit) {
                return true;
            }
            throw new SkipLimitExceededException(this.skipLimit, t);
        }
        return false;
    }
}

