$.extend({
	jfbrother:{
		/**
		 * loading层通用方法
		 * @returns {String}
		 */
		loadStyle:function(){
			return '<div style="text-align:center;"><img src="'+ctx+'/custom/images/loading.gif" style="width:315px;height:315px;margin:auto;"></div>';
		},
		/**
		 * 根据json的key,value对替换原text文本中的@{key}
		 * example:
		 * 	text='你好,@{name}';
		 * 	replaceByJson(text,{name:"小明"});
		 *  得到:你好,小明
		 * @param text
		 * @param json
		 * @returns
		 */
		replaceByJson:function(text,json){
			for(key in json){
				text = text.replace('@{'+key+'}',json[key]);
			}
			return text;
		},
		/**
		 * url地址,context存放rss的容器,回调函数
		 * @param _url
		 * @param context
		 * @param callback
		 * @returns
		 */
		readRSS:function(_url,context,callback){
			//使用雅虎在线查询处理器
			var YqlUrl='http://query.yahooapis.com/v1/public/yql?q=select%20*%20from%20xml%20where%20url%3D"'+_url+'"&format=json&diagnostics=true&callback=?'  
			var rss;
			$.ajax({
				url:YqlUrl,
				async:false,
				dataType:'json',
				success:function(data){
					if(callback){
						callback(data.query.results,context);
					}
				}
			});
			return rss;
		}
	}
});