$(function(){
	
	//初始化tabs的切换
	init_index_changeTabs();
	
	//动态添加员工信息的
	$('.index_content_right_employee>span:first-child+span').css({
		'width':$('#index_right').width()-($('.index_content_right_employee>span:first-child').width()+$('.index_content_right_employee>span:first-child+span+span').width()+20)-52,
		'lineHeight':'18px'
	});
	//动态添加员工信息的座右铭
	$('.index_employee_text').css({
		'width':$('.index_content_right_employee>span:first-child+span').width()+21,
		'lineHeight':'18px',
		'marginTop':'-2px'
	})
	
	//先取消鼠标移到的效果,避免多次运行hover事件
	$('.index_friendship img').unbind('mouseenter').unbind('mouseleave');
	//友情提示的效果
	$('.index_friendship img').hover(function(){
		var src = $(this).attr('src');
		var index = src.lastIndexOf("_");
		$(this).attr('src',src.substring(0, index)+'.jpg');
	},function(){
		var src = $(this).attr('src');
		var index = src.lastIndexOf(".");
		$(this).attr('src',src.substring(0, index)+'_gray.jpg');
	})
	
	//搜索的效果
	$('.index_search_show_content span').unbind("click").bind('click',function(){
		if($(this).attr('class')=='index_search_show_result_click'){
			return;
		}	
		var index = $('.index_search_show_content span').index($(this));
		/*var oldIndex = $('.index_search_show_content span').index($(this).parent().find('.index_search_show_result_click'));
		$(this).parent().find('.index_search_show_result_click').removeClass('index_search_show_result_click');*/
		$(this).addClass('index_search_show_result_click');
		$(this).data('id',index);
		/*//先删除之前选中的
		$('#index_search_show_result>div').each(function(index,element){
			if($(element).data('id')==oldIndex){
				$(element).remove();
			}
		})*/
		//添加到搜索结果中
		var $div = $('<div class="index_search_show_result_content"><span>'+ $(this).text() +'</span><span onclick="index_search_show_result_remove(this)"><img src="'+ctx+'/custom/images/search_turn off.png" width="10" height="10" /></span></div>');
		$div.data('id',index);
		$('#index_search_show_result').append($div);
		animate_autoHeight($('.index_search_content'));
	})
	
	//动态添加地图容器的高度
	$('.index_content_map_right').css('height',$('.index_content_map_left').css('height'));
	//地图信息
	var map = new BMap.Map("index_map");
	var geolocation = new BMap.Geolocation();
	geolocation.getCurrentPosition(function(r){
		if(this.getStatus() == BMAP_STATUS_SUCCESS){
			var mk = new BMap.Marker(r.point);
			map.addOverlay(mk);
			/*map.panTo(r.point);//地图中心点移到当前位置*/  		
			/*alert('您的位置：'+r.point.lng+','+r.point.lat);*/
			var point = new BMap.Point(r.point.lng,r.point.lat);
			map.centerAndZoom(point,12);
			/*map.enableScrollWheelZoom(true);     //开启鼠标滚轮缩放*/

			// 创建地理编码实例      
			var myGeo = new BMap.Geocoder();      
			// 根据坐标得到地址描述    
			myGeo.getLocation(point, function(result){      
			    if (result){    
			    	var opts = {    
					    /*width : 80,     // 信息窗口宽度    
					    height: 50,     // 信息窗口高度    */
					    title : "您所在的位置:"  // 信息窗口标题   
					}  
					//创建信息窗口对象   
					var infoWindow = new BMap.InfoWindow(result.addressComponents.province + " - " + result.addressComponents.city + " - " + result.addressComponents.district, opts);     
					//打开信息窗口
					map.openInfoWindow(infoWindow, map.getCenter());           
			    }      
			});

		}
		else {
			alert('failed'+this.getStatus());
		}        
	});
	//地图加载完毕时
	map.addEventListener("tilesloaded",function(){
		$('#index_map').prev().fadeOut();
	});
	
	//添加最新消息的left属性
	$('.index_news_banner>.index_news_banner_container').each(function(index,element){
		$(element).css('left',$('.index_content_right').width()*index+'px');
	})
	
	//初始化echarts
	init_index_echarts();
	
	//模块的拖动效果
	$( ".index_module_container" ).sortable({
		handle:'.index_content_left_header',
		cancel:".index_module img,.index_content_middle>div:first-child	",//图片都禁止拖动
		connectWith: ".index_module_container", //可放置的位置
		placeholder: "index_module_sortable", //提示的样式
		opacity: 0.5,//拖动的透明度 
		revert: true, //缓冲效果 
		stop: function(event, ui) {
			index_update_module();
		}
    });
	
	//动态添加添加模块的right属性
	$('.index_insert_module').css('right',$('.index_header').css('marginRight'));
	//鼠标滚动时
	$(window).scroll(function() {
        // 当滚动距离头部100像素时显示图片
        if ($(this).scrollTop()>100) {
        	$('.index_insert_module').fadeIn();
        }
        else{
        	$('.index_insert_module').fadeOut();	
        }
	});
	
	/*//鼠标移到添加模板的效果
	$( ".index_insert_module" ).tooltip({
		  hide: {
		    effect: "explode",
		    delay: 250
		  }
    });*/
	
})

//切换最新消息的效果
function index_news_banner_next(){
	$('.index_news_banner>.index_news_banner_container').each(function(index,element){
		if($(element).is(":animated")){
			return;
		}
		//left=0的元素接到最后一个元素的后面,实现无线循环
		if($(element).css('left')=='0px'){
			$(element).animate({'left':($(element).css('left').substring(0,$(element).css('left').length-2)-$('.index_content_right').width())+'px'},function(){
				$(this).css('left',$('.index_content_right').width()*($('.index_news_banner>.index_news_banner_container').length-1)+'px');
			});
		}
		else{
			$(element).animate({'left':($(element).css('left').substring(0,$(element).css('left').length-2)-$('.index_content_right').width())+'px'});
		}
	})
}

//删除查询条件
function index_search_show_result_remove(handler){
	var oldIndex = $(handler).parent().data('id');
	$(handler).parent().remove();
	animate_autoHeight($('.index_search_content'));
	$('.index_search_show_content span').each(function(index,element){
		if($(element).data('id')==oldIndex){
			$(element).removeClass('index_search_show_result_click');
		}
	})
}

//点击取消时
function index_search_show_result_close(){
	$('.index_search_content').animate({height:'60px'},function(){
		$('.index_content_map').css('zIndex','0');
		if($('.index_search_content>input').val()==''){
			$('.index_search_content>input').val('大数据搜索引擎');
		}
	});
}

//点击搜索时
function index_search(handler){
	$('.index_search_content>input').val('');
	var $obj = $(handler).parent(); 
	$obj.css({"background":"white"});
	animate_autoHeight($obj);
	$('.index_content_map').css('zIndex','-1');
}

//animate 自适应容器的高度
function animate_autoHeight(handler){
	var $obj = $(handler); 
	var currentHeight = $obj.css("height");	
	$obj.css({"height":"auto"});
	var animateHeight = $obj.css("height");
	$obj.css("height", currentHeight);
	$obj.animate({height: animateHeight});
}

//初始化echarts
function init_index_echarts(){
	var myChart = echarts.init(document.getElementById('index_content_echartsContainer'));
	/*option = {
		title:{
			text:'各部门每天办件率情况图表.',
			top:'20px',
			subtext:'查看更多',
			subtextStyle:{
				color: '#6aaeee' 
			},
			textStyle: {
		        fontSize: 12,
		        fontWeight: 'bold',
		        color: '#333'          // 主标题文字颜色
		    },
		    itemGap:0
		},
	    tooltip : {
	        trigger: 'axis',
	        axisPointer : {            // 坐标轴指示器，坐标轴触发有效
	            type : 'line'        // 默认为直线，可选为：'line' | 'shadow'
	        },
	        //自定义鼠标移上去的显示内容
	        formatter:function(params){
	        	var str='';
	        	var num=0;
	        	//先循环获得总值
	        	for(var i = 0 ;i<params.length;i++){
	        		num+=params[i].value;
	        	}
	        	for(var i = 0 ;i<params.length;i++){
	        		if(i == 0){
	        			str+='<span style="margin-left:7px;color:white;">'+ params[i].axisValue +'</span></br>'+ params[i].marker+params[i].seriesName+' : '+ percentNum(params[i].value,num);
	        		}
	        		else{
	        			str+='</br>'+params[i].marker+params[i].seriesName+' : '+ percentNum(params[i].value,num);
	        		}
	        	}
	        	return str;
	        }
	    },
	    legend: {
	        data:['部门1','部门2','部门3'],
	        top:'20px'
	    },
	    toolbox: {
	    	borderColor: '#ccc',       // 工具箱边框颜色
	    	borderWidth: 1,            // 工具箱边框线宽，单位px，默认为0（无边框）
	    	padding: 5,                // 工具箱内边距，单位px，默认各方向内边距为5，
	        show : true,
	        feature : {
	            magicType : {show: true, type: ['line', 'bar','stack', 'tiled']},
	        	magicType : {show: true, type: ['line', 'bar']},
	            restore : {show: true},
	            saveAsImage : {show: true}
	        }
	    },
	    grid: {
	        left: '0%',
	        right: '0%',
	        bottom: '0%',
	        containLabel: true
	    },
	    xAxis : [
	        {
	            type : 'category',
	            boundaryGap: false,
	            data : ['周一','周二','周三','周四','周五','周六','周日'],
	            axisLabel: {
                    textStyle: {
                        color: '#333',
                        fontWeight:'bold' 
                    }
                }
	        }
	    ],
	    yAxis : [
	        {
	            type : 'value',
	            max:100,
	            axisLabel:{
	            	//格式化Y轴的显示
	            	formatter: function (value, index) {
	            		return value+'%';
					},
					color:'#999'
	            }
	        }
	    ],
	    series : [
	        {
	            name:'部门1',
	            type:'line',
	            data:[20, 20, 30, 40, 50, 60, 70],
	            itemStyle:{
	            	color:'#C23630'
	            }
	        },
	        {
	            name:'部门2',
	            type:'line',
	            data:[50, 20, 40, 20, 20, 10, 0],
	            itemStyle:{
	            	color:'#6AAEEE'
	            }
	        },
	        {
	            name:'部门3',
	            type:'line',
	            data:[30, 30, 50, 70, 10, 60, 10],
	            itemStyle:{
	            	color:'#FEAA0B'
	            }
	        }
	    ]
	};
	myChart.setOption(option);*/

	$.get(ctx+'/echarts.json').done(function (data) {
		
		//处理后台接受的数据
		var data = JSON.parse(data);
		for(var i = 0 ;i <data.data.length;i++){
			data.data[i].label={
					"normal": {
	                    "show": "true",
	                    "position": "top"
	                }
			}
			if(data.data[i].type=='line'){
				data.data[i].yAxisIndex=1;
			}
		}
		
		myChart.setOption({
		    tooltip: {
		        trigger: 'axis',
		        axisPointer : {            // 坐标轴指示器，坐标轴触发有效
		            type : 'line'        // 默认为直线，可选为：'line' | 'shadow'
		        }
		    },
		    legend:{
		        data:(function(){
		        	var arr1=[];
		        	for(var i = 0 ; i<data.data.length; i++){
		        		arr1.push(data.data[i].name);
		        	}
		        	return arr1;
		        })(),
		        x : 'center',
		        y : '34px'
		    },
		    grid: {
		        left: '0',
		        right: '0%',
		        //right: '12%',
		        bottom: '12%',
		        top:'100px',
		        containLabel: true
		    },
		    color : ['#C23630','#6AAEEE','#FEAA0B','black'], //调色盘颜色列表。如果系列没有设置颜色，则会依次循环从该列表中取颜色作为系列颜色。
		    toolbox: {
		    	showDelay : 0,			   // 显示延迟，添加显示延迟可以避免频繁切换，单位ms
		    	borderColor: '#ccc',       // 工具箱边框颜色
		    	borderWidth: 1,            // 工具箱边框线宽，单位px，默认为0（无边框）
		    	padding: [5,20],           // 工具箱内边距，单位px，默认各方向内边距为5，
		    	show : true,
		    	itemGap:15,
		        feature : {
		        	mark : {show: true},
		            //magicType : {show: true, type: ['line', 'bar', 'stack', 'tiled']},
		        	magicType : {show: true, type: ['line', 'bar']},
		            restore : {show: true},
		            saveAsImage : {show: true}
		            /*myTool1: {
		                show: true,
		                title: '自定义扩展方法1',
		                icon: 'path://M432.45,595.444c0,2.177-4.661,6.82-11.305,6.82c-6.475,0-11.306-4.567-11.306-6.82s4.852-6.812,11.306-6.812C427.841,588.632,432.452,593.191,432.45,595.444L432.45,595.444z M421.155,589.876c-3.009,0-5.448,2.495-5.448,5.572s2.439,5.572,5.448,5.572c3.01,0,5.449-2.495,5.449-5.572C426.604,592.371,424.165,589.876,421.155,589.876L421.155,589.876z M421.146,591.891c-1.916,0-3.47,1.589-3.47,3.549c0,1.959,1.554,3.548,3.47,3.548s3.469-1.589,3.469-3.548C424.614,593.479,423.062,591.891,421.146,591.891L421.146,591.891zM421.146,591.891',
		                onclick: function (){
		                    alert('myToolHandler1')
		                }
		            }*/
		        },
		        x:'right',
		        y:'30px'
		    },
		    xAxis: {
		        type: 'category',
		        boundaryGap: true,
		        data: ['周一','周二','周三','周四','周五','周六','周日']
		    },
		    dataZoom: [{
		        type: 'inside',
		        start: 0,                                  
		        end: 50,
		        zoomLock:true  //如果设置为 true 则锁定选择区域的大小，也就是说，只能平移，不能缩放。
		    }, {
		        type: 'slider',
		        backgroundColor:'rgba(47,69,84,0)',  //组件的背景颜色  
		        fillerColor:"rgba(167,183,204,0.4)",  //选中范围的填充颜色。
		        borderColor:"#ddd",                     //边框颜色。
		        height:25
		    }],
		    yAxis: [{
		    	type: 'value',
	            name: '数量',
	            min: 0,
	            max:100,
	            interval:20,
	            axisLabel: {
	                formatter: '{value}件'
	            }
		    },{
		    	type: 'value',
	            name: '总数 ',
	            min: 0,
	            max: 150,
	            interval:30,
	            axisLabel: {
	                formatter: '{value} 件'
	            }
		    }],
		    series:(function(){
	    		var arr=[];
	    		for(var i = 0 ; i< data.data.length ; i++){
	    			arr.push(data.data[i]);
	    		}
	    		return arr;
   		   })()
		})
	})
	
}

//小数点后两位百分比
function percentNum(num, num2) { 
	return (Math.round(num / num2 * 10000) / 100.00 + "%"); 
}

//伸缩模块
function index_module_toggle(handler){
	if($(handler).parent().nextAll().is(":animated")){
		return;
	}	
	if($(handler).attr('src')==ctx+'/custom/images/index4_sectionsmall.png'){
		$(handler).attr('src',ctx+'/custom/images/index4_sectionlarge.png');
	}
	else{
		$(handler).attr('src',ctx+'/custom/images/index4_sectionsmall.png');
	}
	$(handler).parent().nextAll().slideToggle();
}

//删除模块
function index_module_remove(handler){
	var txt=  "是否要删除该板块!!!";
	var option = {
		title: "删除提示",
		onOk: function(){
			index_hide_active('shake',$(handler).parent().parent(),function(){
				$(handler).parent().parent().remove();
				index_update_module();
				//出现新增模块提示
				$('.index_insert_module').fadeIn();
			});
		},
		onCancel:function(){
			
		}
	}
	window.wxc.xcConfirm(txt, window.wxc.xcConfirm.typeEnum.warning,option);
}

//修改左中右模块到数据库
function index_update_module(){
	//左边的容器
	var left_container = $('#index_left').html();
	//中间的容器
	var center_container = $('#index_center').html();
	//右边的容器
	var right_container = $('#index_right').html();
	console.log(left_container)
	console.log(center_container)
	console.log(right_container)
	/*$.ajax({
		type:'post',
		url:'1111',
		data:{
			left_container:left_container,
			center_container:center_container,
			right_container:right_container
		},
		success:function(){}
	})*/
}

//显示新增模块的信息
function index_insert_module(){
	//打开fancybox
	$.fancybox.open('<div style="width:300px;" class="index_showModule_container"><div><div><img src="'+ctx+'/custom/images/index_selete_module.png" /></div><img src="'+ctx+'/custom/images/index_module_logo1.png" width="16" height="16" /><span>办事大厅</span></div><div class="index_module_unSelete"><img src="'+ctx+'/custom/images/index_module_logo2.png" width="16" height="16" /><span>消息中心</span></div><div><div><img src="'+ctx+'/custom/images/index_selete_module.png" /></div><img src="'+ctx+'/custom/images/index_module_logo1.png" width="16" height="16" /><span>应用系统</span></div><div><div><img src="'+ctx+'/custom/images/index_selete_module.png" /></div><img src="'+ctx+'/custom/images/index_module_logo2.png" width="16" height="16" /><span>办公区</span></div><div><div><img src="'+ctx+'/custom/images/index_selete_module.png" /></div><img src="'+ctx+'/custom/images/index_module_logo1.png" width="16" height="16" /><span>员工信息</span></div><div class="index_showModule_container_btn"><span>确定</span><span>取消</span></div></div>');
	
	//取消
	$('.index_showModule_container_btn>span:first-child+span').bind('click',function(){
		//关闭fancybox
		$.fancybox.close();
	})
	
	//模块的点击效果
	$('.index_showModule_container>div:not(".index_showModule_container_btn,.index_module_unSelete")').bind('click',function(){
		$(this).toggleClass('index_showModule_container_click');
		$(this).find('div').toggle();
	})
	
	//确定
	$('.index_showModule_container_btn>span:first-child').bind('click',function(){
		$('.index_showModule_container>.index_showModule_container_click').each(function(i,element){
			var clone = '';
			var module_title = $(element).find('span').text();
			$('.index_content_left_header>div:first-child').each(function(index,ele){
				if($(ele).text()==module_title){
					clone = $(ele).parents('.index_module').clone();
					//退出循环
					return false;
				}
			});
			$('#index_left').append(clone);
		})
		//重新初始化tabs的切换效果
		init_index_changeTabs();
		
		//加载到数据库
		index_update_module();
		
		//关闭fancybox
		$.fancybox.close();
		
	})
}

//模块隐藏的效果
function index_hide_active(selectedEffect,handler,callback){
    // 从中获取特效类型
    var selectedEffect = selectedEffect;

    // 大多数的特效类型默认不需要传递选项
    var options = {};
    // 一些特效带有必需的参数
    if ( selectedEffect === "scale" ) {
      options = { percent: 0 };
    } else if ( selectedEffect === "size" ) {
      options = { to: { width: 200, height: 60 } };
    }

    if(typeof callback=='function'){
  	  // 运行特效
        $(handler).hide( selectedEffect, options, 1000 ,callback);
    }
    else{
  	  // 运行特效
        $(handler).hide( selectedEffect, options, 1000 );
    }
}

//模块显示的效果
function index_show_active(selectedEffect,handler,callback){
	// 从中获取特效类型
  var selectedEffect = selectedEffect;

  // 大多数的特效类型默认不需要传递选项
  var options = {};
  // 一些特效带有必需的参数
  if ( selectedEffect === "scale" ) {
    options = { percent: 100 };
  } else if ( selectedEffect === "size" ) {
    options = { to: { width: 280, height: 185 } };
  }

  if(typeof callback=='function'){
  	// 运行特效
  	$(handler).show( selectedEffect, options, 500,callback);
  }
  else{
  	// 运行特效
      $(handler).show( selectedEffect, options, 500);
  }
}

//初始化tabs的切换
function init_index_changeTabs(){
	$('.index_content_left_tabs>span').unbind("click").bind('click',function(){
		if($(this).attr('src')=='index_content_left_tabs_click'){
			return;
		}
		var index = $(this).index();
		//去掉原来的点击样式
		$(this).parent().find('.index_content_left_tabs_click').removeClass('index_content_left_tabs_click');
		$(this).addClass('index_content_left_tabs_click');
		//切换tabs
		$(this).parent().next().find('.show_content').removeClass('show_content').addClass('hide_content');
		$(this).parent().next().find('.hide_content').eq(index).removeClass('hide_content').addClass('show_content')
	})
}